/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.http;

import io.hops.hudi.org.eclipse.jetty.http.Http1FieldPreEncoder;
import io.hops.hudi.org.eclipse.jetty.http.HttpField;
import io.hops.hudi.org.eclipse.jetty.http.HttpFieldPreEncoder;
import io.hops.hudi.org.eclipse.jetty.http.HttpHeader;
import io.hops.hudi.org.eclipse.jetty.http.HttpVersion;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;

public class PreEncodedHttpField
extends HttpField {
    private static final Logger LOG = Log.getLogger(PreEncodedHttpField.class);
    private static final HttpFieldPreEncoder[] __encoders;
    private final byte[][] _encodedField = new byte[2][];

    public PreEncodedHttpField(HttpHeader header, String name, String value) {
        super(header, name, value);
        HttpFieldPreEncoder[] httpFieldPreEncoderArray = __encoders;
        int n = httpFieldPreEncoderArray.length;
        for (int i = 0; i < n; ++i) {
            HttpFieldPreEncoder e;
            this._encodedField[(e = httpFieldPreEncoderArray[i]).getHttpVersion() == HttpVersion.HTTP_2 ? 1 : 0] = e.getEncodedField(header, header.asString(), value);
        }
    }

    public PreEncodedHttpField(HttpHeader header, String value) {
        this(header, header.asString(), value);
    }

    public PreEncodedHttpField(String name, String value) {
        this(null, name, value);
    }

    public void putTo(ByteBuffer bufferInFillMode, HttpVersion version) {
        bufferInFillMode.put(this._encodedField[version == HttpVersion.HTTP_2 ? 1 : 0]);
    }

    static {
        ArrayList<HttpFieldPreEncoder> encoders = new ArrayList<HttpFieldPreEncoder>();
        Iterator<HttpFieldPreEncoder> iter = ServiceLoader.load(HttpFieldPreEncoder.class, PreEncodedHttpField.class.getClassLoader()).iterator();
        while (iter.hasNext()) {
            try {
                encoders.add(iter.next());
            }
            catch (Error | RuntimeException e) {
                LOG.debug(e);
            }
        }
        if (encoders.size() == 0) {
            encoders.add(new Http1FieldPreEncoder());
        }
        LOG.debug("HttpField encoders loaded: {}", encoders);
        __encoders = encoders.toArray(new HttpFieldPreEncoder[encoders.size()]);
    }
}

