/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.security.authentication;

import io.hops.hudi.org.eclipse.jetty.security.Authenticator;
import io.hops.hudi.org.eclipse.jetty.security.IdentityService;
import io.hops.hudi.org.eclipse.jetty.security.LoginService;
import io.hops.hudi.org.eclipse.jetty.server.Request;
import io.hops.hudi.org.eclipse.jetty.server.Response;
import io.hops.hudi.org.eclipse.jetty.server.UserIdentity;
import io.hops.hudi.org.eclipse.jetty.server.session.AbstractSession;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = Log.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    @Override
    public void prepareRequest(ServletRequest request) {
    }

    public UserIdentity login(String username, Object password, ServletRequest request) {
        UserIdentity user = this._loginService.login(username, password, request);
        if (user != null) {
            this.renewSession((HttpServletRequest)request, request instanceof Request ? ((Request)request).getResponse() : null);
            return user;
        }
        return null;
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + this + " in " + configuration);
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + this + " in " + configuration);
        }
        this._renewSession = configuration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession httpSession = request.getSession(false);
        if (this._renewSession && httpSession != null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (httpSession.getAttribute("io.hops.hudi.org.eclipse.jetty.security.sessionCreatedSecure") != Boolean.TRUE) {
                    if (httpSession instanceof AbstractSession) {
                        AbstractSession abstractSession = (AbstractSession)httpSession;
                        String oldId = abstractSession.getId();
                        abstractSession.renewId(request);
                        abstractSession.setAttribute("io.hops.hudi.org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
                        if (abstractSession.isIdChanged() && response != null && response instanceof Response) {
                            ((Response)response).addCookie(abstractSession.getSessionManager().getSessionCookie(abstractSession, request.getContextPath(), request.isSecure()));
                        }
                        LOG.debug("renew {}->{}", oldId, abstractSession.getId());
                    } else {
                        LOG.warn("Unable to renew session " + httpSession, new Object[0]);
                    }
                    return httpSession;
                }
            }
        }
        return httpSession;
    }
}

