/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.util;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class HttpCookieStore
implements CookieStore {
    private final CookieStore delegate = new CookieManager().getCookieStore();

    @Override
    public void add(URI uri2, HttpCookie cookie) {
        this.delegate.add(uri2, cookie);
    }

    @Override
    public List<HttpCookie> get(URI uri2) {
        return this.delegate.get(uri2);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.delegate.getCookies();
    }

    @Override
    public List<URI> getURIs() {
        return this.delegate.getURIs();
    }

    @Override
    public boolean remove(URI uri2, HttpCookie cookie) {
        return this.delegate.remove(uri2, cookie);
    }

    @Override
    public boolean removeAll() {
        return this.delegate.removeAll();
    }

    public static class Empty
    implements CookieStore {
        @Override
        public void add(URI uri2, HttpCookie cookie) {
        }

        @Override
        public List<HttpCookie> get(URI uri2) {
            return Collections.emptyList();
        }

        @Override
        public List<HttpCookie> getCookies() {
            return Collections.emptyList();
        }

        @Override
        public List<URI> getURIs() {
            return Collections.emptyList();
        }

        @Override
        public boolean remove(URI uri2, HttpCookie cookie) {
            return false;
        }

        @Override
        public boolean removeAll() {
            return false;
        }
    }
}

