/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.webapp;

import io.hops.hudi.org.eclipse.jetty.util.ConcurrentHashSet;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedObject;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedOperation;
import io.hops.hudi.org.eclipse.jetty.webapp.WebAppClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;

@ManagedObject
public class CachingWebAppClassLoader
extends WebAppClassLoader {
    private final ConcurrentHashSet<String> _notFound = new ConcurrentHashSet();
    private final ConcurrentHashMap<String, URL> _cache = new ConcurrentHashMap();

    public CachingWebAppClassLoader(ClassLoader parent, WebAppClassLoader.Context context) throws IOException {
        super(parent, context);
    }

    public CachingWebAppClassLoader(WebAppClassLoader.Context context) throws IOException {
        super(context);
    }

    @Override
    public URL getResource(String name) {
        if (this._notFound.contains(name)) {
            return null;
        }
        URL url2 = this._cache.get(name);
        if (name == null) {
            url2 = super.getResource(name);
            if (url2 == null) {
                this._notFound.add(name);
            } else {
                this._cache.putIfAbsent(name, url2);
            }
        }
        return url2;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this._notFound.contains(name)) {
            throw new ClassNotFoundException(name + ": in notfound cache");
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException nfe) {
            this._notFound.add(name);
            throw nfe;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this._notFound.contains(name)) {
            throw new ClassNotFoundException(name + ": in notfound cache");
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException nfe) {
            this._notFound.add(name);
            throw nfe;
        }
    }

    @ManagedOperation
    public void clearCache() {
        this._cache.clear();
        this._notFound.clear();
    }

    @Override
    public String toString() {
        return "Caching[" + super.toString() + "]";
    }
}

