/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.client;

import io.hops.hudi.org.eclipse.jetty.util.B64Code;
import io.hops.hudi.org.eclipse.jetty.util.LazyList;
import io.hops.hudi.org.eclipse.jetty.util.MultiMap;
import io.hops.hudi.org.eclipse.jetty.util.StringUtil;
import io.hops.hudi.org.eclipse.jetty.util.UrlEncoded;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import io.hops.hudi.org.eclipse.jetty.websocket.api.UpgradeRequest;
import io.hops.hudi.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;

public class ClientUpgradeRequest
extends UpgradeRequest {
    private static final Logger LOG = Log.getLogger(ClientUpgradeRequest.class);
    private static final Set<String> FORBIDDEN_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final String key = this.genRandomKey();

    public ClientUpgradeRequest() {
    }

    protected ClientUpgradeRequest(URI requestURI) {
        super(requestURI);
    }

    public String generate() {
        List<HttpCookie> cookies;
        boolean needDelim;
        URI uri2 = this.getRequestURI();
        StringBuilder request = new StringBuilder(512);
        request.append("GET ");
        if (StringUtil.isBlank(uri2.getPath())) {
            request.append("/");
        } else {
            request.append(uri2.getPath());
        }
        if (StringUtil.isNotBlank(uri2.getRawQuery())) {
            request.append("?").append(uri2.getRawQuery());
        }
        request.append(" HTTP/1.1\r\n");
        request.append("Host: ").append(uri2.getHost());
        if (uri2.getPort() > 0) {
            request.append(':').append(uri2.getPort());
        }
        request.append("\r\n");
        request.append("Upgrade: websocket\r\n");
        request.append("Connection: Upgrade\r\n");
        request.append("Sec-WebSocket-Key: ").append(this.key).append("\r\n");
        request.append("Sec-WebSocket-Version: 13\r\n");
        request.append("Pragma: no-cache\r\n");
        request.append("Cache-Control: no-cache\r\n");
        if (!this.getExtensions().isEmpty()) {
            request.append("Sec-WebSocket-Extensions: ");
            needDelim = false;
            for (ExtensionConfig extensionConfig : this.getExtensions()) {
                if (needDelim) {
                    request.append(", ");
                }
                request.append(extensionConfig.getParameterizedName());
                needDelim = true;
            }
            request.append("\r\n");
        }
        if (!this.getSubProtocols().isEmpty()) {
            request.append("Sec-WebSocket-Protocol: ");
            needDelim = false;
            for (String string : this.getSubProtocols()) {
                if (needDelim) {
                    request.append(", ");
                }
                request.append(string);
                needDelim = true;
            }
            request.append("\r\n");
        }
        if ((cookies = this.getCookies()) != null && cookies.size() > 0) {
            request.append("Cookie: ");
            boolean needDelim2 = false;
            for (HttpCookie cookie : cookies) {
                if (needDelim2) {
                    request.append("; ");
                }
                request.append(cookie.getName()).append("=");
                if (cookie.getVersion() == 1) {
                    request.append('\"').append(cookie.getValue()).append('\"');
                } else {
                    request.append(cookie.getValue());
                }
                needDelim2 = true;
            }
            request.append("\r\n");
        }
        for (String string : this.getHeaders().keySet()) {
            if (FORBIDDEN_HEADERS.contains(string)) {
                LOG.debug("Skipping forbidden header - {}", string);
                continue;
            }
            request.append(string).append(": ");
            request.append(this.getHeader(string));
            request.append("\r\n");
        }
        request.append("\r\n");
        return request.toString();
    }

    private final String genRandomKey() {
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        return new String(B64Code.encode(bytes));
    }

    public String getKey() {
        return this.key;
    }

    public void setCookiesFrom(CookieStore cookieStore2) {
        if (cookieStore2 == null) {
            return;
        }
        List<HttpCookie> existing = this.getCookies();
        List<HttpCookie> extra = cookieStore2.get(this.getRequestURI());
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        if (LazyList.hasEntry(existing)) {
            cookies.addAll(existing);
        }
        if (LazyList.hasEntry(extra)) {
            cookies.addAll(extra);
        }
        this.setCookies(cookies);
    }

    @Override
    public void setRequestURI(URI uri2) {
        super.setRequestURI(uri2);
        HashMap<String, List<String>> pmap = new HashMap<String, List<String>>();
        String query = uri2.getQuery();
        if (StringUtil.isNotBlank(query)) {
            MultiMap<String> params = new MultiMap<String>();
            UrlEncoded.decodeTo(uri2.getQuery(), params, StandardCharsets.UTF_8);
            for (String key : params.keySet()) {
                List<String> values2 = params.getValues(key);
                if (values2 == null) {
                    pmap.put(key, new ArrayList());
                    continue;
                }
                ArrayList<String> copy = new ArrayList<String>();
                copy.addAll(values2);
                pmap.put(key, copy);
            }
            super.setParameterMap(pmap);
        }
    }

    static {
        FORBIDDEN_HEADERS.add("cookie");
        FORBIDDEN_HEADERS.add("upgrade");
        FORBIDDEN_HEADERS.add("host");
        FORBIDDEN_HEADERS.add("connection");
        FORBIDDEN_HEADERS.add("sec-websocket-key");
        FORBIDDEN_HEADERS.add("sec-websocket-extensions");
        FORBIDDEN_HEADERS.add("sec-websocket-accept");
        FORBIDDEN_HEADERS.add("sec-websocket-protocol");
        FORBIDDEN_HEADERS.add("sec-websocket-version");
        FORBIDDEN_HEADERS.add("pragma");
        FORBIDDEN_HEADERS.add("cache-control");
    }
}

