/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.common;

import io.hops.hudi.org.eclipse.jetty.io.ByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.io.Connection;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedAttribute;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedObject;
import io.hops.hudi.org.eclipse.jetty.util.component.ContainerLifeCycle;
import io.hops.hudi.org.eclipse.jetty.util.component.Dumpable;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import io.hops.hudi.org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import io.hops.hudi.org.eclipse.jetty.websocket.api.BatchMode;
import io.hops.hudi.org.eclipse.jetty.websocket.api.CloseException;
import io.hops.hudi.org.eclipse.jetty.websocket.api.CloseStatus;
import io.hops.hudi.org.eclipse.jetty.websocket.api.RemoteEndpoint;
import io.hops.hudi.org.eclipse.jetty.websocket.api.Session;
import io.hops.hudi.org.eclipse.jetty.websocket.api.SuspendToken;
import io.hops.hudi.org.eclipse.jetty.websocket.api.UpgradeRequest;
import io.hops.hudi.org.eclipse.jetty.websocket.api.UpgradeResponse;
import io.hops.hudi.org.eclipse.jetty.websocket.api.WebSocketBehavior;
import io.hops.hudi.org.eclipse.jetty.websocket.api.WebSocketException;
import io.hops.hudi.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import io.hops.hudi.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import io.hops.hudi.org.eclipse.jetty.websocket.api.extensions.Frame;
import io.hops.hudi.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import io.hops.hudi.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import io.hops.hudi.org.eclipse.jetty.websocket.common.CloseInfo;
import io.hops.hudi.org.eclipse.jetty.websocket.common.ConnectionState;
import io.hops.hudi.org.eclipse.jetty.websocket.common.LogicalConnection;
import io.hops.hudi.org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import io.hops.hudi.org.eclipse.jetty.websocket.common.events.EventDriver;
import io.hops.hudi.org.eclipse.jetty.websocket.common.io.IOState;
import io.hops.hudi.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import io.hops.hudi.org.eclipse.jetty.websocket.common.scopes.WebSocketSessionScope;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

@ManagedObject(value="A Jetty WebSocket Session")
public class WebSocketSession
extends ContainerLifeCycle
implements Session,
WebSocketSessionScope,
IncomingFrames,
Connection.Listener,
IOState.ConnectionStateListener {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private static final Logger LOG_OPEN = Log.getLogger(WebSocketSession.class.getName() + "_OPEN");
    private final WebSocketContainerScope containerScope;
    private final URI requestURI;
    private final LogicalConnection connection;
    private final EventDriver websocket;
    private final Executor executor;
    private ClassLoader classLoader;
    private ExtensionFactory extensionFactory;
    private String protocolVersion;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private WebSocketRemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private WebSocketPolicy policy;
    private UpgradeRequest upgradeRequest;
    private UpgradeResponse upgradeResponse;

    public WebSocketSession(WebSocketContainerScope containerScope, URI requestURI, EventDriver websocket, LogicalConnection connection) {
        Objects.requireNonNull(containerScope, "Container Scope cannot be null");
        Objects.requireNonNull(requestURI, "Request URI cannot be null");
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.containerScope = containerScope;
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.executor = connection.getExecutor();
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        this.connection.getIOState().addListener(this);
        this.policy = containerScope.getPolicy();
        this.addBean(this.connection);
        this.addBean(this.websocket);
    }

    @Override
    public void close() {
        this.connection.close(1000, null);
    }

    @Override
    public void close(CloseStatus closeStatus) {
        this.close(closeStatus.getCode(), closeStatus.getPhrase());
    }

    @Override
    public void close(int statusCode, String reason) {
        this.connection.close(statusCode, reason);
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        this.notifyClose(1006, "Harsh disconnect");
    }

    public void dispatch(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @Override
    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting - {}", this);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stopping - {}", this);
        }
        if (this.getConnection() != null) {
            try {
                this.getConnection().close(1001, "Shutdown");
            }
            catch (Throwable t) {
                LOG.debug("During Connection Shutdown", t);
            }
        }
        super.doStop();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        out.append(indent).append(" +- incomingHandler : ");
        if (this.incomingHandler instanceof Dumpable) {
            ((Dumpable)((Object)this.incomingHandler)).dump(out, indent + "    ");
        } else {
            out.append(this.incomingHandler.toString()).append(System.lineSeparator());
        }
        out.append(indent).append(" +- outgoingHandler : ");
        if (this.outgoingHandler instanceof Dumpable) {
            ((Dumpable)((Object)this.outgoingHandler)).dump(out, indent + "    ");
        } else {
            out.append(this.outgoingHandler.toString()).append(System.lineSeparator());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketSession other = (WebSocketSession)obj;
        return !(this.connection == null ? other.connection != null : !this.connection.equals(other.connection));
    }

    public ByteBufferPool getBufferPool() {
        return this.connection.getBufferPool();
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    @Override
    public WebSocketContainerScope getContainerScope() {
        return this.containerScope;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    @Override
    public long getIdleTimeout() {
        return this.connection.getMaxIdleTimeout();
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public RemoteEndpoint getRemote() {
        ConnectionState state;
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.getRemote()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if ((state = this.connection.getIOState().getConnectionState()) == ConnectionState.OPEN || state == ConnectionState.CONNECTED) {
            return this.remote;
        }
        throw new WebSocketException("RemoteEndpoint unavailable, current state [" + (Object)((Object)state) + "], expecting [OPEN or CONNECTED]");
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    @Override
    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    @Override
    public WebSocketSession getWebSocketSession() {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        return result;
    }

    @Override
    public void incomingError(Throwable t) {
        if (this.connection.getIOState().isInputAvailable()) {
            this.websocket.incomingError(t);
        }
    }

    @Override
    public void incomingFrame(Frame frame) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (this.connection.getIOState().isInputAvailable()) {
                this.incomingHandler.incomingFrame(frame);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isOpen();
    }

    @Override
    public boolean isSecure() {
        if (this.upgradeRequest == null) {
            throw new IllegalStateException("No valid UpgradeRequest yet");
        }
        URI requestURI = this.upgradeRequest.getRequestURI();
        return "wss".equalsIgnoreCase(requestURI.getScheme());
    }

    public void notifyClose(int statusCode, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifyClose({},{})", statusCode, reason);
        }
        this.websocket.onClose(new CloseInfo(statusCode, reason));
    }

    public void notifyError(Throwable cause) {
        this.incomingError(cause);
    }

    @Override
    public void onClosed(Connection connection) {
    }

    @Override
    public void onOpened(Connection connection) {
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.onOpened()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        this.open();
    }

    @Override
    public void onConnectionStateChange(ConnectionState state) {
        switch (state) {
            case CLOSED: {
                IOState ioState = this.connection.getIOState();
                CloseInfo close = ioState.getCloseInfo();
                this.notifyClose(close.getStatusCode(), close.getReason());
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}.onSessionClosed()", this.containerScope.getClass().getSimpleName());
                    }
                    this.containerScope.onSessionClosed(this);
                }
                catch (Throwable t) {
                    LOG.ignore(t);
                }
                break;
            }
            case CONNECTED: {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}.onSessionOpened()", this.containerScope.getClass().getSimpleName());
                    }
                    this.containerScope.onSessionOpened(this);
                    break;
                }
                catch (Throwable t) {
                    LOG.ignore(t);
                }
            }
        }
    }

    public void open() {
        if (LOG_OPEN.isDebugEnabled()) {
            LOG_OPEN.debug("[{}] {}.open()", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName()});
        }
        if (this.remote != null) {
            return;
        }
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(this.classLoader);){
            this.connection.getIOState().onConnected();
            this.remote = new WebSocketRemoteEndpoint(this.connection, this.outgoingHandler, this.getBatchMode());
            if (LOG_OPEN.isDebugEnabled()) {
                LOG_OPEN.debug("[{}] {}.open() remote={}", new Object[]{this.policy.getBehavior(), this.getClass().getSimpleName(), this.remote});
            }
            this.websocket.openSession(this);
            this.connection.getIOState().onOpened();
            if (LOG.isDebugEnabled()) {
                LOG.debug("open -> {}", this.dump());
            }
        }
        catch (CloseException ce) {
            LOG.warn(ce);
            this.close(ce.getStatusCode(), ce.getMessage());
        }
        catch (Throwable t) {
            LOG.warn(t);
            int statusCode = 1011;
            if (this.policy.getBehavior() == WebSocketBehavior.CLIENT) {
                statusCode = 1008;
            }
            this.close(statusCode, t.getMessage());
        }
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    @Override
    public void setIdleTimeout(long ms) {
        this.connection.setMaxIdleTimeout(ms);
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    public void setUpgradeRequest(UpgradeRequest request) {
        this.upgradeRequest = request;
        this.protocolVersion = request.getProtocolVersion();
        this.parameterMap.clear();
        if (request.getParameterMap() != null) {
            for (Map.Entry<String, List<String>> entry : request.getParameterMap().entrySet()) {
                List<String> values2 = entry.getValue();
                if (values2 != null) {
                    this.parameterMap.put(entry.getKey(), values2.toArray(new String[values2.size()]));
                    continue;
                }
                this.parameterMap.put(entry.getKey(), new String[0]);
            }
        }
    }

    public void setUpgradeResponse(UpgradeResponse response) {
        this.upgradeResponse = response;
    }

    @Override
    public SuspendToken suspend() {
        return this.connection.suspend();
    }

    public BatchMode getBatchMode() {
        return BatchMode.AUTO;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",behavior=").append((Object)this.policy.getBehavior());
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }
}

