/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.common.extensions.compress;

import io.hops.hudi.org.eclipse.jetty.websocket.api.BadPayloadException;
import io.hops.hudi.org.eclipse.jetty.websocket.api.extensions.Frame;
import io.hops.hudi.org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import io.hops.hudi.org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;
import java.util.zip.DataFormatException;

public class DeflateFrameExtension
extends CompressExtension {
    @Override
    public String getName() {
        return "deflate-frame";
    }

    @Override
    int getRsvUseMode() {
        return 0;
    }

    @Override
    int getTailDropMode() {
        return 1;
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (frame.getType().isControl() || !frame.isRsv1() || !frame.hasPayload()) {
            this.nextIncomingFrame(frame);
            return;
        }
        try {
            ByteAccumulator accumulator = this.newByteAccumulator();
            this.decompress(accumulator, frame.getPayload());
            this.decompress(accumulator, TAIL_BYTES_BUF.slice());
            this.forwardIncoming(frame, accumulator);
        }
        catch (DataFormatException e) {
            throw new BadPayloadException(e);
        }
    }
}

