/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.server;

import io.hops.hudi.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import io.hops.hudi.org.eclipse.jetty.websocket.common.AcceptHash;
import io.hops.hudi.org.eclipse.jetty.websocket.server.WebSocketHandshake;
import io.hops.hudi.org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import io.hops.hudi.org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import java.io.IOException;

public class HandshakeRFC6455
implements WebSocketHandshake {
    public static final int VERSION = 13;

    @Override
    public void doHandshakeResponse(ServletUpgradeRequest request, ServletUpgradeResponse response) throws IOException {
        String value;
        String key = request.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            throw new IllegalStateException("Missing request header 'Sec-WebSocket-Key'");
        }
        response.setHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        response.addHeader("Sec-WebSocket-Accept", AcceptHash.hashKey(key));
        if (response.getExtensions() != null && (value = ExtensionConfig.toHeaderValue(response.getExtensions())) != null) {
            response.addHeader("Sec-WebSocket-Extensions", value);
        }
        request.complete();
        response.setStatus(101);
        response.complete();
    }
}

