/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.server;

import io.hops.hudi.org.eclipse.jetty.http.pathmap.MappedResource;
import io.hops.hudi.org.eclipse.jetty.http.pathmap.PathMappings;
import io.hops.hudi.org.eclipse.jetty.http.pathmap.PathSpec;
import io.hops.hudi.org.eclipse.jetty.io.ByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.io.MappedByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.servlet.FilterHolder;
import io.hops.hudi.org.eclipse.jetty.servlet.ServletContextHandler;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedAttribute;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedObject;
import io.hops.hudi.org.eclipse.jetty.util.component.ContainerLifeCycle;
import io.hops.hudi.org.eclipse.jetty.util.component.Dumpable;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import io.hops.hudi.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import io.hops.hudi.org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import io.hops.hudi.org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import io.hops.hudi.org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ManagedObject(value="WebSocket Upgrade Filter")
public class WebSocketUpgradeFilter
extends ContainerLifeCycle
implements Filter,
MappedWebSocketCreator,
Dumpable {
    public static final String CONTEXT_ATTRIBUTE_KEY = "contextAttributeKey";
    private static final Logger LOG = Log.getLogger(WebSocketUpgradeFilter.class);
    private final WebSocketServerFactory factory;
    private final PathMappings<WebSocketCreator> pathmap = new PathMappings();
    private String fname;
    private boolean alreadySetToAttribute = false;

    public static WebSocketUpgradeFilter configureContext(ServletContextHandler context) throws ServletException {
        WebSocketUpgradeFilter filter = (WebSocketUpgradeFilter)context.getAttribute(WebSocketUpgradeFilter.class.getName());
        if (filter != null) {
            return filter;
        }
        filter = new WebSocketUpgradeFilter();
        filter.setToAttribute(context, WebSocketUpgradeFilter.class.getName());
        String name = "Jetty_WebSocketUpgradeFilter";
        String pathSpec = "/*";
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST);
        FilterHolder fholder = new FilterHolder(filter);
        fholder.setName(name);
        fholder.setAsyncSupported(true);
        fholder.setInitParameter(CONTEXT_ATTRIBUTE_KEY, WebSocketUpgradeFilter.class.getName());
        context.addFilter(fholder, pathSpec, dispatcherTypes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding [{}] {} mapped to {} to {}", name, filter, pathSpec, context);
        }
        return filter;
    }

    public static WebSocketUpgradeFilter configureContext(ServletContext context) throws ServletException {
        WebSocketUpgradeFilter filter = (WebSocketUpgradeFilter)context.getAttribute(WebSocketUpgradeFilter.class.getName());
        if (filter != null) {
            return filter;
        }
        filter = new WebSocketUpgradeFilter();
        filter.setToAttribute(context, WebSocketUpgradeFilter.class.getName());
        String name = "Jetty_Dynamic_WebSocketUpgradeFilter";
        String pathSpec = "/*";
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST);
        boolean isMatchAfter = false;
        String[] urlPatterns = new String[]{pathSpec};
        FilterRegistration.Dynamic dyn = context.addFilter(name, (Filter)filter);
        dyn.setAsyncSupported(true);
        dyn.setInitParameter(CONTEXT_ATTRIBUTE_KEY, WebSocketUpgradeFilter.class.getName());
        dyn.addMappingForUrlPatterns(dispatcherTypes, isMatchAfter, urlPatterns);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding [{}] {} mapped to {} to {}", name, filter, pathSpec, context);
        }
        return filter;
    }

    public WebSocketUpgradeFilter() {
        this(WebSocketPolicy.newServerPolicy(), new MappedByteBufferPool());
    }

    public WebSocketUpgradeFilter(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.factory = new WebSocketServerFactory(policy, bufferPool);
        this.addBean((Object)this.factory, true);
    }

    @Override
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.pathmap.put(spec, creator);
    }

    @Override
    public void destroy() {
        this.factory.cleanup();
        this.pathmap.reset();
        super.destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.factory == null) {
            LOG.debug("WebSocketUpgradeFilter is not operational - no WebSocketServletFactory configured", new Object[0]);
            chain.doFilter(request, response);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(".doFilter({}) - {}", this.fname, chain);
        }
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpreq = (HttpServletRequest)request;
            HttpServletResponse httpresp = (HttpServletResponse)response;
            String contextPath = httpreq.getContextPath();
            String target = httpreq.getRequestURI();
            if (target.startsWith(contextPath)) {
                target = target.substring(contextPath.length());
            }
            if (this.factory.isUpgradeRequest(httpreq, httpresp)) {
                LOG.debug("target = [{}]", target);
                MappedResource<WebSocketCreator> resource = this.pathmap.getMatch(target);
                if (resource == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("WebSocket Upgrade on {} has no associated endpoint", target);
                        LOG.debug("PathMappings: {}", this.pathmap.dump());
                    }
                    chain.doFilter(request, response);
                    return;
                }
                LOG.debug("WebSocket Upgrade detected on {} for endpoint {}", target, resource);
                WebSocketCreator creator = resource.getResource();
                httpreq.setAttribute(PathSpec.class.getName(), (Object)resource.getPathSpec());
                if (this.factory.acceptWebSocket(creator, httpreq, httpresp)) {
                    return;
                }
                if (response.isCommitted()) {
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        out.append(indent).append(" +- pathmap=").append(this.pathmap.toString()).append("\n");
        this.pathmap.dump(out, indent + "   ");
    }

    public WebSocketServerFactory getFactory() {
        return this.factory;
    }

    @Override
    @ManagedAttribute(value="mappings", readonly=true)
    public PathMappings<WebSocketCreator> getMappings() {
        return this.pathmap;
    }

    public void init(FilterConfig config) throws ServletException {
        this.fname = config.getFilterName();
        try {
            String key;
            ServletContext ctx = config.getServletContext();
            this.factory.init(ctx);
            WebSocketPolicy policy = this.factory.getPolicy();
            String max = config.getInitParameter("maxIdleTime");
            if (max != null) {
                policy.setIdleTimeout(Long.parseLong(max));
            }
            if ((max = config.getInitParameter("maxTextMessageSize")) != null) {
                policy.setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = config.getInitParameter("maxBinaryMessageSize")) != null) {
                policy.setMaxBinaryMessageSize(Integer.parseInt(max));
            }
            if ((max = config.getInitParameter("inputBufferSize")) != null) {
                policy.setInputBufferSize(Integer.parseInt(max));
            }
            if ((key = config.getInitParameter(CONTEXT_ATTRIBUTE_KEY)) == null) {
                key = WebSocketUpgradeFilter.class.getName();
            }
            this.setToAttribute(ctx, key);
            this.factory.start();
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    private void setToAttribute(ServletContextHandler context, String key) throws ServletException {
        if (this.alreadySetToAttribute) {
            return;
        }
        if (context.getAttribute(key) != null) {
            throw new ServletException(WebSocketUpgradeFilter.class.getName() + " is defined twice for the same context attribute key '" + key + "'.  Make sure you have different init-param '" + CONTEXT_ATTRIBUTE_KEY + "' values set");
        }
        context.setAttribute(key, this);
        this.alreadySetToAttribute = true;
    }

    public void setToAttribute(ServletContext context, String key) throws ServletException {
        if (this.alreadySetToAttribute) {
            return;
        }
        if (context.getAttribute(key) != null) {
            throw new ServletException(WebSocketUpgradeFilter.class.getName() + " is defined twice for the same context attribute key '" + key + "'.  Make sure you have different init-param '" + CONTEXT_ATTRIBUTE_KEY + "' values set");
        }
        context.setAttribute(key, (Object)this);
        this.alreadySetToAttribute = true;
    }

    public String toString() {
        return String.format("%s[factory=%s,pathmap=%s]", this.getClass().getSimpleName(), this.factory, this.pathmap);
    }
}

