/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.server;

import io.hops.hudi.org.eclipse.jetty.http.pathmap.MappedResource;
import io.hops.hudi.org.eclipse.jetty.http.pathmap.PathMappings;
import io.hops.hudi.org.eclipse.jetty.http.pathmap.PathSpec;
import io.hops.hudi.org.eclipse.jetty.io.ByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.io.MappedByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.server.Request;
import io.hops.hudi.org.eclipse.jetty.server.handler.HandlerWrapper;
import io.hops.hudi.org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import io.hops.hudi.org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import io.hops.hudi.org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebSocketUpgradeHandlerWrapper
extends HandlerWrapper
implements MappedWebSocketCreator {
    private PathMappings<WebSocketCreator> pathmap = new PathMappings();
    private final WebSocketServerFactory factory;

    public WebSocketUpgradeHandlerWrapper() {
        this(new MappedByteBufferPool());
    }

    public WebSocketUpgradeHandlerWrapper(ByteBufferPool bufferPool) {
        this.factory = new WebSocketServerFactory(bufferPool);
    }

    @Override
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.pathmap.put(spec, creator);
    }

    @Override
    public PathMappings<WebSocketCreator> getMappings() {
        return this.pathmap;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.factory.isUpgradeRequest(request, response)) {
            MappedResource<WebSocketCreator> resource = this.pathmap.getMatch(target);
            if (resource == null) {
                response.sendError(404, "No websocket endpoint matching path: " + target);
                return;
            }
            WebSocketCreator creator = resource.getResource();
            request.setAttribute(PathSpec.class.getName(), resource);
            if (this.factory.acceptWebSocket(creator, request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }
}

