/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.flink.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public final class LocatableInputSplitAssigner
implements InputSplitAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(LocatableInputSplitAssigner.class);
    private final Set<LocatableInputSplitWithCount> unassigned = new HashSet<LocatableInputSplitWithCount>();
    private final ConcurrentHashMap<String, LocatableInputSplitChooser> localPerHost = new ConcurrentHashMap();
    private final LocatableInputSplitChooser remoteSplitChooser;
    private int localAssignments;
    private int remoteAssignments;

    public LocatableInputSplitAssigner(Collection<LocatableInputSplit> splits) {
        for (LocatableInputSplit split : splits) {
            this.unassigned.add(new LocatableInputSplitWithCount(split));
        }
        this.remoteSplitChooser = new LocatableInputSplitChooser(this.unassigned);
    }

    public LocatableInputSplitAssigner(LocatableInputSplit[] splits) {
        for (LocatableInputSplit split : splits) {
            this.unassigned.add(new LocatableInputSplitWithCount(split));
        }
        this.remoteSplitChooser = new LocatableInputSplitChooser(this.unassigned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LocatableInputSplit getNextInputSplit(String host2, int taskId) {
        LocatableInputSplitChooser locatableInputSplitChooser;
        if (host2 == null) {
            LocatableInputSplitChooser locatableInputSplitChooser2 = this.remoteSplitChooser;
            synchronized (locatableInputSplitChooser2) {
                Set<LocatableInputSplitWithCount> set = this.unassigned;
                synchronized (set) {
                    LocatableInputSplitWithCount split = this.remoteSplitChooser.getNextUnassignedMinLocalCountSplit(this.unassigned);
                    if (split == null) {
                        return null;
                    }
                    if (!this.unassigned.remove(split)) {
                        throw new IllegalStateException("Chosen InputSplit has already been assigned. This should not happen!");
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Assigning split to null host (random assignment).");
                    }
                    ++this.remoteAssignments;
                    return split.getSplit();
                }
            }
        }
        LocatableInputSplitChooser localSplits = this.localPerHost.get(host2 = host2.toLowerCase(Locale.US));
        if (localSplits == null) {
            locatableInputSplitChooser = localSplits = new LocatableInputSplitChooser();
            synchronized (locatableInputSplitChooser) {
                LocatableInputSplitChooser prior = this.localPerHost.putIfAbsent(host2, localSplits);
                if (prior == null) {
                    LocatableInputSplitWithCount[] locatableInputSplitWithCountArray = this.unassigned;
                    synchronized (this.unassigned) {
                        LocatableInputSplitWithCount[] remaining = this.unassigned.toArray(new LocatableInputSplitWithCount[this.unassigned.size()]);
                        // ** MonitorExit[var7_9] (shouldn't be in output)
                        for (LocatableInputSplitWithCount isw : remaining) {
                            if (!LocatableInputSplitAssigner.isLocal(host2, isw.getSplit().getHostnames())) continue;
                            isw.incrementLocalCount();
                            localSplits.addInputSplit(isw);
                        }
                    }
                } else {
                    localSplits = prior;
                }
            }
        }
        {
            LocatableInputSplitWithCount split;
            Set<LocatableInputSplitWithCount> set;
            locatableInputSplitChooser = localSplits;
            synchronized (locatableInputSplitChooser) {
                set = this.unassigned;
                synchronized (set) {
                    split = localSplits.getNextUnassignedMinLocalCountSplit(this.unassigned);
                    if (split != null) {
                        if (!this.unassigned.remove(split)) {
                            throw new IllegalStateException("Chosen InputSplit has already been assigned. This should not happen!");
                        }
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Assigning local split to host " + host2);
                        }
                        ++this.localAssignments;
                        return split.getSplit();
                    }
                }
            }
            locatableInputSplitChooser = this.remoteSplitChooser;
            synchronized (locatableInputSplitChooser) {
                set = this.unassigned;
                synchronized (set) {
                    split = this.remoteSplitChooser.getNextUnassignedMinLocalCountSplit(this.unassigned);
                    if (split == null) {
                        return null;
                    }
                    if (!this.unassigned.remove(split)) {
                        throw new IllegalStateException("Chosen InputSplit has already been assigned. This should not happen!");
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Assigning remote split to host " + host2);
                    }
                    ++this.remoteAssignments;
                    return split.getSplit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnInputSplit(List<InputSplit> splits, int taskId) {
        Set<LocatableInputSplitWithCount> set = this.unassigned;
        synchronized (set) {
            for (InputSplit split : splits) {
                LocatableInputSplitWithCount lisw = new LocatableInputSplitWithCount((LocatableInputSplit)split);
                this.remoteSplitChooser.addInputSplit(lisw);
                this.unassigned.add(lisw);
            }
        }
    }

    private static final boolean isLocal(String flinkHost, String[] hosts) {
        if (flinkHost == null || hosts == null) {
            return false;
        }
        for (String h : hosts) {
            if (h == null || !NetUtils.getHostnameFromFQDN(h.toLowerCase()).equals(flinkHost)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfLocalAssignments() {
        return this.localAssignments;
    }

    public int getNumberOfRemoteAssignments() {
        return this.remoteAssignments;
    }

    private static class LocatableInputSplitChooser {
        private final LinkedList<LocatableInputSplitWithCount> splits = new LinkedList();
        private int minLocalCount = -1;
        private int nextMinLocalCount = -1;
        private int elementCycleCount = 0;

        public LocatableInputSplitChooser() {
        }

        public LocatableInputSplitChooser(Collection<LocatableInputSplitWithCount> splits) {
            for (LocatableInputSplitWithCount isw : splits) {
                this.addInputSplit(isw);
            }
        }

        public void addInputSplit(LocatableInputSplitWithCount split) {
            int localCount = split.getLocalCount();
            if (this.minLocalCount == -1) {
                this.minLocalCount = localCount;
                this.elementCycleCount = 1;
                this.splits.offerFirst(split);
            } else if (localCount < this.minLocalCount) {
                this.nextMinLocalCount = this.minLocalCount;
                this.minLocalCount = localCount;
                this.elementCycleCount = 1;
                this.splits.offerFirst(split);
            } else if (localCount == this.minLocalCount) {
                ++this.elementCycleCount;
                this.splits.offerFirst(split);
            } else {
                if (localCount < this.nextMinLocalCount) {
                    this.nextMinLocalCount = localCount;
                }
                this.splits.offerLast(split);
            }
        }

        public LocatableInputSplitWithCount getNextUnassignedMinLocalCountSplit(Set<LocatableInputSplitWithCount> unassignedSplits) {
            if (this.splits.size() == 0) {
                return null;
            }
            do {
                --this.elementCycleCount;
                LocatableInputSplitWithCount split = this.splits.pollFirst();
                if (unassignedSplits.contains(split)) {
                    int localCount = split.getLocalCount();
                    if (localCount > this.minLocalCount) {
                        this.splits.offerLast(split);
                        if (this.nextMinLocalCount == -1 || split.getLocalCount() < this.nextMinLocalCount) {
                            this.nextMinLocalCount = split.getLocalCount();
                        }
                        split = null;
                    }
                } else {
                    split = null;
                }
                if (this.elementCycleCount == 0) {
                    this.minLocalCount = this.nextMinLocalCount;
                    this.nextMinLocalCount = -1;
                    this.elementCycleCount = this.splits.size();
                }
                if (split == null) continue;
                return split;
            } while (this.elementCycleCount > 0);
            return null;
        }
    }

    private static class LocatableInputSplitWithCount {
        private final LocatableInputSplit split;
        private int localCount;

        public LocatableInputSplitWithCount(LocatableInputSplit split) {
            this.split = split;
            this.localCount = 0;
        }

        public void incrementLocalCount() {
            ++this.localCount;
        }

        public int getLocalCount() {
            return this.localCount;
        }

        public LocatableInputSplit getSplit() {
            return this.split;
        }
    }
}

