/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.util.FieldSet;

@Internal
public class CompilerHints {
    private long outputSize = -1L;
    private long outputCardinality = -1L;
    private float avgOutputRecordSize = -1.0f;
    private float filterFactor = -1.0f;
    private Set<FieldSet> uniqueFields;

    public long getOutputSize() {
        return this.outputSize;
    }

    public void setOutputSize(long outputSize) {
        if (outputSize < 0L) {
            throw new IllegalArgumentException("The output size cannot be smaller than zero.");
        }
        this.outputSize = outputSize;
    }

    public long getOutputCardinality() {
        return this.outputCardinality;
    }

    public void setOutputCardinality(long outputCardinality) {
        if (outputCardinality < 0L) {
            throw new IllegalArgumentException("The output cardinality cannot be smaller than zero.");
        }
        this.outputCardinality = outputCardinality;
    }

    public float getAvgOutputRecordSize() {
        return this.avgOutputRecordSize;
    }

    public void setAvgOutputRecordSize(float avgOutputRecordSize) {
        if (avgOutputRecordSize <= 0.0f) {
            throw new IllegalArgumentException("The size of produced records must be positive.");
        }
        this.avgOutputRecordSize = avgOutputRecordSize;
    }

    public float getFilterFactor() {
        return this.filterFactor;
    }

    public void setFilterFactor(float filterFactor) {
        if (filterFactor < 0.0f) {
            throw new IllegalArgumentException("The filter factor cannot be smaller than zero.");
        }
        this.filterFactor = filterFactor;
    }

    public Set<FieldSet> getUniqueFields() {
        return this.uniqueFields;
    }

    public void addUniqueField(FieldSet uniqueFieldSet) {
        if (this.uniqueFields == null) {
            this.uniqueFields = new HashSet<FieldSet>();
        }
        this.uniqueFields.add(uniqueFieldSet);
    }

    public void addUniqueField(int field2) {
        if (this.uniqueFields == null) {
            this.uniqueFields = new HashSet<FieldSet>();
        }
        this.uniqueFields.add(new FieldSet((Integer)field2));
    }

    public void addUniqueFields(Set<FieldSet> uniqueFieldSets) {
        if (this.uniqueFields == null) {
            this.uniqueFields = new HashSet<FieldSet>();
        }
        this.uniqueFields.addAll(uniqueFieldSets);
    }

    public void clearUniqueFields() {
        this.uniqueFields = null;
    }

    protected void copyFrom(CompilerHints source) {
        this.outputSize = source.outputSize;
        this.outputCardinality = source.outputCardinality;
        this.avgOutputRecordSize = source.avgOutputRecordSize;
        this.filterFactor = source.filterFactor;
        if (source.uniqueFields != null && source.uniqueFields.size() > 0) {
            if (this.uniqueFields == null) {
                this.uniqueFields = new HashSet<FieldSet>();
            } else {
                this.uniqueFields.clear();
            }
            this.uniqueFields.addAll(source.uniqueFields);
        }
    }
}

