/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.api.common.typeutils.base.array.PrimitiveArrayComparator;

@Internal
public class LongPrimitiveArrayComparator
extends PrimitiveArrayComparator<long[], LongComparator> {
    public LongPrimitiveArrayComparator(boolean ascending) {
        super(ascending, new LongComparator(ascending));
    }

    @Override
    public int hash(long[] record) {
        int result = 0;
        for (long field2 : record) {
            result += (int)(field2 ^ field2 >>> 32);
        }
        return result;
    }

    @Override
    public int compare(long[] first, long[] second) {
        for (int x = 0; x < Math.min(first.length, second.length); ++x) {
            int cmp;
            int n = first[x] < second[x] ? -1 : (cmp = first[x] == second[x] ? 0 : 1);
            if (cmp == 0) continue;
            return this.ascending ? cmp : -cmp;
        }
        int cmp = first.length - second.length;
        return this.ascending ? cmp : -cmp;
    }

    @Override
    public TypeComparator<long[]> duplicate() {
        LongPrimitiveArrayComparator dupe = new LongPrimitiveArrayComparator(this.ascending);
        dupe.setReference(this.reference);
        return dupe;
    }
}

