/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.tuple;

import java.io.Serializable;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.java.tuple.Tuple0;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.types.NullFieldException;

@Public
public abstract class Tuple
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_ARITY = 25;
    private static final Class<?>[] CLASSES = new Class[]{Tuple0.class, Tuple1.class, Tuple2.class, Tuple3.class, Tuple4.class, Tuple5.class, Tuple6.class, Tuple7.class, Tuple8.class, Tuple9.class, Tuple10.class, Tuple11.class, Tuple12.class, Tuple13.class, Tuple14.class, Tuple15.class, Tuple16.class, Tuple17.class, Tuple18.class, Tuple19.class, Tuple20.class, Tuple21.class, Tuple22.class, Tuple23.class, Tuple24.class, Tuple25.class};

    public abstract <T> T getField(int var1);

    public <T> T getFieldNotNull(int pos) {
        T field2 = this.getField(pos);
        if (field2 != null) {
            return field2;
        }
        throw new NullFieldException(pos);
    }

    public abstract <T> void setField(T var1, int var2);

    public abstract int getArity();

    public abstract <T extends Tuple> T copy();

    public static Class<? extends Tuple> getTupleClass(int arity) {
        if (arity < 0 || arity > 25) {
            throw new IllegalArgumentException("The tuple arity must be in [0, 25].");
        }
        return CLASSES[arity];
    }

    public static Tuple newInstance(int arity) {
        switch (arity) {
            case 0: {
                return Tuple0.INSTANCE;
            }
            case 1: {
                return new Tuple1();
            }
            case 2: {
                return new Tuple2();
            }
            case 3: {
                return new Tuple3();
            }
            case 4: {
                return new Tuple4();
            }
            case 5: {
                return new Tuple5();
            }
            case 6: {
                return new Tuple6();
            }
            case 7: {
                return new Tuple7();
            }
            case 8: {
                return new Tuple8();
            }
            case 9: {
                return new Tuple9();
            }
            case 10: {
                return new Tuple10();
            }
            case 11: {
                return new Tuple11();
            }
            case 12: {
                return new Tuple12();
            }
            case 13: {
                return new Tuple13();
            }
            case 14: {
                return new Tuple14();
            }
            case 15: {
                return new Tuple15();
            }
            case 16: {
                return new Tuple16();
            }
            case 17: {
                return new Tuple17();
            }
            case 18: {
                return new Tuple18();
            }
            case 19: {
                return new Tuple19();
            }
            case 20: {
                return new Tuple20();
            }
            case 21: {
                return new Tuple21();
            }
            case 22: {
                return new Tuple22();
            }
            case 23: {
                return new Tuple23();
            }
            case 24: {
                return new Tuple24();
            }
            case 25: {
                return new Tuple25();
            }
        }
        throw new IllegalArgumentException("The tuple arity must be in [0, 25].");
    }
}

