/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import org.apache.flink.annotation.Internal;

@Internal
public class FieldSerializer {
    public static void serializeField(Field field2, ObjectOutputStream out) throws IOException {
        out.writeObject(field2.getDeclaringClass());
        out.writeUTF(field2.getName());
    }

    public static Field deserializeField(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String fieldName = in.readUTF();
        for (Class clazz = (Class)in.readObject(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field2 = clazz.getDeclaredField(fieldName);
                field2.setAccessible(true);
                return field2;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }
}

