/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.GenericTypeSerializerConfigSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class KryoRegistrationSerializerConfigSnapshot<T>
extends GenericTypeSerializerConfigSnapshot<T> {
    private static final Logger LOG = LoggerFactory.getLogger(KryoRegistrationSerializerConfigSnapshot.class);
    private LinkedHashMap<String, KryoRegistration> kryoRegistrations;

    public KryoRegistrationSerializerConfigSnapshot() {
    }

    public KryoRegistrationSerializerConfigSnapshot(Class<T> typeClass, LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
        super(typeClass);
        this.kryoRegistrations = Preconditions.checkNotNull(kryoRegistrations);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeInt(this.kryoRegistrations.size());
        for (Map.Entry<String, KryoRegistration> kryoRegistrationEntry : this.kryoRegistrations.entrySet()) {
            out.writeUTF(kryoRegistrationEntry.getKey());
            new KryoRegistrationSerializationProxy(kryoRegistrationEntry.getValue()).write(out);
        }
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        int numKryoRegistrations = in.readInt();
        this.kryoRegistrations = new LinkedHashMap(numKryoRegistrations);
        for (int i = 0; i < numKryoRegistrations; ++i) {
            String classTag = in.readUTF();
            KryoRegistrationSerializationProxy proxy = new KryoRegistrationSerializationProxy(this.getUserCodeClassLoader());
            proxy.read(in);
            this.kryoRegistrations.put(classTag, proxy.kryoRegistration);
        }
    }

    public LinkedHashMap<String, KryoRegistration> getKryoRegistrations() {
        return this.kryoRegistrations;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.kryoRegistrations.equals(((KryoSerializer.KryoSerializerConfigSnapshot)obj).getKryoRegistrations());
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.kryoRegistrations.hashCode();
    }

    public static class DummyKryoSerializerClass<RC>
    extends Serializer<RC>
    implements Serializable {
        private static final long serialVersionUID = -6172780797425739308L;

        @Override
        public void write(Kryo kryo, Output output, Object o) {
            throw new UnsupportedOperationException("This exception indicates that you're trying to write a data type that no longer has a valid Kryo serializer registered for it.");
        }

        @Override
        public Object read(Kryo kryo, Input input, Class aClass) {
            throw new UnsupportedOperationException("This exception indicates that you're trying to read a data type that no longer has a valid Kryo serializer registered for it.");
        }
    }

    public static class DummyRegisteredClass
    implements Serializable {
    }

    private static class KryoRegistrationSerializationProxy<RC>
    implements IOReadableWritable {
        private ClassLoader userCodeClassLoader;
        private KryoRegistration kryoRegistration;

        public KryoRegistrationSerializationProxy(ClassLoader userCodeClassLoader) {
            this.userCodeClassLoader = Preconditions.checkNotNull(userCodeClassLoader);
        }

        public KryoRegistrationSerializationProxy(KryoRegistration kryoRegistration) {
            this.kryoRegistration = Preconditions.checkNotNull(kryoRegistration);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void write(DataOutputView out) throws IOException {
            out.writeUTF(this.kryoRegistration.getRegisteredClass().getName());
            serializerDefinitionType = this.kryoRegistration.getSerializerDefinitionType();
            out.writeInt(serializerDefinitionType.ordinal());
            switch (1.$SwitchMap$org$apache$flink$api$java$typeutils$runtime$KryoRegistration$SerializerDefinitionType[serializerDefinitionType.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    out.writeUTF(this.kryoRegistration.getSerializerClass().getName());
                    break;
                }
                case 3: {
                    outViewWrapper = new DataOutputViewStream(out);
                    var4_4 = null;
                    InstantiationUtil.serializeObject(outViewWrapper, this.kryoRegistration.getSerializableSerializerInstance());
                    if (outViewWrapper == null) break;
                    if (var4_4 == null) ** GOTO lbl23
                    try {
                        outViewWrapper.close();
                    }
                    catch (Throwable var5_5) {
                        var4_4.addSuppressed(var5_5);
                    }
                    break;
lbl23:
                    // 1 sources

                    outViewWrapper.close();
                    break;
                    catch (Throwable var5_6) {
                        try {
                            var4_4 = var5_6;
                            throw var5_6;
                        }
                        catch (Throwable var6_7) {
                            if (outViewWrapper != null) {
                                if (var4_4 != null) {
                                    try {
                                        outViewWrapper.close();
                                    }
                                    catch (Throwable var7_8) {
                                        var4_4.addSuppressed(var7_8);
                                    }
                                } else {
                                    outViewWrapper.close();
                                }
                            }
                            throw var6_7;
                        }
                    }
                }
                default: {
                    throw new IllegalStateException("Unrecognized Kryo registration serializer definition type: " + (Object)serializerDefinitionType);
                }
            }
        }

        @Override
        public void read(DataInputView in) throws IOException {
            Class<Object> registeredClass;
            String registeredClassname = in.readUTF();
            try {
                registeredClass = Class.forName(registeredClassname, true, this.userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot find registered class " + registeredClassname + " for Kryo serialization in classpath; using a dummy class as a placeholder.", (Throwable)e);
                registeredClass = DummyRegisteredClass.class;
            }
            KryoRegistration.SerializerDefinitionType serializerDefinitionType = KryoRegistration.SerializerDefinitionType.values()[in.readInt()];
            switch (serializerDefinitionType) {
                case UNSPECIFIED: {
                    this.kryoRegistration = new KryoRegistration(registeredClass);
                    break;
                }
                case CLASS: {
                    Class<Object> serializerClass;
                    String serializerClassname = in.readUTF();
                    try {
                        serializerClass = Class.forName(serializerClassname, true, this.userCodeClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn("Cannot find registered Kryo serializer class for class " + registeredClassname + " in classpath; using a dummy Kryo serializer that should be replaced as soon as a new Kryo serializer for the class is present", (Throwable)e);
                        serializerClass = DummyKryoSerializerClass.class;
                    }
                    this.kryoRegistration = new KryoRegistration(registeredClass, serializerClass);
                    break;
                }
                case INSTANCE: {
                    ExecutionConfig.SerializableSerializer serializerInstance;
                    try (DataInputViewStream inViewWrapper = new DataInputViewStream(in);){
                        serializerInstance = (ExecutionConfig.SerializableSerializer)InstantiationUtil.deserializeObject(inViewWrapper, this.userCodeClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn("Cannot find registered Kryo serializer class for class " + registeredClassname + " in classpath; using a dummy Kryo serializer that should be replaced as soon as a new Kryo serializer for the class is present", (Throwable)e);
                        serializerInstance = new ExecutionConfig.SerializableSerializer(new DummyKryoSerializerClass());
                    }
                    catch (InvalidClassException e) {
                        LOG.warn("The registered Kryo serializer class for class " + registeredClassname + " has changed and is no longer valid; using a dummy Kryo serializer that should be replaced as soon as a new Kryo serializer for the class is present.", (Throwable)e);
                        serializerInstance = new ExecutionConfig.SerializableSerializer(new DummyKryoSerializerClass());
                    }
                    this.kryoRegistration = new KryoRegistration(registeredClass, serializerInstance);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized Kryo registration serializer definition type: " + (Object)((Object)serializerDefinitionType));
                }
            }
        }
    }
}

