/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerUtils;
import org.apache.flink.api.java.typeutils.runtime.PojoFieldUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.LinkedOptionalMap;
import org.apache.flink.util.LinkedOptionalMapSerializer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.BiFunctionWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class PojoSerializerSnapshotData<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PojoSerializerSnapshotData.class);
    private Class<T> pojoClass;
    private LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots;
    private LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots;
    private LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots;

    static <T> PojoSerializerSnapshotData<T> createFrom(Class<T> pojoClass, Field[] fields, TypeSerializer<?>[] fieldSerializers, LinkedHashMap<Class<?>, TypeSerializer<?>> registeredSubclassSerializers, Map<Class<?>, TypeSerializer<?>> nonRegisteredSubclassSerializers) {
        LinkedOptionalMap fieldSerializerSnapshots = new LinkedOptionalMap(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field2 = fields[i];
            String fieldName = field2 == null ? PojoSerializerSnapshotData.getDummyNameForMissingField(i) : field2.getName();
            fieldSerializerSnapshots.put(fieldName, field2, TypeSerializerUtils.snapshotBackwardsCompatible(fieldSerializers[i]));
        }
        LinkedHashMap registeredSubclassSerializerSnapshots = new LinkedHashMap(registeredSubclassSerializers.size());
        registeredSubclassSerializers.forEach((k, v) -> registeredSubclassSerializerSnapshots.put(k, TypeSerializerUtils.snapshotBackwardsCompatible(v)));
        HashMap nonRegisteredSubclassSerializerSnapshots = new HashMap(nonRegisteredSubclassSerializers.size());
        nonRegisteredSubclassSerializers.forEach((k, v) -> nonRegisteredSubclassSerializerSnapshots.put(k, TypeSerializerUtils.snapshotBackwardsCompatible(v)));
        return new PojoSerializerSnapshotData<T>(pojoClass, fieldSerializerSnapshots, LinkedOptionalMap.optionalMapOf(registeredSubclassSerializerSnapshots, Class::getName), LinkedOptionalMap.optionalMapOf(nonRegisteredSubclassSerializerSnapshots, Class::getName));
    }

    static <T> PojoSerializerSnapshotData<T> createFrom(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        return PojoSerializerSnapshotData.readSnapshotData(in, userCodeClassLoader);
    }

    static <T> PojoSerializerSnapshotData<T> createFrom(Class<T> pojoClass, Field[] fields, TypeSerializerSnapshot<?>[] existingFieldSerializerSnapshots, LinkedHashMap<Class<?>, TypeSerializerSnapshot<?>> existingRegisteredSubclassSerializerSnapshots, Map<Class<?>, TypeSerializerSnapshot<?>> existingNonRegisteredSubclassSerializerSnapshots) {
        LinkedOptionalMap fieldSerializerSnapshots = new LinkedOptionalMap(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field2 = fields[i];
            String fieldName = field2 == null ? PojoSerializerSnapshotData.getDummyNameForMissingField(i) : field2.getName();
            fieldSerializerSnapshots.put(fieldName, field2, existingFieldSerializerSnapshots[i]);
        }
        return new PojoSerializerSnapshotData<T>(pojoClass, fieldSerializerSnapshots, LinkedOptionalMap.optionalMapOf(existingRegisteredSubclassSerializerSnapshots, Class::getName), LinkedOptionalMap.optionalMapOf(existingNonRegisteredSubclassSerializerSnapshots, Class::getName));
    }

    private PojoSerializerSnapshotData(Class<T> typeClass, LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots, LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots) {
        this.pojoClass = Preconditions.checkNotNull(typeClass);
        this.fieldSerializerSnapshots = Preconditions.checkNotNull(fieldSerializerSnapshots);
        this.registeredSubclassSerializerSnapshots = Preconditions.checkNotNull(registeredSubclassSerializerSnapshots);
        this.nonRegisteredSubclassSerializerSnapshots = Preconditions.checkNotNull(nonRegisteredSubclassSerializerSnapshots);
    }

    void writeSnapshotData(DataOutputView out) throws IOException {
        out.writeUTF(this.pojoClass.getName());
        LinkedOptionalMapSerializer.writeOptionalMap(out, this.fieldSerializerSnapshots, PojoFieldUtils::writeField, TypeSerializerSnapshot::writeVersionedSnapshot);
        LinkedOptionalMapSerializer.writeOptionalMap(out, this.registeredSubclassSerializerSnapshots, NoOpWriter.noopWriter(), TypeSerializerSnapshot::writeVersionedSnapshot);
        LinkedOptionalMapSerializer.writeOptionalMap(out, this.nonRegisteredSubclassSerializerSnapshots, NoOpWriter.noopWriter(), TypeSerializerSnapshot::writeVersionedSnapshot);
    }

    private static <T> PojoSerializerSnapshotData<T> readSnapshotData(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        Class pojoClass = InstantiationUtil.resolveClassByName(in, userCodeClassLoader);
        LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> fieldSerializerSnapshots = LinkedOptionalMapSerializer.readOptionalMap(in, PojoSerializerSnapshotData.fieldReader(userCodeClassLoader), PojoSerializerSnapshotData.snapshotReader(userCodeClassLoader));
        LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> registeredSubclassSerializerSnapshots = LinkedOptionalMapSerializer.readOptionalMap(in, PojoSerializerSnapshotData.classReader(userCodeClassLoader), PojoSerializerSnapshotData.snapshotReader(userCodeClassLoader));
        LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> nonRegisteredSubclassSerializerSnapshots = LinkedOptionalMapSerializer.readOptionalMap(in, PojoSerializerSnapshotData.classReader(userCodeClassLoader), PojoSerializerSnapshotData.snapshotReader(userCodeClassLoader));
        return new PojoSerializerSnapshotData(pojoClass, fieldSerializerSnapshots, registeredSubclassSerializerSnapshots, nonRegisteredSubclassSerializerSnapshots);
    }

    Class<T> getPojoClass() {
        return this.pojoClass;
    }

    LinkedOptionalMap<Field, TypeSerializerSnapshot<?>> getFieldSerializerSnapshots() {
        return this.fieldSerializerSnapshots;
    }

    LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> getRegisteredSubclassSerializerSnapshots() {
        return this.registeredSubclassSerializerSnapshots;
    }

    LinkedOptionalMap<Class<?>, TypeSerializerSnapshot<?>> getNonRegisteredSubclassSerializerSnapshots() {
        return this.nonRegisteredSubclassSerializerSnapshots;
    }

    private static String getDummyNameForMissingField(int fieldIndex) {
        return String.format("missing-field-at-%d", fieldIndex);
    }

    private static BiFunctionWithException<DataInputView, String, Field, IOException> fieldReader(ClassLoader cl) {
        return (input, fieldName) -> {
            try {
                return PojoFieldUtils.readField(input, cl);
            }
            catch (Throwable t) {
                LOG.warn(String.format("Exception while reading field %s", fieldName), t);
                return null;
            }
        };
    }

    private static BiFunctionWithException<DataInputView, String, TypeSerializerSnapshot<?>, IOException> snapshotReader(ClassLoader cl) {
        return (input, unused) -> {
            try {
                return TypeSerializerSnapshot.readVersionedSnapshot(input, cl);
            }
            catch (Throwable t) {
                LOG.warn("Exception while reading serializer snapshot.", t);
                return null;
            }
        };
    }

    private static BiFunctionWithException<DataInputView, String, Class<?>, IOException> classReader(ClassLoader cl) {
        return (input, className) -> {
            try {
                return Class.forName(className, false, cl);
            }
            catch (Throwable t) {
                LOG.warn(String.format("Exception while reading class %s", className), t);
                return null;
            }
        };
    }

    private static enum NoOpWriter implements BiConsumerWithException<DataOutputView, Object, IOException>
    {
        INSTANCE;


        @Override
        public void accept(DataOutputView dataOutputView, Object o) {
        }

        static <K> BiConsumerWithException<DataOutputView, K, IOException> noopWriter() {
            return INSTANCE;
        }
    }
}

