/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.KryoException;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import io.hops.hudi.com.esotericsoftware.minlog.Log;
import io.hops.hudi.org.objenesis.strategy.StdInstantiatorStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.AvroUtils;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistrationSerializerConfigSnapshot;
import org.apache.flink.api.java.typeutils.runtime.KryoUtils;
import org.apache.flink.api.java.typeutils.runtime.NoFetchingInput;
import org.apache.flink.api.java.typeutils.runtime.kryo.ChillSerializerRegistrar;
import org.apache.flink.api.java.typeutils.runtime.kryo.JavaSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializerDebugInitHelper;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.kryo.MinlogForwarder;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 3L;
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializer.class);
    private static final boolean CONCURRENT_ACCESS_CHECK = LOG.isDebugEnabled() || KryoSerializerDebugInitHelper.setToDebug;
    @Nullable
    private static final ChillSerializerRegistrar flinkChillPackageRegistrar;
    private final LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> defaultSerializers;
    private final LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultSerializerClasses;
    private LinkedHashMap<String, KryoRegistration> kryoRegistrations;
    private final Class<T> type;
    private transient Kryo kryo;
    private transient T copyInstance;
    private transient DataOutputView previousOut;
    private transient DataInputView previousIn;
    private transient Input input;
    private transient Output output;
    private LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> registeredTypesWithSerializers;
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> registeredTypesWithSerializerClasses;
    private LinkedHashSet<Class<?>> registeredTypes;
    private volatile transient Thread currentThread;

    @Nullable
    private static ChillSerializerRegistrar loadFlinkChillPackageRegistrar() {
        try {
            return (ChillSerializerRegistrar)Class.forName("org.apache.flink.api.java.typeutils.runtime.kryo.FlinkChillPackageRegistrar").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public KryoSerializer(Class<T> type, ExecutionConfig executionConfig) {
        this.type = Preconditions.checkNotNull(type);
        this.defaultSerializers = executionConfig.getDefaultKryoSerializers();
        this.defaultSerializerClasses = executionConfig.getDefaultKryoSerializerClasses();
        this.kryoRegistrations = KryoSerializer.buildKryoRegistrations(this.type, executionConfig.getRegisteredKryoTypes(), executionConfig.getRegisteredTypesWithKryoSerializerClasses(), executionConfig.getRegisteredTypesWithKryoSerializers());
    }

    protected KryoSerializer(KryoSerializer<T> toCopy) {
        this.type = Preconditions.checkNotNull(toCopy.type, "Type class cannot be null.");
        this.defaultSerializerClasses = toCopy.defaultSerializerClasses;
        this.defaultSerializers = new LinkedHashMap(toCopy.defaultSerializers.size());
        this.kryoRegistrations = new LinkedHashMap(toCopy.kryoRegistrations.size());
        for (Map.Entry<Class<?>, ExecutionConfig.SerializableSerializer<?>> entry : toCopy.defaultSerializers.entrySet()) {
            this.defaultSerializers.put(entry.getKey(), this.deepCopySerializer(entry.getValue()));
        }
        for (Map.Entry<Object, Serializable> entry : toCopy.kryoRegistrations.entrySet()) {
            ExecutionConfig.SerializableSerializer<? extends Serializer<?>> serializerInstance;
            KryoRegistration kryoRegistration = (KryoRegistration)entry.getValue();
            if (kryoRegistration.getSerializerDefinitionType() == KryoRegistration.SerializerDefinitionType.INSTANCE && (serializerInstance = kryoRegistration.getSerializableSerializerInstance()) != null) {
                kryoRegistration = new KryoRegistration(kryoRegistration.getRegisteredClass(), this.deepCopySerializer(serializerInstance));
            }
            this.kryoRegistrations.put((String)entry.getKey(), kryoRegistration);
        }
    }

    KryoSerializer(Class<T> type, LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> defaultSerializers, LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultSerializerClasses, LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
        this.type = Preconditions.checkNotNull(type, "Type class cannot be null.");
        this.defaultSerializerClasses = Preconditions.checkNotNull(defaultSerializerClasses, "Default serializer classes cannot be null.");
        this.defaultSerializers = Preconditions.checkNotNull(defaultSerializers, "Default serializers cannot be null.");
        this.kryoRegistrations = Preconditions.checkNotNull(kryoRegistrations, "Kryo registrations cannot be null.");
    }

    Class<T> getType() {
        return this.type;
    }

    LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> getDefaultKryoSerializers() {
        return this.defaultSerializers;
    }

    LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getDefaultKryoSerializerClasses() {
        return this.defaultSerializerClasses;
    }

    LinkedHashMap<String, KryoRegistration> getKryoRegistrations() {
        return this.kryoRegistrations;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public KryoSerializer<T> duplicate() {
        return new KryoSerializer<T>(this);
    }

    @Override
    public T createInstance() {
        if (Modifier.isAbstract(this.type.getModifiers()) || Modifier.isInterface(this.type.getModifiers())) {
            return null;
        }
        this.checkKryoInitialized();
        try {
            return this.kryo.newInstance(this.type);
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T copy(T from) {
        if (from == null) {
            return null;
        }
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            T t;
            this.checkKryoInitialized();
            try {
                t = this.kryo.copy(from);
            }
            catch (KryoException ke) {
                Object obj;
                block9: {
                    ByteArrayOutputStream baout = new ByteArrayOutputStream();
                    Output output = new Output(baout);
                    this.kryo.writeObject(output, from);
                    output.close();
                    ByteArrayInputStream bain = new ByteArrayInputStream(baout.toByteArray());
                    Input input = new Input(bain);
                    obj = this.kryo.readObject(input, from.getClass());
                    if (!CONCURRENT_ACCESS_CHECK) break block9;
                    this.exitExclusiveThread();
                }
                return (T)obj;
            }
            return t;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    @Override
    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkKryoInitialized();
            if (target != this.previousOut) {
                DataOutputViewStream outputStream = new DataOutputViewStream(target);
                this.output = new Output(outputStream);
                this.previousOut = target;
            }
            if (this.output.position() != 0) {
                throw new IllegalStateException("The Kryo Output still contains data from a previous serialize call. It has to be flushed or cleared at the end of the serialize call.");
            }
            try {
                this.kryo.writeClassAndObject(this.output, record);
                this.output.flush();
            }
            catch (KryoException ke) {
                this.output.clear();
                Throwable cause = ke.getCause();
                if (cause instanceof EOFException) {
                    throw (EOFException)cause;
                }
                throw ke;
            }
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            Object inputStream;
            this.checkKryoInitialized();
            if (source != this.previousIn) {
                inputStream = new DataInputViewStream(source);
                this.input = new NoFetchingInput((InputStream)inputStream);
                this.previousIn = source;
            }
            try {
                inputStream = this.kryo.readClassAndObject(this.input);
            }
            catch (KryoException ke) {
                Throwable cause = ke.getCause();
                if (cause instanceof EOFException) {
                    throw (EOFException)cause;
                }
                throw ke;
            }
            return (T)inputStream;
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (CONCURRENT_ACCESS_CHECK) {
            this.enterExclusiveThread();
        }
        try {
            this.checkKryoInitialized();
            if (this.copyInstance == null) {
                this.copyInstance = this.createInstance();
            }
            T tmp = this.deserialize(this.copyInstance, source);
            this.serialize(tmp, target);
        }
        finally {
            if (CONCURRENT_ACCESS_CHECK) {
                this.exitExclusiveThread();
            }
        }
    }

    @Override
    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.kryoRegistrations.hashCode();
        result = 31 * result + this.defaultSerializers.hashCode();
        result = 31 * result + this.defaultSerializerClasses.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KryoSerializer) {
            KryoSerializer other = (KryoSerializer)obj;
            return this.type == other.type && Objects.equals(this.kryoRegistrations, other.kryoRegistrations) && Objects.equals(this.defaultSerializerClasses, other.defaultSerializerClasses) && Objects.equals(this.defaultSerializers, other.defaultSerializers);
        }
        return false;
    }

    private Kryo getKryoInstance() {
        try {
            Class<?> chillInstantiatorClazz = Class.forName("org.apache.flink.runtime.types.FlinkScalaKryoInstantiator");
            Object chillInstantiator = chillInstantiatorClazz.newInstance();
            Method m = chillInstantiatorClazz.getMethod("newKryo", new Class[0]);
            return (Kryo)m.invoke(chillInstantiator, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Kryo serializer scala extensions are not available.", (Throwable)e);
            } else {
                LOG.info("Kryo serializer scala extensions are not available.");
            }
            Kryo.DefaultInstantiatorStrategy initStrategy = new Kryo.DefaultInstantiatorStrategy();
            initStrategy.setFallbackInstantiatorStrategy(new StdInstantiatorStrategy());
            Kryo kryo = new Kryo();
            kryo.setInstantiatorStrategy(initStrategy);
            if (flinkChillPackageRegistrar != null) {
                flinkChillPackageRegistrar.registerSerializers(kryo);
            }
            return kryo;
        }
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = this.getKryoInstance();
            this.kryo.setReferences(true);
            this.kryo.addDefaultSerializer(Throwable.class, new JavaSerializer());
            for (Map.Entry<Class<?>, ExecutionConfig.SerializableSerializer<?>> entry : this.defaultSerializers.entrySet()) {
                this.kryo.addDefaultSerializer((Class)entry.getKey(), (Serializer)entry.getValue().getSerializer());
            }
            for (Map.Entry<Class<?>, Serializable> entry : this.defaultSerializerClasses.entrySet()) {
                this.kryo.addDefaultSerializer(entry.getKey(), (Class)entry.getValue());
            }
            KryoUtils.applyRegistrations(this.kryo, this.kryoRegistrations.values(), flinkChillPackageRegistrar != null ? flinkChillPackageRegistrar.getNextRegistrationId() : this.kryo.getNextRegistrationId());
            this.kryo.setRegistrationRequired(false);
            this.kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new KryoSerializerSnapshot<T>(this.type, this.defaultSerializers, this.defaultSerializerClasses, this.kryoRegistrations);
    }

    private static LinkedHashMap<String, KryoRegistration> buildKryoRegistrations(Class<?> serializedType, LinkedHashSet<Class<?>> registeredTypes, LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> registeredTypesWithSerializerClasses, LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> registeredTypesWithSerializers) {
        LinkedHashMap<String, KryoRegistration> kryoRegistrations = new LinkedHashMap<String, KryoRegistration>();
        kryoRegistrations.put(serializedType.getName(), new KryoRegistration(serializedType));
        for (Class clazz : Preconditions.checkNotNull(registeredTypes)) {
            kryoRegistrations.put(clazz.getName(), new KryoRegistration(clazz));
        }
        for (Map.Entry entry : Preconditions.checkNotNull(registeredTypesWithSerializerClasses).entrySet()) {
            kryoRegistrations.put(((Class)entry.getKey()).getName(), new KryoRegistration((Class)entry.getKey(), (Class)entry.getValue()));
        }
        for (Map.Entry entry : Preconditions.checkNotNull(registeredTypesWithSerializers).entrySet()) {
            kryoRegistrations.put(((Class)entry.getKey()).getName(), new KryoRegistration((Class)entry.getKey(), (ExecutionConfig.SerializableSerializer)entry.getValue()));
        }
        AvroUtils.getAvroUtils().addAvroGenericDataArrayRegistration(kryoRegistrations);
        return kryoRegistrations;
    }

    static void configureKryoLogging() {
        if (LOG.isTraceEnabled()) {
            Log.setLogger(new MinlogForwarder(LOG));
            Log.TRACE();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.kryoRegistrations == null) {
            this.kryoRegistrations = KryoSerializer.buildKryoRegistrations(this.type, this.registeredTypes, this.registeredTypesWithSerializerClasses, this.registeredTypesWithSerializers);
        }
    }

    private ExecutionConfig.SerializableSerializer<? extends Serializer<?>> deepCopySerializer(ExecutionConfig.SerializableSerializer<? extends Serializer<?>> original) {
        try {
            return InstantiationUtil.clone(original, Thread.currentThread().getContextClassLoader());
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new CloneFailedException("Could not clone serializer instance of class " + original.getClass(), (Throwable)ex);
        }
    }

    private void enterExclusiveThread() {
        Thread previous = this.currentThread;
        Thread thisThread = Thread.currentThread();
        if (previous == null) {
            this.currentThread = thisThread;
        } else if (previous != thisThread) {
            throw new IllegalStateException("Concurrent access to KryoSerializer. Thread 1: " + thisThread.getName() + " , Thread 2: " + previous.getName());
        }
    }

    private void exitExclusiveThread() {
        this.currentThread = null;
    }

    @VisibleForTesting
    public Kryo getKryo() {
        this.checkKryoInitialized();
        return this.kryo;
    }

    static {
        KryoSerializer.configureKryoLogging();
        flinkChillPackageRegistrar = KryoSerializer.loadFlinkChillPackageRegistrar();
    }

    @Deprecated
    public static final class KryoSerializerConfigSnapshot<T>
    extends KryoRegistrationSerializerConfigSnapshot<T> {
        private static final int VERSION = 1;

        public KryoSerializerConfigSnapshot() {
        }

        public KryoSerializerConfigSnapshot(Class<T> typeClass, LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
            super(typeClass, kryoRegistrations);
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            KryoSerializer javaSerializedKryoSerializer = (KryoSerializer)super.restoreSerializer();
            KryoSerializerSnapshot<T> snapshot = new KryoSerializerSnapshot<T>(javaSerializedKryoSerializer.getType(), javaSerializedKryoSerializer.getDefaultKryoSerializers(), javaSerializedKryoSerializer.getDefaultKryoSerializerClasses(), javaSerializedKryoSerializer.getKryoRegistrations());
            return snapshot.resolveSchemaCompatibility(newSerializer);
        }
    }
}

