/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.LinkedHashMap;
import java.util.function.Function;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.LinkedOptionalMap;
import org.apache.flink.util.LinkedOptionalMapSerializer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiFunctionWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KryoSerializerSnapshotData<T> {
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializerSnapshotData.class);
    private final Class<T> typeClass;
    private final LinkedOptionalMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> defaultKryoSerializers;
    private final LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses;
    private final LinkedOptionalMap<String, KryoRegistration> kryoRegistrations;

    static <T> KryoSerializerSnapshotData<T> createFrom(Class<T> typeClass, LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> defaultKryoSerializers, LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses, LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
        return new KryoSerializerSnapshotData<T>(typeClass, LinkedOptionalMap.optionalMapOf(defaultKryoSerializers, Class::getName), LinkedOptionalMap.optionalMapOf(defaultKryoSerializerClasses, Class::getName), LinkedOptionalMap.optionalMapOf(kryoRegistrations, Function.identity()));
    }

    static <T> KryoSerializerSnapshotData<T> createFrom(DataInputView in, ClassLoader cl) throws IOException {
        Class<T> typeClass = KryoSerializerSnapshotData.readTypeClass(in, cl);
        LinkedOptionalMap<String, KryoRegistration> kryoRegistrations = KryoSerializerSnapshotData.readKryoRegistrations(in, cl);
        LinkedOptionalMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> defaultSerializer = KryoSerializerSnapshotData.readDefaultKryoSerializers(in, cl);
        LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> defaultSerializerClasses = KryoSerializerSnapshotData.readDefaultKryoSerializerClasses(in, cl);
        return new KryoSerializerSnapshotData<T>(typeClass, defaultSerializer, defaultSerializerClasses, kryoRegistrations);
    }

    private KryoSerializerSnapshotData(Class<T> typeClass, LinkedOptionalMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> defaultKryoSerializers, LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses, LinkedOptionalMap<String, KryoRegistration> kryoRegistrations) {
        this.typeClass = typeClass;
        this.defaultKryoSerializers = defaultKryoSerializers;
        this.defaultKryoSerializerClasses = defaultKryoSerializerClasses;
        this.kryoRegistrations = kryoRegistrations;
    }

    Class<T> getTypeClass() {
        return this.typeClass;
    }

    LinkedOptionalMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> getDefaultKryoSerializers() {
        return this.defaultKryoSerializers;
    }

    LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> getDefaultKryoSerializerClasses() {
        return this.defaultKryoSerializerClasses;
    }

    LinkedOptionalMap<String, KryoRegistration> getKryoRegistrations() {
        return this.kryoRegistrations;
    }

    void writeSnapshotData(DataOutputView out) throws IOException {
        this.writeTypeClass(out);
        KryoSerializerSnapshotData.writeKryoRegistrations(out, this.kryoRegistrations);
        this.writeDefaultKryoSerializers(out, this.defaultKryoSerializers);
        KryoSerializerSnapshotData.writeDefaultKryoSerializerClasses(out, this.defaultKryoSerializerClasses);
    }

    private void writeTypeClass(DataOutputView out) throws IOException {
        out.writeUTF(this.typeClass.getName());
    }

    private static void writeKryoRegistrations(DataOutputView out, LinkedOptionalMap<String, KryoRegistration> kryoRegistrations) throws IOException {
        LinkedOptionalMapSerializer.writeOptionalMap(out, kryoRegistrations, DataOutput::writeUTF, KryoRegistrationUtil::writeKryoRegistration);
    }

    private void writeDefaultKryoSerializers(DataOutputView out, LinkedOptionalMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> defaultKryoSerializers) throws IOException {
        LinkedOptionalMapSerializer.writeOptionalMap(out, defaultKryoSerializers, (stream, klass) -> stream.writeUTF(klass.getName()), (stream, instance) -> {
            try (DataOutputViewStream outViewWrapper = new DataOutputViewStream((DataOutputView)stream);){
                InstantiationUtil.serializeObject(outViewWrapper, instance);
            }
        });
    }

    private static void writeDefaultKryoSerializerClasses(DataOutputView out, LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses) throws IOException {
        LinkedOptionalMapSerializer.writeOptionalMap(out, defaultKryoSerializerClasses, (stream, klass) -> stream.writeUTF(klass.getName()), (stream, klass) -> stream.writeUTF(klass.getName()));
    }

    private static <T> Class<T> readTypeClass(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        return InstantiationUtil.resolveClassByName(in, userCodeClassLoader);
    }

    private static LinkedOptionalMap<String, KryoRegistration> readKryoRegistrations(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        return LinkedOptionalMapSerializer.readOptionalMap(in, (stream, unused) -> stream.readUTF(), (stream, unused) -> KryoRegistrationUtil.tryReadKryoRegistration(stream, userCodeClassLoader));
    }

    private static LinkedOptionalMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> readDefaultKryoSerializers(DataInputView in, ClassLoader cl) throws IOException {
        return LinkedOptionalMapSerializer.readOptionalMap(in, new ClassResolverByName(cl), new SerializeableSerializerResolver(cl));
    }

    private static LinkedOptionalMap<Class<?>, Class<? extends Serializer<?>>> readDefaultKryoSerializerClasses(DataInputView in, ClassLoader cl) throws IOException {
        return LinkedOptionalMapSerializer.readOptionalMap(in, new ClassResolverByName(cl), new ClassResolverByName(cl));
    }

    private static final class SerializeableSerializerResolver
    implements BiFunctionWithException<DataInputView, String, ExecutionConfig.SerializableSerializer<?>, IOException> {
        private final ClassLoader classLoader;

        private SerializeableSerializerResolver(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ExecutionConfig.SerializableSerializer<?> apply(DataInputView stream, String className) {
            try (DataInputViewStream inViewWrapper = new DataInputViewStream(stream);){
                ExecutionConfig.SerializableSerializer serializableSerializer = (ExecutionConfig.SerializableSerializer)InstantiationUtil.deserializeObject(inViewWrapper, this.classLoader);
                return serializableSerializer;
            }
            catch (Throwable e) {
                LOG.warn("Cannot deserialize a previously serialized kryo serializer for the type " + className, e);
                return null;
            }
        }
    }

    private static class ClassResolverByName<T>
    implements BiFunctionWithException<DataInputView, String, Class<T>, IOException> {
        private final ClassLoader classLoader;

        private ClassResolverByName(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public Class<T> apply(DataInputView stream, String unused) throws IOException {
            String className = stream.readUTF();
            try {
                return Class.forName(className, false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot find registered class " + className + " for Kryo serialization in classpath.", (Throwable)e);
                return null;
            }
        }
    }

    private static final class KryoRegistrationUtil {
        private KryoRegistrationUtil() {
        }

        /*
         * Unable to fully structure code
         */
        static void writeKryoRegistration(DataOutputView out, KryoRegistration kryoRegistration) throws IOException {
            Preconditions.checkNotNull(kryoRegistration);
            out.writeUTF(kryoRegistration.getRegisteredClass().getName());
            serializerDefinitionType = kryoRegistration.getSerializerDefinitionType();
            out.writeInt(serializerDefinitionType.ordinal());
            switch (1.$SwitchMap$org$apache$flink$api$java$typeutils$runtime$KryoRegistration$SerializerDefinitionType[serializerDefinitionType.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    serializerClass = kryoRegistration.getSerializerClass();
                    if (!KryoRegistrationUtil.$assertionsDisabled && serializerClass == null) {
                        throw new AssertionError();
                    }
                    out.writeUTF(serializerClass.getName());
                    break;
                }
                case 3: {
                    outViewWrapper = new DataOutputViewStream(out);
                    var4_5 = null;
                    InstantiationUtil.serializeObject(outViewWrapper, kryoRegistration.getSerializableSerializerInstance());
                    if (outViewWrapper == null) break;
                    if (var4_5 == null) ** GOTO lbl28
                    try {
                        outViewWrapper.close();
                    }
                    catch (Throwable var5_6) {
                        var4_5.addSuppressed(var5_6);
                    }
                    break;
lbl28:
                    // 1 sources

                    outViewWrapper.close();
                    break;
                    catch (Throwable var5_7) {
                        try {
                            var4_5 = var5_7;
                            throw var5_7;
                        }
                        catch (Throwable var6_8) {
                            if (outViewWrapper != null) {
                                if (var4_5 != null) {
                                    try {
                                        outViewWrapper.close();
                                    }
                                    catch (Throwable var7_9) {
                                        var4_5.addSuppressed(var7_9);
                                    }
                                } else {
                                    outViewWrapper.close();
                                }
                            }
                            throw var6_8;
                        }
                    }
                }
                default: {
                    throw new IllegalStateException("Unrecognized Kryo registration serializer definition type: " + (Object)serializerDefinitionType);
                }
            }
        }

        static KryoRegistration tryReadKryoRegistration(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            Class<?> registeredClass;
            String registeredClassname = in.readUTF();
            try {
                registeredClass = Class.forName(registeredClassname, true, userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot find registered class " + registeredClassname + " for Kryo serialization in classpath; using a dummy class as a placeholder.", (Throwable)e);
                return null;
            }
            KryoRegistration.SerializerDefinitionType serializerDefinitionType = KryoRegistration.SerializerDefinitionType.values()[in.readInt()];
            switch (serializerDefinitionType) {
                case UNSPECIFIED: {
                    return new KryoRegistration(registeredClass);
                }
                case CLASS: {
                    return KryoRegistrationUtil.tryReadWithSerializerClass(in, userCodeClassLoader, registeredClassname, registeredClass);
                }
                case INSTANCE: {
                    return KryoRegistrationUtil.tryReadWithSerializerInstance(in, userCodeClassLoader, registeredClassname, registeredClass);
                }
            }
            throw new IllegalStateException("Unrecognized Kryo registration serializer definition type: " + (Object)((Object)serializerDefinitionType));
        }

        private static KryoRegistration tryReadWithSerializerClass(DataInputView in, ClassLoader userCodeClassLoader, String registeredClassname, Class<?> registeredClass) throws IOException {
            String serializerClassname = in.readUTF();
            try {
                Class<?> serializerClass = Class.forName(serializerClassname, true, userCodeClassLoader);
                return new KryoRegistration(registeredClass, serializerClass);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot find registered Kryo serializer class for class " + registeredClassname + " in classpath; using a dummy Kryo serializer that should be replaced as soon as a new Kryo serializer for the class is present", (Throwable)e);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static KryoRegistration tryReadWithSerializerInstance(DataInputView in, ClassLoader userCodeClassLoader, String registeredClassname, Class<?> registeredClass) throws IOException {
            try (DataInputViewStream inViewWrapper = new DataInputViewStream(in);){
                ExecutionConfig.SerializableSerializer serializerInstance = (ExecutionConfig.SerializableSerializer)InstantiationUtil.deserializeObject(inViewWrapper, userCodeClassLoader);
                KryoRegistration kryoRegistration = new KryoRegistration(registeredClass, serializerInstance);
                return kryoRegistration;
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot find registered Kryo serializer class for class " + registeredClassname + " in classpath; using a dummy Kryo serializer that should be replaced as soon as a new Kryo serializer for the class is present", (Throwable)e);
                return null;
            }
            catch (InvalidClassException e) {
                LOG.warn("The registered Kryo serializer class for class " + registeredClassname + " has changed and is no longer valid; using a dummy Kryo serializer that should be replaced as soon as a new Kryo serializer for the class is present.", (Throwable)e);
            }
            return null;
        }
    }
}

