/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversions;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hadoop.util.VersionUtil;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.ConvertingGenericData;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.SchemaCompatibilityException;

public class HoodieAvroUtils {
    public static final String AVRO_VERSION = Schema.class.getPackage().getImplementationVersion();
    private static final ThreadLocal<BinaryEncoder> BINARY_ENCODER = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<BinaryDecoder> BINARY_DECODER = ThreadLocal.withInitial(() -> null);
    private static final long MILLIS_PER_DAY = 86400000L;
    public static final Conversions.DecimalConversion DECIMAL_CONVERSION = new Conversions.DecimalConversion();
    private static final String INVALID_AVRO_CHARS_IN_NAMES = "[^A-Za-z0-9_]";
    private static final String INVALID_AVRO_FIRST_CHAR_IN_NAMES = "[^A-Za-z_]";
    private static final String MASK_FOR_INVALID_CHARS_IN_NAMES = "__";
    public static final Schema METADATA_FIELD_SCHEMA = AvroSchemaUtils.createNullableSchema(Schema.Type.STRING);
    public static final Schema RECORD_KEY_SCHEMA = HoodieAvroUtils.initRecordKeySchema();

    public static byte[] avroToBytes(GenericRecord record) {
        return HoodieAvroUtils.indexedRecordToBytes(record);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends IndexedRecord> byte[] indexedRecordToBytes(T record) {
        GenericDatumWriter writer = new GenericDatumWriter(record.getSchema(), ConvertingGenericData.INSTANCE);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, BINARY_ENCODER.get());
            BINARY_ENCODER.set(encoder);
            writer.write(record, (Encoder)encoder);
            encoder.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot convert GenericRecord to bytes", e);
        }
    }

    public static byte[] avroToJson(GenericRecord record, boolean pretty) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(record.getSchema(), (OutputStream)out, pretty);
        writer.write((Object)record, (Encoder)jsonEncoder);
        jsonEncoder.flush();
        return out.toByteArray();
    }

    public static GenericRecord bytesToAvro(byte[] bytes, Schema schema) throws IOException {
        return HoodieAvroUtils.bytesToAvro(bytes, schema, schema);
    }

    public static GenericRecord bytesToAvro(byte[] bytes, Schema writerSchema, Schema readerSchema) throws IOException {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, BINARY_DECODER.get());
        BINARY_DECODER.set(decoder);
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        return (GenericRecord)reader.read(null, (Decoder)decoder);
    }

    public static GenericRecord jsonBytesToAvro(byte[] bytes, Schema schema) throws IOException {
        ByteArrayInputStream bio = new ByteArrayInputStream(bytes);
        JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)bio);
        GenericDatumReader reader = new GenericDatumReader(schema);
        return (GenericRecord)reader.read(null, (Decoder)jsonDecoder);
    }

    public static boolean isMetadataField(String fieldName) {
        return HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION.contains(fieldName);
    }

    public static Schema createHoodieWriteSchema(Schema originalSchema) {
        return HoodieAvroUtils.addMetadataFields(originalSchema);
    }

    public static Schema createHoodieWriteSchema(String originalSchema) {
        return HoodieAvroUtils.createHoodieWriteSchema(new Schema.Parser().parse(originalSchema));
    }

    public static Schema createHoodieWriteSchema(String originalSchema, boolean withOperationField) {
        return HoodieAvroUtils.addMetadataFields(new Schema.Parser().parse(originalSchema), withOperationField);
    }

    public static Schema addMetadataFields(Schema schema) {
        return HoodieAvroUtils.addMetadataFields(schema, false);
    }

    public static Schema addMetadataFields(Schema schema, boolean withOperationField) {
        ArrayList<Schema.Field> parentFields = new ArrayList<Schema.Field>();
        Schema.Field commitTimeField = new Schema.Field("_hoodie_commit_time", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field commitSeqnoField = new Schema.Field("_hoodie_commit_seqno", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field recordKeyField = new Schema.Field("_hoodie_record_key", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field partitionPathField = new Schema.Field("_hoodie_partition_path", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field fileNameField = new Schema.Field("_hoodie_file_name", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        parentFields.add(commitTimeField);
        parentFields.add(commitSeqnoField);
        parentFields.add(recordKeyField);
        parentFields.add(partitionPathField);
        parentFields.add(fileNameField);
        if (withOperationField) {
            Schema.Field operationField = new Schema.Field("_hoodie_operation", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
            parentFields.add(operationField);
        }
        for (Schema.Field field2 : schema.getFields()) {
            if (HoodieAvroUtils.isMetadataField(field2.name())) continue;
            Schema.Field newField = new Schema.Field(field2.name(), field2.schema(), field2.doc(), field2.defaultVal());
            for (Map.Entry prop : field2.getObjectProps().entrySet()) {
                newField.addProp((String)prop.getKey(), prop.getValue());
            }
            parentFields.add(newField);
        }
        Schema mergedSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)false);
        mergedSchema.setFields(parentFields);
        return mergedSchema;
    }

    public static Schema removeMetadataFields(Schema schema) {
        return HoodieAvroUtils.removeFields(schema, HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION);
    }

    public static Schema removeFields(Schema schema, Set<String> fieldsToRemove) {
        List filteredFields = schema.getFields().stream().filter(field2 -> !fieldsToRemove.contains(field2.name())).map(field2 -> new Schema.Field(field2.name(), field2.schema(), field2.doc(), field2.defaultVal())).collect(Collectors.toList());
        Schema filteredSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)false);
        filteredSchema.setFields(filteredFields);
        return filteredSchema;
    }

    public static String addMetadataColumnTypes(String hiveColumnTypes) {
        return "string,string,string,string,string," + hiveColumnTypes;
    }

    private static Schema initRecordKeySchema() {
        Schema.Field recordKeyField = new Schema.Field("_hoodie_record_key", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema recordKeySchema = Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false);
        recordKeySchema.setFields(Collections.singletonList(recordKeyField));
        return recordKeySchema;
    }

    public static Schema getRecordKeySchema() {
        return RECORD_KEY_SCHEMA;
    }

    public static Schema getRecordKeyPartitionPathSchema() {
        ArrayList<Schema.Field> toBeAddedFields = new ArrayList<Schema.Field>();
        Schema recordSchema = Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false);
        Schema.Field recordKeyField = new Schema.Field("_hoodie_record_key", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field partitionPathField = new Schema.Field("_hoodie_partition_path", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        toBeAddedFields.add(recordKeyField);
        toBeAddedFields.add(partitionPathField);
        recordSchema.setFields(toBeAddedFields);
        return recordSchema;
    }

    public static Schema getSchemaForFields(Schema fileSchema, List<String> fields) {
        ArrayList<Schema.Field> toBeAddedFields = new ArrayList<Schema.Field>();
        Schema recordSchema = Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false);
        for (Schema.Field schemaField : fileSchema.getFields()) {
            if (!fields.contains(schemaField.name())) continue;
            toBeAddedFields.add(new Schema.Field(schemaField.name(), schemaField.schema(), schemaField.doc(), schemaField.defaultVal()));
        }
        recordSchema.setFields(toBeAddedFields);
        return recordSchema;
    }

    public static GenericRecord addHoodieKeyToRecord(GenericRecord record, String recordKey, String partitionPath, String fileName) {
        record.put("_hoodie_file_name", (Object)fileName);
        record.put("_hoodie_partition_path", (Object)partitionPath);
        record.put("_hoodie_record_key", (Object)recordKey);
        return record;
    }

    public static GenericRecord addOperationToRecord(GenericRecord record, HoodieOperation operation) {
        record.put("_hoodie_operation", (Object)operation.getName());
        return record;
    }

    public static GenericRecord addCommitMetadataToRecord(GenericRecord record, String instantTime, String commitSeqno) {
        record.put("_hoodie_commit_time", (Object)instantTime);
        record.put("_hoodie_commit_seqno", (Object)commitSeqno);
        return record;
    }

    public static GenericRecord stitchRecords(GenericRecord left, GenericRecord right, Schema stitchedSchema) {
        GenericData.Record result = new GenericData.Record(stitchedSchema);
        for (Schema.Field f : left.getSchema().getFields()) {
            result.put(f.name(), left.get(f.name()));
        }
        for (Schema.Field f : right.getSchema().getFields()) {
            result.put(f.name(), right.get(f.name()));
        }
        return result;
    }

    public static GenericRecord rewriteRecord(GenericRecord oldRecord, Schema newSchema) {
        GenericData.Record newRecord = new GenericData.Record(newSchema);
        boolean isSpecificRecord = oldRecord instanceof SpecificRecordBase;
        for (Schema.Field f : newSchema.getFields()) {
            if (isSpecificRecord && HoodieAvroUtils.isMetadataField(f.name())) continue;
            HoodieAvroUtils.copyOldValueOrSetDefault(oldRecord, (GenericRecord)newRecord, f);
        }
        if (!ConvertingGenericData.INSTANCE.validate(newSchema, (Object)newRecord)) {
            throw new SchemaCompatibilityException("Unable to validate the rewritten record " + oldRecord + " against schema " + newSchema);
        }
        return newRecord;
    }

    public static GenericRecord rewriteRecordWithMetadata(GenericRecord genericRecord, Schema newSchema, String fileName) {
        GenericData.Record newRecord = new GenericData.Record(newSchema);
        for (Schema.Field f : newSchema.getFields()) {
            HoodieAvroUtils.copyOldValueOrSetDefault(genericRecord, (GenericRecord)newRecord, f);
        }
        newRecord.put(HoodieRecord.FILENAME_META_FIELD_ORD, (Object)fileName);
        if (!GenericData.get().validate(newSchema, (Object)newRecord)) {
            throw new SchemaCompatibilityException("Unable to validate the rewritten record " + genericRecord + " against schema " + newSchema);
        }
        return newRecord;
    }

    public static GenericRecord rewriteEvolutionRecordWithMetadata(GenericRecord genericRecord, Schema newSchema, String fileName) {
        GenericRecord newRecord = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)genericRecord, newSchema, new HashMap<String, String>());
        newRecord.put(HoodieRecord.FILENAME_META_FIELD_ORD, (Object)fileName);
        return newRecord;
    }

    public static List<GenericRecord> rewriteRecords(List<GenericRecord> records, Schema newSchema) {
        return records.stream().map(r -> HoodieAvroUtils.rewriteRecord(r, newSchema)).collect(Collectors.toList());
    }

    public static GenericRecord removeFields(GenericRecord record, Set<String> fieldsToRemove) {
        Schema newSchema = HoodieAvroUtils.removeFields(record.getSchema(), fieldsToRemove);
        return HoodieAvroUtils.rewriteRecord(record, newSchema);
    }

    private static void copyOldValueOrSetDefault(GenericRecord oldRecord, GenericRecord newRecord, Schema.Field field2) {
        Object fieldValue;
        Schema oldSchema = oldRecord.getSchema();
        Object object = fieldValue = oldSchema.getField(field2.name()) == null ? null : oldRecord.get(field2.name());
        if (fieldValue != null) {
            Object newFieldValue;
            if (fieldValue instanceof GenericRecord) {
                GenericRecord record = (GenericRecord)fieldValue;
                newFieldValue = HoodieAvroUtils.rewriteRecord(record, AvroSchemaUtils.resolveUnionSchema(field2.schema(), record.getSchema().getFullName()));
            } else {
                newFieldValue = fieldValue;
            }
            newRecord.put(field2.name(), newFieldValue);
        } else if (field2.defaultVal() instanceof JsonProperties.Null) {
            newRecord.put(field2.name(), null);
        } else {
            newRecord.put(field2.name(), field2.defaultVal());
        }
    }

    public static Schema generateProjectionSchema(Schema originalSchema, List<String> fieldNames) {
        Map<String, Schema.Field> schemaFieldsMap = originalSchema.getFields().stream().map(r -> Pair.of(r.name().toLowerCase(), r)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        ArrayList<Schema.Field> projectedFields = new ArrayList<Schema.Field>();
        for (String fn : fieldNames) {
            Schema.Field field2 = schemaFieldsMap.get(fn.toLowerCase());
            if (field2 == null) {
                throw new HoodieException("Field " + fn + " not found in log schema. Query cannot proceed! Derived Schema Fields: " + new ArrayList<String>(schemaFieldsMap.keySet()));
            }
            projectedFields.add(new Schema.Field(field2.name(), field2.schema(), field2.doc(), field2.defaultVal()));
        }
        Schema projectedSchema = Schema.createRecord((String)originalSchema.getName(), (String)originalSchema.getDoc(), (String)originalSchema.getNamespace(), (boolean)originalSchema.isError());
        projectedSchema.setFields(projectedFields);
        return projectedSchema;
    }

    public static String getRootLevelFieldName(String fieldName) {
        return fieldName.split("\\.")[0];
    }

    public static Object getFieldVal(GenericRecord record, String key) {
        return HoodieAvroUtils.getFieldVal(record, key, true);
    }

    public static Object getFieldVal(GenericRecord record, String key, boolean returnNullIfNotFound) {
        if (record.getSchema().getField(key) == null) {
            if (returnNullIfNotFound) {
                return null;
            }
            throw new AvroRuntimeException("Not a valid schema field: " + key);
        }
        return record.get(key);
    }

    public static String getNestedFieldValAsString(GenericRecord record, String fieldName, boolean returnNullIfNotFound, boolean consistentLogicalTimestampEnabled) {
        Object obj = HoodieAvroUtils.getNestedFieldVal(record, fieldName, returnNullIfNotFound, consistentLogicalTimestampEnabled);
        return StringUtils.objToString(obj);
    }

    public static Object getNestedFieldVal(GenericRecord record, String fieldName, boolean returnNullIfNotFound, boolean consistentLogicalTimestampEnabled) {
        String[] parts = fieldName.split("\\.");
        GenericRecord valueNode = record;
        for (int i = 0; i < parts.length; ++i) {
            Object val;
            String part = parts[i];
            try {
                val = HoodieAvroUtils.getFieldVal(valueNode, part, returnNullIfNotFound);
            }
            catch (AvroRuntimeException e) {
                if (returnNullIfNotFound) {
                    return null;
                }
                throw new HoodieException(fieldName + "(Part -" + parts[i] + ") field not found in record. Acceptable fields were :" + valueNode.getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
            }
            if (i == parts.length - 1) {
                if (val == null) {
                    return null;
                }
                Schema fieldSchema = valueNode.getSchema().getField(part).schema();
                return HoodieAvroUtils.convertValueForSpecificDataTypes(fieldSchema, val, consistentLogicalTimestampEnabled);
            }
            if (!(val instanceof GenericRecord)) {
                if (returnNullIfNotFound) {
                    return null;
                }
                throw new HoodieException("Cannot find a record at part value :" + part);
            }
            valueNode = (GenericRecord)val;
        }
        if (returnNullIfNotFound) {
            return null;
        }
        throw new HoodieException(fieldName + " field not found in record. Acceptable fields were :" + valueNode.getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
    }

    public static Schema getNestedFieldSchemaFromRecord(GenericRecord record, String fieldName) {
        String[] parts = fieldName.split("\\.");
        GenericRecord valueNode = record;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            Object val = valueNode.get(part);
            if (i == parts.length - 1) {
                return AvroSchemaUtils.resolveNullableSchema(valueNode.getSchema().getField(part).schema());
            }
            if (!(val instanceof GenericRecord)) {
                throw new HoodieException("Cannot find a record at part value :" + part);
            }
            valueNode = (GenericRecord)val;
        }
        throw new HoodieException("Failed to get schema. Not a valid field name: " + fieldName);
    }

    public static Schema getNestedFieldSchemaFromWriteSchema(Schema writeSchema, String fieldName) {
        String[] parts = fieldName.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            Schema schema = writeSchema.getField(part).schema();
            if (i != parts.length - 1) continue;
            return AvroSchemaUtils.resolveNullableSchema(schema);
        }
        throw new HoodieException("Failed to get schema. Not a valid field name: " + fieldName);
    }

    public static Option<String> getNullableValAsString(GenericRecord rec, String fieldName) {
        Schema.Field field2 = rec.getSchema().getField(fieldName);
        String fieldVal = field2 == null ? null : StringUtils.objToString(rec.get(field2.pos()));
        return Option.ofNullable(fieldVal);
    }

    public static Object convertValueForSpecificDataTypes(Schema fieldSchema, Object fieldValue, boolean consistentLogicalTimestampEnabled) {
        if (fieldSchema == null) {
            return fieldValue;
        }
        if (fieldValue == null) {
            ValidationUtils.checkState(AvroSchemaUtils.isNullable(fieldSchema));
            return null;
        }
        return HoodieAvroUtils.convertValueForAvroLogicalTypes(AvroSchemaUtils.resolveNullableSchema(fieldSchema), fieldValue, consistentLogicalTimestampEnabled);
    }

    private static Object convertValueForAvroLogicalTypes(Schema fieldSchema, Object fieldValue, boolean consistentLogicalTimestampEnabled) {
        if (fieldSchema.getLogicalType() == LogicalTypes.date()) {
            return LocalDate.ofEpochDay(Long.parseLong(fieldValue.toString()));
        }
        if (fieldSchema.getLogicalType() == LogicalTypes.timestampMillis() && consistentLogicalTimestampEnabled) {
            return new Timestamp(Long.parseLong(fieldValue.toString()));
        }
        if (fieldSchema.getLogicalType() == LogicalTypes.timestampMicros() && consistentLogicalTimestampEnabled) {
            return new Timestamp(Long.parseLong(fieldValue.toString()) / 1000L);
        }
        if (fieldSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
            LogicalTypes.Decimal dc = (LogicalTypes.Decimal)fieldSchema.getLogicalType();
            Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
            if (fieldSchema.getType() == Schema.Type.FIXED) {
                return decimalConversion.fromFixed((GenericFixed)fieldValue, fieldSchema, (LogicalType)LogicalTypes.decimal((int)dc.getPrecision(), (int)dc.getScale()));
            }
            if (fieldSchema.getType() == Schema.Type.BYTES) {
                ByteBuffer byteBuffer = (ByteBuffer)fieldValue;
                BigDecimal convertedValue = decimalConversion.fromBytes(byteBuffer, fieldSchema, (LogicalType)LogicalTypes.decimal((int)dc.getPrecision(), (int)dc.getScale()));
                byteBuffer.rewind();
                return convertedValue;
            }
        }
        return fieldValue;
    }

    public static Schema getNullSchema() {
        return Schema.create((Schema.Type)Schema.Type.NULL);
    }

    public static String sanitizeName(String name) {
        if (name.substring(0, 1).matches(INVALID_AVRO_FIRST_CHAR_IN_NAMES)) {
            name = name.replaceFirst(INVALID_AVRO_FIRST_CHAR_IN_NAMES, MASK_FOR_INVALID_CHARS_IN_NAMES);
        }
        return name.replaceAll(INVALID_AVRO_CHARS_IN_NAMES, MASK_FOR_INVALID_CHARS_IN_NAMES);
    }

    public static Object getRecordColumnValues(HoodieRecord<? extends HoodieRecordPayload> record, String[] columns, Schema schema, boolean consistentLogicalTimestampEnabled) {
        try {
            GenericRecord genericRecord = (GenericRecord)record.getData().getInsertValue(schema).get();
            if (columns.length == 1) {
                return HoodieAvroUtils.getNestedFieldVal(genericRecord, columns[0], true, consistentLogicalTimestampEnabled);
            }
            StringBuilder sb = new StringBuilder();
            for (String col : columns) {
                sb.append(HoodieAvroUtils.getNestedFieldValAsString(genericRecord, col, true, consistentLogicalTimestampEnabled));
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read record with key:" + record.getKey(), e);
        }
    }

    public static Object getRecordColumnValues(HoodieRecord<? extends HoodieRecordPayload> record, String[] columns, SerializableSchema schema, boolean consistentLogicalTimestampEnabled) {
        return HoodieAvroUtils.getRecordColumnValues(record, columns, schema.get(), consistentLogicalTimestampEnabled);
    }

    public static GenericRecord rewriteRecordWithNewSchema(IndexedRecord oldRecord, Schema newSchema, Map<String, String> renameCols) {
        Object newRecord = HoodieAvroUtils.rewriteRecordWithNewSchema(oldRecord, oldRecord.getSchema(), newSchema, renameCols, new LinkedList<String>());
        return (GenericData.Record)newRecord;
    }

    private static Object rewriteRecordWithNewSchema(Object oldRecord, Schema oldAvroSchema, Schema newSchema, Map<String, String> renameCols, Deque<String> fieldNames) {
        if (oldRecord == null) {
            return null;
        }
        Schema oldSchema = HoodieAvroUtils.getActualSchemaFromUnion(oldAvroSchema, oldRecord);
        switch (newSchema.getType()) {
            case RECORD: {
                if (!(oldRecord instanceof IndexedRecord)) {
                    throw new IllegalArgumentException("cannot rewrite record with different type");
                }
                IndexedRecord indexedRecord = (IndexedRecord)oldRecord;
                List fields = newSchema.getFields();
                GenericData.Record newRecord = new GenericData.Record(newSchema);
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.Field field2 = (Schema.Field)fields.get(i);
                    String fieldName = field2.name();
                    fieldNames.push(fieldName);
                    if (oldSchema.getField(field2.name()) != null && !renameCols.containsKey(field2.name())) {
                        Schema.Field oldField = oldSchema.getField(field2.name());
                        newRecord.put(i, HoodieAvroUtils.rewriteRecordWithNewSchema(indexedRecord.get(oldField.pos()), oldField.schema(), ((Schema.Field)fields.get(i)).schema(), renameCols, fieldNames));
                    } else {
                        String fieldFullName = HoodieAvroUtils.createFullName(fieldNames);
                        String fieldNameFromOldSchema = renameCols.getOrDefault(fieldFullName, "");
                        if (oldSchema.getField(fieldNameFromOldSchema) != null) {
                            Schema.Field oldField = oldSchema.getField(fieldNameFromOldSchema);
                            newRecord.put(i, HoodieAvroUtils.rewriteRecordWithNewSchema(indexedRecord.get(oldField.pos()), oldField.schema(), ((Schema.Field)fields.get(i)).schema(), renameCols, fieldNames));
                        } else if (((Schema.Field)fields.get(i)).defaultVal() instanceof JsonProperties.Null) {
                            newRecord.put(i, null);
                        } else {
                            newRecord.put(i, ((Schema.Field)fields.get(i)).defaultVal());
                        }
                    }
                    fieldNames.pop();
                }
                return newRecord;
            }
            case ARRAY: {
                if (!(oldRecord instanceof Collection)) {
                    throw new IllegalArgumentException("cannot rewrite record with different type");
                }
                Collection array = (Collection)oldRecord;
                ArrayList<Object> newArray = new ArrayList<Object>();
                fieldNames.push("element");
                for (Object element : array) {
                    newArray.add(HoodieAvroUtils.rewriteRecordWithNewSchema(element, oldSchema.getElementType(), newSchema.getElementType(), renameCols, fieldNames));
                }
                fieldNames.pop();
                return newArray;
            }
            case MAP: {
                if (!(oldRecord instanceof Map)) {
                    throw new IllegalArgumentException("cannot rewrite record with different type");
                }
                Map map = (Map)oldRecord;
                HashMap newMap = new HashMap();
                fieldNames.push("value");
                for (Map.Entry entry : map.entrySet()) {
                    newMap.put(entry.getKey(), HoodieAvroUtils.rewriteRecordWithNewSchema(entry.getValue(), oldSchema.getValueType(), newSchema.getValueType(), renameCols, fieldNames));
                }
                fieldNames.pop();
                return newMap;
            }
            case UNION: {
                return HoodieAvroUtils.rewriteRecordWithNewSchema(oldRecord, HoodieAvroUtils.getActualSchemaFromUnion(oldSchema, oldRecord), HoodieAvroUtils.getActualSchemaFromUnion(newSchema, oldRecord), renameCols, fieldNames);
            }
        }
        return HoodieAvroUtils.rewritePrimaryType(oldRecord, oldSchema, newSchema);
    }

    private static String createFullName(Deque<String> fieldNames) {
        String result = "";
        if (!fieldNames.isEmpty()) {
            ArrayList parentNames = new ArrayList();
            fieldNames.descendingIterator().forEachRemaining(parentNames::add);
            result = parentNames.stream().collect(Collectors.joining("."));
        }
        return result;
    }

    private static Object rewritePrimaryType(Object oldValue, Schema oldSchema, Schema newSchema) {
        if (oldSchema.getType() == newSchema.getType()) {
            switch (oldSchema.getType()) {
                case NULL: 
                case BOOLEAN: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BYTES: 
                case STRING: {
                    return oldValue;
                }
                case FIXED: {
                    if (oldSchema.getFixedSize() != newSchema.getFixedSize()) {
                        if (oldSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
                            byte[] bytes = ((GenericFixed)oldValue).bytes();
                            LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)oldSchema.getLogicalType();
                            BigDecimal bd = new BigDecimal(new BigInteger(bytes), decimal.getScale()).setScale(((LogicalTypes.Decimal)newSchema.getLogicalType()).getScale());
                            return DECIMAL_CONVERSION.toFixed(bd, newSchema, newSchema.getLogicalType());
                        }
                        throw new UnsupportedOperationException("Fixed type size change is not currently supported");
                    }
                    if (Objects.equals(oldSchema.getFullName(), newSchema.getFullName())) {
                        return oldValue;
                    }
                    return new GenericData.Fixed(newSchema, ((GenericFixed)oldValue).bytes());
                }
            }
            throw new AvroRuntimeException("Unknown schema type: " + newSchema.getType());
        }
        return HoodieAvroUtils.rewritePrimaryTypeWithDiffSchemaType(oldValue, oldSchema, newSchema);
    }

    private static Object rewritePrimaryTypeWithDiffSchemaType(Object oldValue, Schema oldSchema, Schema newSchema) {
        switch (newSchema.getType()) {
            case NULL: 
            case BOOLEAN: {
                break;
            }
            case INT: {
                if (newSchema.getLogicalType() != LogicalTypes.date() || oldSchema.getType() != Schema.Type.STRING) break;
                return HoodieAvroUtils.fromJavaDate(Date.valueOf(oldValue.toString()));
            }
            case LONG: {
                if (oldSchema.getType() != Schema.Type.INT) break;
                return ((Integer)oldValue).longValue();
            }
            case FLOAT: {
                if (oldSchema.getType() != Schema.Type.INT && oldSchema.getType() != Schema.Type.LONG) break;
                return Float.valueOf(oldSchema.getType() == Schema.Type.INT ? ((Integer)oldValue).floatValue() : ((Long)oldValue).floatValue());
            }
            case DOUBLE: {
                if (oldSchema.getType() == Schema.Type.FLOAT) {
                    return Double.valueOf(oldValue + "");
                }
                if (oldSchema.getType() == Schema.Type.INT) {
                    return ((Integer)oldValue).doubleValue();
                }
                if (oldSchema.getType() != Schema.Type.LONG) break;
                return ((Long)oldValue).doubleValue();
            }
            case BYTES: {
                if (oldSchema.getType() != Schema.Type.STRING) break;
                return oldValue.toString().getBytes(StandardCharsets.UTF_8);
            }
            case STRING: {
                if (oldSchema.getType() == Schema.Type.BYTES) {
                    return String.valueOf((byte[])oldValue);
                }
                if (oldSchema.getLogicalType() == LogicalTypes.date()) {
                    return HoodieAvroUtils.toJavaDate((Integer)oldValue).toString();
                }
                if (oldSchema.getType() == Schema.Type.INT || oldSchema.getType() == Schema.Type.LONG || oldSchema.getType() == Schema.Type.FLOAT || oldSchema.getType() == Schema.Type.DOUBLE) {
                    return oldValue.toString();
                }
                if (oldSchema.getType() != Schema.Type.FIXED || !(oldSchema.getLogicalType() instanceof LogicalTypes.Decimal)) break;
                byte[] bytes = ((GenericFixed)oldValue).bytes();
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)oldSchema.getLogicalType();
                BigDecimal bd = new BigDecimal(new BigInteger(bytes), decimal.getScale());
                return bd.toString();
            }
            case FIXED: {
                if (!(newSchema.getLogicalType() instanceof LogicalTypes.Decimal) || oldSchema.getType() != Schema.Type.STRING && oldSchema.getType() != Schema.Type.DOUBLE && oldSchema.getType() != Schema.Type.INT && oldSchema.getType() != Schema.Type.LONG && oldSchema.getType() != Schema.Type.FLOAT) break;
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)newSchema.getLogicalType();
                BigDecimal bigDecimal = null;
                bigDecimal = oldSchema.getType() == Schema.Type.STRING ? new BigDecimal(oldValue.toString()).setScale(decimal.getScale()) : new BigDecimal(oldValue.toString()).setScale(decimal.getScale());
                return DECIMAL_CONVERSION.toFixed(bigDecimal, newSchema, newSchema.getLogicalType());
            }
        }
        throw new AvroRuntimeException(String.format("cannot support rewrite value for schema type: %s since the old schema type is: %s", newSchema, oldSchema));
    }

    public static Date toJavaDate(int days) {
        LocalDate date = LocalDate.ofEpochDay(days);
        ZoneId defaultZoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = date.atStartOfDay(defaultZoneId);
        return new Date(zonedDateTime.toInstant().toEpochMilli());
    }

    public static int fromJavaDate(Date date) {
        long millisUtc = date.getTime();
        long millisLocal = millisUtc + (long)TimeZone.getDefault().getOffset(millisUtc);
        int julianDays = Math.toIntExact(Math.floorDiv(millisLocal, 86400000L));
        return julianDays;
    }

    private static Schema getActualSchemaFromUnion(Schema schema, Object data) {
        Schema actualSchema;
        if (!schema.getType().equals((Object)Schema.Type.UNION)) {
            return schema;
        }
        if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
            actualSchema = (Schema)schema.getTypes().get(1);
        } else if (schema.getTypes().size() == 2 && ((Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL) {
            actualSchema = (Schema)schema.getTypes().get(0);
        } else if (schema.getTypes().size() == 1) {
            actualSchema = (Schema)schema.getTypes().get(0);
        } else {
            int i = GenericData.get().resolveUnion(schema, data);
            actualSchema = (Schema)schema.getTypes().get(i);
        }
        return actualSchema;
    }

    public static Iterator<GenericRecord> rewriteRecordWithNewSchema(final Iterator<GenericRecord> oldRecords, final Schema newSchema, final Map<String, String> renameCols) {
        if (oldRecords == null || newSchema == null) {
            return Collections.emptyIterator();
        }
        return new Iterator<GenericRecord>(){

            @Override
            public boolean hasNext() {
                return oldRecords.hasNext();
            }

            @Override
            public GenericRecord next() {
                return HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)oldRecords.next(), newSchema, (Map<String, String>)renameCols);
            }
        };
    }

    public static GenericRecord rewriteRecordDeep(GenericRecord oldRecord, Schema newSchema) {
        return HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)oldRecord, newSchema, (Map<String, String>)Collections.EMPTY_MAP);
    }

    public static boolean gteqAvro1_9() {
        return VersionUtil.compareVersions((String)AVRO_VERSION, (String)"1.9") >= 0;
    }

    public static boolean gteqAvro1_10() {
        return VersionUtil.compareVersions((String)AVRO_VERSION, (String)"1.10") >= 0;
    }
}

