/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import com.codahale.metrics.Timer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.JavaHoodieIndexFactory;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieJavaTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.upgrade.JavaUpgradeDowngradeHelper;

public class HoodieJavaWriteClient<T extends HoodieRecordPayload>
extends BaseHoodieWriteClient<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    public HoodieJavaWriteClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        super(context, clientConfig, JavaUpgradeDowngradeHelper.getInstance());
    }

    public HoodieJavaWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, timelineService, JavaUpgradeDowngradeHelper.getInstance());
    }

    @Override
    public List<HoodieRecord<T>> filterExists(List<HoodieRecord<T>> hoodieRecords) {
        HoodieJavaTable table = HoodieJavaTable.create(this.config, (HoodieJavaEngineContext)this.context);
        Timer.Context indexTimer = this.metrics.getIndexCtx();
        List recordsWithLocation = this.getIndex().tagLocation(HoodieListData.eager(hoodieRecords), this.context, (HoodieTable)table).collectAsList();
        this.metrics.updateIndexMetrics("lookup", this.metrics.getDurationInMs(indexTimer == null ? 0L : indexTimer.stop()));
        return recordsWithLocation.stream().filter(v1 -> !v1.isCurrentLocationKnown()).collect(Collectors.toList());
    }

    @Override
    protected HoodieIndex createIndex(HoodieWriteConfig writeConfig) {
        return JavaHoodieIndexFactory.createIndex(this.config);
    }

    @Override
    public boolean commit(String instantTime, List<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds) {
        List<HoodieWriteStat> writeStats = writeStatuses.stream().map(WriteStatus::getStat).collect(Collectors.toList());
        return this.commitStats(instantTime, writeStats, extraMetadata, commitActionType, partitionToReplacedFileIds);
    }

    @Override
    protected HoodieTable createTable(HoodieWriteConfig config, Configuration hadoopConf) {
        return HoodieJavaTable.create(config, this.context);
    }

    @Override
    protected HoodieTable createTable(HoodieWriteConfig config, Configuration hadoopConf, HoodieTableMetaClient metaClient) {
        return HoodieJavaTable.create(config, this.context, metaClient);
    }

    @Override
    public List<WriteStatus> upsert(List<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT, Option.ofNullable(instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.upsert(this.context, instantTime, records);
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", result.getIndexLookupDuration().get().toMillis());
        }
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public List<WriteStatus> upsertPreppedRecords(List<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT_PREPPED, Option.ofNullable(instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.upsertPrepped(this.context, instantTime, preppedRecords);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public List<WriteStatus> insert(List<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT, Option.ofNullable(instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.insert(this.context, instantTime, records);
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", result.getIndexLookupDuration().get().toMillis());
        }
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public List<WriteStatus> insertPreppedRecords(List<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_PREPPED, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.insertPrepped(this.context, instantTime, preppedRecords);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public List<WriteStatus> bulkInsert(List<HoodieRecord<T>> records, String instantTime) {
        throw new HoodieNotSupportedException("BulkInsert is not supported in HoodieJavaClient");
    }

    @Override
    public List<WriteStatus> bulkInsert(List<HoodieRecord<T>> records, String instantTime, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        throw new HoodieNotSupportedException("BulkInsert is not supported in HoodieJavaClient");
    }

    public void transitionInflight(String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        metaClient.getActiveTimeline().transitionRequestedToInflight(new HoodieInstant(HoodieInstant.State.REQUESTED, metaClient.getCommitActionType(), instantTime), Option.empty(), this.config.shouldAllowMultiWriteOnSameInstant());
    }

    @Override
    public List<WriteStatus> bulkInsertPreppedRecords(List<HoodieRecord<T>> preppedRecords, String instantTime, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        HoodieTable table = this.initTable(WriteOperationType.BULK_INSERT_PREPPED, Option.ofNullable(instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsertPrepped(this.context, instantTime, preppedRecords, bulkInsertPartitioner);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public List<WriteStatus> delete(List<HoodieKey> keys2, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE, Option.ofNullable(instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE, table.getMetaClient());
        HoodieWriteMetadata result = table.delete(this.context, instantTime, keys2);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    protected List<WriteStatus> postWrite(HoodieWriteMetadata<List<WriteStatus>> result, String instantTime, HoodieTable hoodieTable) {
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics(this.getOperationType().name(), result.getIndexUpdateDuration().get().toMillis());
        }
        if (result.isCommitted()) {
            if (result.getFinalizeDuration().isPresent()) {
                this.metrics.updateFinalizeWriteMetrics(result.getFinalizeDuration().get().toMillis(), result.getWriteStats().get().size());
            }
            this.postCommit(hoodieTable, result.getCommitMetadata().get(), instantTime, Option.empty());
            this.mayBeCleanAndArchive(hoodieTable);
            this.emitCommitMetrics(instantTime, result.getCommitMetadata().get(), hoodieTable.getMetaClient().getCommitActionType());
        }
        return result.getWriteStatuses();
    }

    @Override
    public void commitCompaction(String compactionInstantTime, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        throw new HoodieNotSupportedException("CommitCompaction is not supported in HoodieJavaClient");
    }

    @Override
    protected void completeCompaction(HoodieCommitMetadata metadata, HoodieTable table, String compactionCommitTime) {
        throw new HoodieNotSupportedException("CompleteCompaction is not supported in HoodieJavaClient");
    }

    @Override
    protected HoodieWriteMetadata<List<WriteStatus>> compact(String compactionInstantTime, boolean shouldComplete) {
        throw new HoodieNotSupportedException("Compact is not supported in HoodieJavaClient");
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> cluster(String clusteringInstant, boolean shouldComplete) {
        throw new HoodieNotSupportedException("Cluster is not supported in HoodieJavaClient");
    }
}

