/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieFlinkCopyOnWriteTable;
import org.apache.hudi.table.HoodieFlinkMergeOnReadTable;
import org.apache.hudi.table.action.cluster.strategy.PartitionAwareClusteringPlanStrategy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FlinkSizeBasedClusteringPlanStrategy<T extends HoodieRecordPayload<T>>
extends PartitionAwareClusteringPlanStrategy<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(FlinkSizeBasedClusteringPlanStrategy.class);

    public FlinkSizeBasedClusteringPlanStrategy(HoodieFlinkCopyOnWriteTable<T> table, HoodieFlinkEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    public FlinkSizeBasedClusteringPlanStrategy(HoodieFlinkMergeOnReadTable<T> table, HoodieFlinkEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    protected Stream<HoodieClusteringGroup> buildClusteringGroupsForPartition(String partitionPath, List<FileSlice> fileSlices) {
        HoodieWriteConfig writeConfig = this.getWriteConfig();
        ArrayList fileSliceGroups = new ArrayList();
        ArrayList<FileSlice> currentGroup = new ArrayList<FileSlice>();
        long totalSizeSoFar = 0L;
        for (FileSlice currentSlice : fileSlices) {
            if (totalSizeSoFar >= writeConfig.getClusteringTargetFileMaxBytes() && !currentGroup.isEmpty()) {
                LOG.info((Object)("Adding one clustering group " + totalSizeSoFar + " max bytes: " + writeConfig.getClusteringMaxBytesInGroup() + " num input slices: " + currentGroup.size()));
                fileSliceGroups.add(Pair.of(currentGroup, 1));
                currentGroup = new ArrayList();
                totalSizeSoFar = 0L;
            }
            currentGroup.add(currentSlice);
            totalSizeSoFar += currentSlice.getBaseFile().isPresent() ? currentSlice.getBaseFile().get().getFileSize() : writeConfig.getParquetMaxFileSize();
        }
        if (!currentGroup.isEmpty()) {
            fileSliceGroups.add(Pair.of(currentGroup, 1));
        }
        return fileSliceGroups.stream().map(fileSliceGroup -> HoodieClusteringGroup.newBuilder().setSlices(FlinkSizeBasedClusteringPlanStrategy.getFileSliceInfo((List)fileSliceGroup.getLeft())).setNumOutputFileGroups((Integer)fileSliceGroup.getRight()).setMetrics(this.buildMetrics((List)fileSliceGroup.getLeft())).build());
    }

    @Override
    protected Map<String, String> getStrategyParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isNullOrEmpty(this.getWriteConfig().getClusteringSortColumns())) {
            params.put(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key(), this.getWriteConfig().getClusteringSortColumns());
        }
        return params;
    }

    @Override
    protected Stream<FileSlice> getFileSlicesEligibleForClustering(String partition) {
        return super.getFileSlicesEligibleForClustering(partition).filter(slice -> slice.getBaseFile().map(BaseFile::getFileSize).orElse(0L) < this.getWriteConfig().getClusteringSmallFileLimit());
    }
}

