/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.connect.utils;

import io.hops.hudi.com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SerializationUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.connect.ControlMessage;
import org.apache.hudi.connect.writers.KafkaConnectConfigs;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class KafkaConnectUtils {
    private static final Logger LOG = LogManager.getLogger(KafkaConnectUtils.class);
    private static final String HOODIE_CONF_PREFIX = "hoodie.";
    public static final String HADOOP_CONF_DIR = "HADOOP_CONF_DIR";
    public static final String HADOOP_HOME = "HADOOP_HOME";
    private static final List<java.nio.file.Path> DEFAULT_HADOOP_CONF_FILES = new ArrayList<java.nio.file.Path>();

    public static List<java.nio.file.Path> getHadoopConfigFiles(String hadoopConfigPath, String hadoopHomePath) throws IOException {
        ArrayList<java.nio.file.Path> hadoopConfigFiles = new ArrayList<java.nio.file.Path>();
        if (!StringUtils.isNullOrEmpty(hadoopConfigPath)) {
            hadoopConfigFiles.addAll(KafkaConnectUtils.walkTreeForXml(Paths.get(hadoopConfigPath, new String[0])));
        }
        if (hadoopConfigFiles.isEmpty() && !StringUtils.isNullOrEmpty(hadoopHomePath)) {
            hadoopConfigFiles.addAll(KafkaConnectUtils.walkTreeForXml(Paths.get(hadoopHomePath, "etc", "hadoop")));
        }
        return hadoopConfigFiles;
    }

    private static List<java.nio.file.Path> walkTreeForXml(java.nio.file.Path basePath) throws IOException {
        if (Files.notExists(basePath, new LinkOption[0])) {
            return new ArrayList<java.nio.file.Path>();
        }
        return Files.walk(basePath, FileVisitOption.FOLLOW_LINKS).filter(path -> path.toFile().isFile()).filter(path -> path.toString().endsWith(".xml")).collect(Collectors.toList());
    }

    public static int getLatestNumPartitions(String bootstrapServers, String topicName) {
        Properties props = new Properties();
        props.put("bootstrap.servers", bootstrapServers);
        try {
            AdminClient client = AdminClient.create((Properties)props);
            DescribeTopicsResult result = client.describeTopics(Arrays.asList(topicName));
            Map values2 = result.values();
            KafkaFuture topicDescription = (KafkaFuture)values2.get(topicName);
            int numPartitions = ((TopicDescription)topicDescription.get()).partitions().size();
            LOG.info((Object)String.format("Latest number of partitions for topic %s is %s", topicName, numPartitions));
            return numPartitions;
        }
        catch (Exception exception) {
            throw new HoodieException("Fatal error fetching the latest partition of kafka topic name" + topicName, exception);
        }
    }

    public static Configuration getDefaultHadoopConf(KafkaConnectConfigs connectConfigs) {
        Configuration hadoopConf = new Configuration();
        if (!StringUtils.isNullOrEmpty(connectConfigs.getHadoopConfDir()) || !StringUtils.isNullOrEmpty(connectConfigs.getHadoopConfHome())) {
            try {
                List<java.nio.file.Path> configFiles = KafkaConnectUtils.getHadoopConfigFiles(connectConfigs.getHadoopConfDir(), connectConfigs.getHadoopConfHome());
                configFiles.forEach(f -> hadoopConf.addResource(new Path(f.toAbsolutePath().toUri())));
            }
            catch (Exception e) {
                throw new HoodieException("Failed to read hadoop configuration!", e);
            }
        } else {
            DEFAULT_HADOOP_CONF_FILES.forEach(f -> hadoopConf.addResource(new Path(f.toAbsolutePath().toUri())));
        }
        connectConfigs.getProps().keySet().stream().filter(prop -> !prop.toString().startsWith(HOODIE_CONF_PREFIX)).forEach(prop -> hadoopConf.set(prop.toString(), connectConfigs.getProps().get(prop.toString()).toString()));
        return hadoopConf;
    }

    public static String getRecordKeyColumns(KeyGenerator keyGenerator) {
        return String.join((CharSequence)",", keyGenerator.getRecordKeyFieldNames());
    }

    public static String getPartitionColumns(KeyGenerator keyGenerator, TypedProperties typedProperties) {
        if (keyGenerator instanceof CustomAvroKeyGenerator) {
            return ((BaseKeyGenerator)keyGenerator).getPartitionPathFields().stream().map(pathField -> Arrays.stream(pathField.split(":")).findFirst().orElse("Illegal partition path field format: '$pathField' for ${c.getClass.getSimpleName}")).collect(Collectors.joining(","));
        }
        if (keyGenerator instanceof BaseKeyGenerator) {
            return String.join((CharSequence)",", ((BaseKeyGenerator)keyGenerator).getPartitionPathFields());
        }
        return typedProperties.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
    }

    public static Option<HoodieCommitMetadata> getCommitMetadataForLatestInstant(HoodieTableMetaClient metaClient) {
        HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().filter(instant -> metaClient.getTableType() == HoodieTableType.COPY_ON_WRITE && instant.getAction().equals("commit") || metaClient.getTableType() == HoodieTableType.MERGE_ON_READ && instant.getAction().equals("deltacommit"));
        Option<HoodieInstant> latestInstant = timeline.lastInstant();
        if (latestInstant.isPresent()) {
            try {
                byte[] data = timeline.getInstantDetails(latestInstant.get()).get();
                return Option.of(HoodieCommitMetadata.fromBytes(data, HoodieCommitMetadata.class));
            }
            catch (Exception e) {
                throw new HoodieException("Failed to read schema from commit metadata", e);
            }
        }
        return Option.empty();
    }

    public static String hashDigest(String stringToHash) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"Fatal error selecting hash algorithm", (Throwable)e);
            throw new HoodieException(e);
        }
        byte[] digest = Objects.requireNonNull(md).digest(stringToHash.getBytes(StandardCharsets.UTF_8));
        return StringUtils.toHexString(digest).toUpperCase();
    }

    public static ControlMessage.ConnectWriteStatus buildWriteStatuses(List<WriteStatus> writeStatuses) throws IOException {
        return ControlMessage.ConnectWriteStatus.newBuilder().setSerializedWriteStatus(ByteString.copyFrom(SerializationUtils.serialize(writeStatuses))).build();
    }

    public static List<WriteStatus> getWriteStatuses(ControlMessage.ParticipantInfo participantInfo) {
        ControlMessage.ConnectWriteStatus connectWriteStatus = participantInfo.getWriteStatus();
        return (List)SerializationUtils.deserialize(connectWriteStatus.getSerializedWriteStatus().toByteArray());
    }

    static {
        try {
            String hadoopConfigPath = System.getenv(HADOOP_CONF_DIR);
            String hadoopHomePath = System.getenv(HADOOP_HOME);
            DEFAULT_HADOOP_CONF_FILES.addAll(KafkaConnectUtils.getHadoopConfigFiles(hadoopConfigPath, hadoopHomePath));
            if (!DEFAULT_HADOOP_CONF_FILES.isEmpty()) {
                LOG.info((Object)String.format("Found Hadoop default config files %s", DEFAULT_HADOOP_CONF_FILES));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"An error occurred while getting the default Hadoop configuration. Please use hadoop.conf.dir or hadoop.home to configure Hadoop environment variables", (Throwable)e);
        }
    }
}

