/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.convert;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;

public class AvroInternalSchemaConverter {
    private static final String AVRO_NAME_DELIMITER = ".";

    public static Schema convert(InternalSchema internalSchema, String tableName) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromInternalSchema(internalSchema, tableName);
    }

    public static Schema convert(Types.RecordType type, String name) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromType(type, name);
    }

    public static Schema convert(Type type, String name) {
        return AvroInternalSchemaConverter.buildAvroSchemaFromType(type, name);
    }

    public static Type convertToField(Schema schema) {
        return AvroInternalSchemaConverter.buildTypeFromAvroSchema(schema);
    }

    public static InternalSchema convert(Schema schema) {
        List<Types.Field> fields = ((Types.RecordType)AvroInternalSchemaConverter.convertToField(schema)).fields();
        return new InternalSchema(fields);
    }

    public static boolean isOptional(Schema schema) {
        if (schema.getType() == Schema.Type.UNION && schema.getTypes().size() == 2) {
            return ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL || ((Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL;
        }
        return false;
    }

    public static Schema nullableSchema(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            if (!AvroInternalSchemaConverter.isOptional(schema)) {
                throw new HoodieSchemaException(String.format("Union schemas are not supported: %s", schema));
            }
            return schema;
        }
        return Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema});
    }

    public static Type buildTypeFromAvroSchema(Schema schema) {
        LinkedList<String> visited = new LinkedList<String>();
        AtomicInteger nextId = new AtomicInteger(1);
        return AvroInternalSchemaConverter.visitAvroSchemaToBuildType(schema, visited, true, nextId);
    }

    private static Type visitAvroSchemaToBuildType(Schema schema, Deque<String> visited, Boolean firstVisitRoot, AtomicInteger nextId) {
        switch (schema.getType()) {
            case RECORD: {
                String name = schema.getFullName();
                if (visited.contains(name)) {
                    throw new HoodieSchemaException(String.format("cannot convert recursive avro record %s", name));
                }
                visited.push(name);
                List fields = schema.getFields();
                ArrayList fieldTypes = new ArrayList(fields.size());
                int nextAssignId = nextId.get();
                if (firstVisitRoot.booleanValue()) {
                    nextAssignId = 0;
                }
                nextId.set(nextAssignId + fields.size());
                fields.stream().forEach(field2 -> fieldTypes.add(AvroInternalSchemaConverter.visitAvroSchemaToBuildType(field2.schema(), visited, false, nextId)));
                visited.pop();
                ArrayList<Types.Field> internalFields = new ArrayList<Types.Field>(fields.size());
                for (int i = 0; i < fields.size(); ++i) {
                    Schema.Field field3 = (Schema.Field)fields.get(i);
                    Type fieldType = (Type)fieldTypes.get(i);
                    internalFields.add(Types.Field.get(nextAssignId, AvroInternalSchemaConverter.isOptional(field3.schema()), field3.name(), fieldType, field3.doc()));
                    ++nextAssignId;
                }
                return Types.RecordType.get(internalFields);
            }
            case UNION: {
                ArrayList fTypes = new ArrayList();
                schema.getTypes().stream().forEach(t -> fTypes.add(AvroInternalSchemaConverter.visitAvroSchemaToBuildType(t, visited, false, nextId)));
                return fTypes.get(0) == null ? (Type)fTypes.get(1) : (Type)fTypes.get(0);
            }
            case ARRAY: {
                Schema elementSchema = schema.getElementType();
                int elementId = nextId.get();
                nextId.set(elementId + 1);
                Type elementType = AvroInternalSchemaConverter.visitAvroSchemaToBuildType(elementSchema, visited, false, nextId);
                return Types.ArrayType.get(elementId, AvroInternalSchemaConverter.isOptional(schema.getElementType()), elementType);
            }
            case MAP: {
                int keyId = nextId.get();
                int valueId = keyId + 1;
                nextId.set(valueId + 1);
                Type valueType = AvroInternalSchemaConverter.visitAvroSchemaToBuildType(schema.getValueType(), visited, false, nextId);
                return Types.MapType.get(keyId, valueId, Types.StringType.get(), valueType, AvroInternalSchemaConverter.isOptional(schema.getValueType()));
            }
        }
        return AvroInternalSchemaConverter.visitAvroPrimitiveToBuildInternalType(schema);
    }

    private static Type visitAvroPrimitiveToBuildInternalType(Schema primitive) {
        LogicalType logical = primitive.getLogicalType();
        if (logical != null) {
            String name = logical.getName();
            if (logical instanceof LogicalTypes.Decimal) {
                return Types.DecimalType.get(((LogicalTypes.Decimal)logical).getPrecision(), ((LogicalTypes.Decimal)logical).getScale());
            }
            if (logical instanceof LogicalTypes.Date) {
                return Types.DateType.get();
            }
            if (logical instanceof LogicalTypes.TimeMillis || logical instanceof LogicalTypes.TimeMicros) {
                return Types.TimeType.get();
            }
            if (logical instanceof LogicalTypes.TimestampMillis || logical instanceof LogicalTypes.TimestampMicros) {
                return Types.TimestampType.get();
            }
            if (LogicalTypes.uuid().getName().equals(name)) {
                return Types.UUIDType.get();
            }
        }
        switch (primitive.getType()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case INT: {
                return Types.IntType.get();
            }
            case LONG: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case STRING: 
            case ENUM: {
                return Types.StringType.get();
            }
            case FIXED: {
                return Types.FixedType.getFixed(primitive.getFixedSize());
            }
            case BYTES: {
                return Types.BinaryType.get();
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + primitive);
    }

    public static Schema buildAvroSchemaFromType(Type type, String recordName) {
        HashMap<Type, Schema> cache = new HashMap<Type, Schema>();
        return AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(type, cache, recordName);
    }

    public static Schema buildAvroSchemaFromInternalSchema(InternalSchema schema, String recordName) {
        HashMap<Type, Schema> cache = new HashMap<Type, Schema>();
        return AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(schema.getRecord(), cache, recordName);
    }

    private static Schema visitInternalSchemaToBuildAvroSchema(Type type, Map<Type, Schema> cache, String recordName) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                ArrayList<Schema> schemas = new ArrayList<Schema>();
                record.fields().forEach(f -> {
                    String nestedRecordName = recordName + AVRO_NAME_DELIMITER + f.name();
                    Schema tempSchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(f.type(), cache, nestedRecordName);
                    Schema result = f.isOptional() ? AvroInternalSchemaConverter.nullableSchema(tempSchema) : tempSchema;
                    schemas.add(result);
                });
                Schema recordSchema = cache.get(record);
                if (recordSchema != null) {
                    return recordSchema;
                }
                recordSchema = AvroInternalSchemaConverter.visitInternalRecordToBuildAvroRecord(record, schemas, recordName);
                cache.put(record, recordSchema);
                return recordSchema;
            }
            case ARRAY: {
                Types.ArrayType array = (Types.ArrayType)type;
                Schema elementSchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(array.elementType(), cache, recordName);
                Schema arraySchema = cache.get(array);
                if (arraySchema != null) {
                    return arraySchema;
                }
                arraySchema = AvroInternalSchemaConverter.visitInternalArrayToBuildAvroArray(array, elementSchema);
                cache.put(array, arraySchema);
                return arraySchema;
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                Schema keySchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(map.keyType(), cache, recordName);
                Schema valueSchema = AvroInternalSchemaConverter.visitInternalSchemaToBuildAvroSchema(map.valueType(), cache, recordName);
                Schema mapSchema = cache.get(map);
                if (mapSchema != null) {
                    return mapSchema;
                }
                mapSchema = AvroInternalSchemaConverter.visitInternalMapToBuildAvroMap(map, keySchema, valueSchema);
                cache.put(map, mapSchema);
                return mapSchema;
            }
        }
        Schema primitiveSchema = AvroInternalSchemaConverter.visitInternalPrimitiveToBuildAvroPrimitiveType((Type.PrimitiveType)type, recordName);
        cache.put(type, primitiveSchema);
        return primitiveSchema;
    }

    private static Schema visitInternalRecordToBuildAvroRecord(Types.RecordType recordType, List<Schema> fieldSchemas, String recordNameFallback) {
        List<Types.Field> fields = recordType.fields();
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (int i = 0; i < fields.size(); ++i) {
            Types.Field f = fields.get(i);
            Schema.Field field2 = new Schema.Field(f.name(), fieldSchemas.get(i), f.doc(), f.isOptional() ? JsonProperties.NULL_VALUE : null);
            avroFields.add(field2);
        }
        String recordName = Option.ofNullable(recordType.name()).orElse(recordNameFallback);
        return Schema.createRecord((String)recordName, null, null, (boolean)false, avroFields);
    }

    private static Schema visitInternalArrayToBuildAvroArray(Types.ArrayType array, Schema elementSchema) {
        Schema result = array.isElementOptional() ? Schema.createArray((Schema)AvroInternalSchemaConverter.nullableSchema(elementSchema)) : Schema.createArray((Schema)elementSchema);
        return result;
    }

    private static Schema visitInternalMapToBuildAvroMap(Types.MapType map, Schema keySchema, Schema valueSchema) {
        if (keySchema.getType() != Schema.Type.STRING) {
            throw new HoodieSchemaException("only support StringType key for avro MapType");
        }
        Schema mapSchema = Schema.createMap((Schema)(map.isValueOptional() ? AvroInternalSchemaConverter.nullableSchema(valueSchema) : valueSchema));
        return mapSchema;
    }

    private static Schema visitInternalPrimitiveToBuildAvroPrimitiveType(Type.PrimitiveType primitive, String recordName) {
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case INT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case LONG: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case DATE: {
                return LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
            }
            case TIME: {
                return LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case TIMESTAMP: {
                return LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case STRING: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case BINARY: {
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            case UUID: {
                String name = recordName + AVRO_NAME_DELIMITER + "fixed";
                Schema fixedSchema = Schema.createFixed((String)name, null, null, (int)16);
                return LogicalTypes.uuid().addToSchema(fixedSchema);
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)primitive;
                String name = recordName + AVRO_NAME_DELIMITER + "fixed";
                return Schema.createFixed((String)name, null, null, (int)fixed.getFixedSize());
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                String name = recordName + AVRO_NAME_DELIMITER + "fixed";
                Schema fixedSchema = Schema.createFixed((String)name, null, null, (int)AvroInternalSchemaConverter.computeMinBytesForPrecision(decimal.precision()));
                return LogicalTypes.decimal((int)decimal.precision(), (int)decimal.scale()).addToSchema(fixedSchema);
            }
        }
        throw new UnsupportedOperationException("Unsupported type ID: " + (Object)((Object)primitive.typeId()));
    }

    private static int computeMinBytesForPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }
}

