/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row.parquet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.flink.formats.parquet.utils.ParquetSchemaConverter;
import org.apache.flink.formats.parquet.vector.reader.TimestampColumnReader;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.util.Preconditions;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;

public class ParquetRowDataWriter {
    private final RecordConsumer recordConsumer;
    private final boolean utcTimestamp;
    private final FieldWriter[] filedWriters;
    private final String[] fieldNames;

    public ParquetRowDataWriter(RecordConsumer recordConsumer, RowType rowType, GroupType schema, boolean utcTimestamp) {
        this.recordConsumer = recordConsumer;
        this.utcTimestamp = utcTimestamp;
        this.filedWriters = new FieldWriter[rowType.getFieldCount()];
        this.fieldNames = rowType.getFieldNames().toArray(new String[0]);
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            this.filedWriters[i] = this.createWriter(rowType.getTypeAt(i));
        }
    }

    public void write(RowData record) {
        this.recordConsumer.startMessage();
        for (int i = 0; i < this.filedWriters.length; ++i) {
            if (record.isNullAt(i)) continue;
            String fieldName = this.fieldNames[i];
            FieldWriter writer = this.filedWriters[i];
            this.recordConsumer.startField(fieldName, i);
            writer.write(record, i);
            this.recordConsumer.endField(fieldName, i);
        }
        this.recordConsumer.endMessage();
    }

    private FieldWriter createWriter(LogicalType t) {
        switch (t.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return new StringWriter();
            }
            case BOOLEAN: {
                return new BooleanWriter();
            }
            case BINARY: 
            case VARBINARY: {
                return new BinaryWriter();
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)t;
                return this.createDecimalWriter(decimalType.getPrecision(), decimalType.getScale());
            }
            case TINYINT: {
                return new ByteWriter();
            }
            case SMALLINT: {
                return new ShortWriter();
            }
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTEGER: {
                return new IntWriter();
            }
            case BIGINT: {
                return new LongWriter();
            }
            case FLOAT: {
                return new FloatWriter();
            }
            case DOUBLE: {
                return new DoubleWriter();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)t;
                if (timestampType.getPrecision() == 3) {
                    return new Timestamp64Writer();
                }
                return new Timestamp96Writer(timestampType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)t;
                if (localZonedTimestampType.getPrecision() == 3) {
                    return new Timestamp64Writer();
                }
                return new Timestamp96Writer(localZonedTimestampType.getPrecision());
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)t;
                LogicalType elementType = arrayType.getElementType();
                FieldWriter elementWriter = this.createWriter(elementType);
                return new ArrayWriter(elementWriter);
            }
            case MAP: {
                MapType mapType = (MapType)t;
                LogicalType keyType = mapType.getKeyType();
                LogicalType valueType = mapType.getValueType();
                FieldWriter keyWriter = this.createWriter(keyType);
                FieldWriter valueWriter = this.createWriter(valueType);
                return new MapWriter(keyWriter, valueWriter);
            }
            case ROW: {
                RowType rowType = (RowType)t;
                FieldWriter[] fieldWriters = (FieldWriter[])rowType.getFields().stream().map(RowType.RowField::getType).map(this::createWriter).toArray(FieldWriter[]::new);
                String[] fieldNames = (String[])rowType.getFields().stream().map(RowType.RowField::getName).toArray(String[]::new);
                return new RowWriter(fieldNames, fieldWriters);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + t);
    }

    private long timestampToInt64(TimestampData timestampData) {
        return this.utcTimestamp ? timestampData.getMillisecond() : timestampData.toTimestamp().getTime();
    }

    private Binary timestampToInt96(TimestampData timestampData) {
        long nanosOfDay;
        int julianDay;
        if (this.utcTimestamp) {
            long mills = timestampData.getMillisecond();
            julianDay = (int)(mills / TimestampColumnReader.MILLIS_IN_DAY + 2440588L);
            nanosOfDay = mills % TimestampColumnReader.MILLIS_IN_DAY * TimestampColumnReader.NANOS_PER_MILLISECOND + (long)timestampData.getNanoOfMillisecond();
        } else {
            Timestamp timestamp = timestampData.toTimestamp();
            long mills = timestamp.getTime();
            julianDay = (int)(mills / TimestampColumnReader.MILLIS_IN_DAY + 2440588L);
            nanosOfDay = mills % TimestampColumnReader.MILLIS_IN_DAY / 1000L * TimestampColumnReader.NANOS_PER_SECOND + (long)timestamp.getNanos();
        }
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(nanosOfDay);
        buf.putInt(julianDay);
        buf.flip();
        return Binary.fromConstantByteBuffer((ByteBuffer)buf);
    }

    private FieldWriter createDecimalWriter(final int precision, final int scale) {
        Preconditions.checkArgument(precision <= 38, "Decimal precision %s exceeds max precision %s", precision, 38);
        if (DecimalDataUtils.is32BitDecimal((int)precision) || DecimalDataUtils.is64BitDecimal((int)precision)) {
            class LongUnscaledBytesWriter
            implements FieldWriter {
                private final int numBytes;
                private final int initShift;
                private final byte[] decimalBuffer;

                LongUnscaledBytesWriter() {
                    this.numBytes = ParquetSchemaConverter.computeMinBytesForDecimalPrecision((int)precision);
                    this.initShift = 8 * (this.numBytes - 1);
                    this.decimalBuffer = new byte[this.numBytes];
                }

                @Override
                public void write(RowData row, int ordinal) {
                    long unscaledLong = row.getDecimal(ordinal, precision, scale).toUnscaledLong();
                    this.doWrite(unscaledLong);
                }

                @Override
                public void write(ArrayData array, int ordinal) {
                    long unscaledLong = array.getDecimal(ordinal, precision, scale).toUnscaledLong();
                    this.doWrite(unscaledLong);
                }

                private void doWrite(long unscaled) {
                    int i = 0;
                    int shift = this.initShift;
                    while (i < this.numBytes) {
                        this.decimalBuffer[i] = (byte)(unscaled >> shift);
                        ++i;
                        shift -= 8;
                    }
                    ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])this.decimalBuffer, (int)0, (int)this.numBytes));
                }
            }
            return new LongUnscaledBytesWriter();
        }
        class UnscaledBytesWriter
        implements FieldWriter {
            private final int numBytes;
            private final byte[] decimalBuffer;

            UnscaledBytesWriter() {
                this.numBytes = ParquetSchemaConverter.computeMinBytesForDecimalPrecision((int)precision);
                this.decimalBuffer = new byte[this.numBytes];
            }

            @Override
            public void write(RowData row, int ordinal) {
                byte[] bytes = row.getDecimal(ordinal, precision, scale).toUnscaledBytes();
                this.doWrite(bytes);
            }

            @Override
            public void write(ArrayData array, int ordinal) {
                byte[] bytes = array.getDecimal(ordinal, precision, scale).toUnscaledBytes();
                this.doWrite(bytes);
            }

            private void doWrite(byte[] bytes) {
                byte[] writtenBytes;
                if (bytes.length == this.numBytes) {
                    writtenBytes = bytes;
                } else {
                    byte signByte = bytes[0] < 0 ? (byte)-1 : 0;
                    Arrays.fill(this.decimalBuffer, 0, this.numBytes - bytes.length, signByte);
                    System.arraycopy(bytes, 0, this.decimalBuffer, this.numBytes - bytes.length, bytes.length);
                    writtenBytes = this.decimalBuffer;
                }
                ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])writtenBytes, (int)0, (int)this.numBytes));
            }
        }
        return new UnscaledBytesWriter();
    }

    private class RowWriter
    implements FieldWriter {
        private final String[] fieldNames;
        private final FieldWriter[] fieldWriters;

        private RowWriter(String[] fieldNames, FieldWriter[] fieldWriters) {
            this.fieldNames = fieldNames;
            this.fieldWriters = fieldWriters;
        }

        @Override
        public void write(RowData row, int ordinal) {
            RowData nested = row.getRow(ordinal, this.fieldWriters.length);
            this.doWrite(nested);
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            RowData nested = array.getRow(ordinal, this.fieldWriters.length);
            this.doWrite(nested);
        }

        private void doWrite(RowData row) {
            ParquetRowDataWriter.this.recordConsumer.startGroup();
            for (int i = 0; i < row.getArity(); ++i) {
                if (row.isNullAt(i)) continue;
                String fieldName = this.fieldNames[i];
                ParquetRowDataWriter.this.recordConsumer.startField(fieldName, i);
                this.fieldWriters[i].write(row, i);
                ParquetRowDataWriter.this.recordConsumer.endField(fieldName, i);
            }
            ParquetRowDataWriter.this.recordConsumer.endGroup();
        }
    }

    private class MapWriter
    implements FieldWriter {
        private final FieldWriter keyWriter;
        private final FieldWriter valueWriter;

        private MapWriter(FieldWriter keyWriter, FieldWriter valueWriter) {
            this.keyWriter = keyWriter;
            this.valueWriter = valueWriter;
        }

        @Override
        public void write(RowData row, int ordinal) {
            MapData map = row.getMap(ordinal);
            this.doWrite(map);
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            MapData map = array.getMap(ordinal);
            this.doWrite(map);
        }

        private void doWrite(MapData mapData) {
            ArrayData keyArray = mapData.keyArray();
            ArrayData valueArray = mapData.valueArray();
            ParquetRowDataWriter.this.recordConsumer.startGroup();
            if (mapData.size() > 0) {
                String repeatedGroup = "key_value";
                String kField = "key";
                String vField = "value";
                ParquetRowDataWriter.this.recordConsumer.startField("key_value", 0);
                for (int i = 0; i < mapData.size(); ++i) {
                    ParquetRowDataWriter.this.recordConsumer.startGroup();
                    ParquetRowDataWriter.this.recordConsumer.startField("key", 0);
                    this.keyWriter.write(keyArray, i);
                    ParquetRowDataWriter.this.recordConsumer.endField("key", 0);
                    if (!valueArray.isNullAt(i)) {
                        ParquetRowDataWriter.this.recordConsumer.startField("value", 1);
                        this.valueWriter.write(valueArray, i);
                        ParquetRowDataWriter.this.recordConsumer.endField("value", 1);
                    }
                    ParquetRowDataWriter.this.recordConsumer.endGroup();
                }
                ParquetRowDataWriter.this.recordConsumer.endField("key_value", 0);
            }
            ParquetRowDataWriter.this.recordConsumer.endGroup();
        }
    }

    private class ArrayWriter
    implements FieldWriter {
        private final FieldWriter elementWriter;

        private ArrayWriter(FieldWriter elementWriter) {
            this.elementWriter = elementWriter;
        }

        @Override
        public void write(RowData row, int ordinal) {
            ArrayData arrayData = row.getArray(ordinal);
            this.doWrite(arrayData);
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ArrayData arrayData = array.getArray(ordinal);
            this.doWrite(arrayData);
        }

        private void doWrite(ArrayData arrayData) {
            ParquetRowDataWriter.this.recordConsumer.startGroup();
            if (arrayData.size() > 0) {
                String repeatedGroup = "list";
                String elementField = "element";
                ParquetRowDataWriter.this.recordConsumer.startField("list", 0);
                for (int i = 0; i < arrayData.size(); ++i) {
                    ParquetRowDataWriter.this.recordConsumer.startGroup();
                    if (!arrayData.isNullAt(i)) {
                        ParquetRowDataWriter.this.recordConsumer.startField("element", 0);
                        this.elementWriter.write(arrayData, i);
                        ParquetRowDataWriter.this.recordConsumer.endField("element", 0);
                    }
                    ParquetRowDataWriter.this.recordConsumer.endGroup();
                }
                ParquetRowDataWriter.this.recordConsumer.endField("list", 0);
            }
            ParquetRowDataWriter.this.recordConsumer.endGroup();
        }
    }

    private class Timestamp96Writer
    implements FieldWriter {
        private final int precision;

        private Timestamp96Writer(int precision) {
            this.precision = precision;
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(ParquetRowDataWriter.this.timestampToInt96(row.getTimestamp(ordinal, this.precision)));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(ParquetRowDataWriter.this.timestampToInt96(array.getTimestamp(ordinal, this.precision)));
        }
    }

    private class Timestamp64Writer
    implements FieldWriter {
        private Timestamp64Writer() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addLong(ParquetRowDataWriter.this.timestampToInt64(row.getTimestamp(ordinal, 3)));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addLong(ParquetRowDataWriter.this.timestampToInt64(array.getTimestamp(ordinal, 3)));
        }
    }

    private class IntWriter
    implements FieldWriter {
        private IntWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addInteger(row.getInt(ordinal));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addInteger(array.getInt(ordinal));
        }
    }

    private class BinaryWriter
    implements FieldWriter {
        private BinaryWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])array.getBinary(ordinal)));
        }
    }

    private class StringWriter
    implements FieldWriter {
        private StringWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])row.getString(ordinal).toBytes()));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])array.getString(ordinal).toBytes()));
        }
    }

    private class DoubleWriter
    implements FieldWriter {
        private DoubleWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addDouble(row.getDouble(ordinal));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addDouble(array.getDouble(ordinal));
        }
    }

    private class FloatWriter
    implements FieldWriter {
        private FloatWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addFloat(row.getFloat(ordinal));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addFloat(array.getFloat(ordinal));
        }
    }

    private class LongWriter
    implements FieldWriter {
        private LongWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addLong(row.getLong(ordinal));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addLong(array.getLong(ordinal));
        }
    }

    private class ShortWriter
    implements FieldWriter {
        private ShortWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addInteger((int)row.getShort(ordinal));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addInteger((int)array.getShort(ordinal));
        }
    }

    private class ByteWriter
    implements FieldWriter {
        private ByteWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addInteger((int)row.getByte(ordinal));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addInteger((int)array.getByte(ordinal));
        }
    }

    private class BooleanWriter
    implements FieldWriter {
        private BooleanWriter() {
        }

        @Override
        public void write(RowData row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBoolean(row.getBoolean(ordinal));
        }

        @Override
        public void write(ArrayData array, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.addBoolean(array.getBoolean(ordinal));
        }
    }

    private static interface FieldWriter {
        public void write(RowData var1, int var2);

        public void write(ArrayData var1, int var2);
    }
}

