/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row.parquet;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetSchemaConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParquetSchemaConverter.class);
    public static final String MAP_VALUE = "value";
    public static final String LIST_ARRAY_TYPE = "array";
    public static final String LIST_ELEMENT = "element";
    public static final String LIST_GROUP_NAME = "list";
    public static final String MESSAGE_ROOT = "root";

    public static TypeInformation<?> fromParquetType(MessageType type) {
        return ParquetSchemaConverter.convertFields(type.getFields());
    }

    public static MessageType toParquetType(TypeInformation<?> typeInformation, boolean legacyMode) {
        return (MessageType)ParquetSchemaConverter.convertField(null, typeInformation, Type.Repetition.OPTIONAL, legacyMode);
    }

    public static TypeInformation<?> convertFields(List<Type> parquetFields) {
        ArrayList types = new ArrayList();
        ArrayList<String> names = new ArrayList<String>();
        for (Type field2 : parquetFields) {
            TypeInformation<?> subType = ParquetSchemaConverter.convertParquetTypeToTypeInfo(field2);
            if (subType != null) {
                types.add(subType);
                names.add(field2.getName());
                continue;
            }
            LOGGER.error("Parquet field {} in schema type {} can not be converted to Flink Internal Type", (Object)field2.getName(), (Object)field2.getOriginalType().name());
        }
        return new RowTypeInfo(types.toArray(new TypeInformation[0]), names.toArray(new String[0]));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeInformation<?> convertParquetTypeToTypeInfo(Type fieldType) {
        void var1_32;
        if (fieldType.isPrimitive()) {
            OriginalType originalType = fieldType.getOriginalType();
            PrimitiveType primitiveType = fieldType.asPrimitiveType();
            switch (primitiveType.getPrimitiveTypeName()) {
                case BINARY: {
                    if (originalType != null) {
                        switch (originalType) {
                            case DECIMAL: {
                                BasicTypeInfo<BigDecimal> basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
                                return var1_32;
                            }
                            case UTF8: 
                            case ENUM: 
                            case JSON: 
                            case BSON: {
                                BasicTypeInfo<String> basicTypeInfo = BasicTypeInfo.STRING_TYPE_INFO;
                                return var1_32;
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type BINARY");
                    }
                    BasicTypeInfo<String> basicTypeInfo = BasicTypeInfo.STRING_TYPE_INFO;
                    return var1_32;
                }
                case BOOLEAN: {
                    BasicTypeInfo<Boolean> basicTypeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
                    return var1_32;
                }
                case INT32: {
                    if (originalType != null) {
                        switch (originalType) {
                            case TIME_MICROS: 
                            case TIME_MILLIS: {
                                SqlTimeTypeInfo<Time> sqlTimeTypeInfo = SqlTimeTypeInfo.TIME;
                                return var1_32;
                            }
                            case TIMESTAMP_MICROS: 
                            case TIMESTAMP_MILLIS: {
                                SqlTimeTypeInfo<Timestamp> sqlTimeTypeInfo = SqlTimeTypeInfo.TIMESTAMP;
                                return var1_32;
                            }
                            case DATE: {
                                SqlTimeTypeInfo<Date> sqlTimeTypeInfo = SqlTimeTypeInfo.DATE;
                                return var1_32;
                            }
                            case UINT_8: 
                            case UINT_16: 
                            case UINT_32: {
                                BasicTypeInfo<Integer> basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                                return var1_32;
                            }
                            case INT_8: {
                                TypeInformation<Byte> typeInformation = Types.BYTE;
                                return var1_32;
                            }
                            case INT_16: {
                                TypeInformation<Short> typeInformation = Types.SHORT;
                                return var1_32;
                            }
                            case INT_32: {
                                BasicTypeInfo<Integer> basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                                return var1_32;
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type INT32");
                    }
                    BasicTypeInfo<Integer> basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                    return var1_32;
                }
                case INT64: {
                    if (originalType != null) {
                        switch (originalType) {
                            case TIME_MICROS: {
                                SqlTimeTypeInfo<Time> sqlTimeTypeInfo = SqlTimeTypeInfo.TIME;
                                return var1_32;
                            }
                            case TIMESTAMP_MICROS: 
                            case TIMESTAMP_MILLIS: {
                                SqlTimeTypeInfo<Timestamp> sqlTimeTypeInfo = SqlTimeTypeInfo.TIMESTAMP;
                                return var1_32;
                            }
                            case DECIMAL: 
                            case INT_64: {
                                BasicTypeInfo<Long> basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                                return var1_32;
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type INT64");
                    }
                    BasicTypeInfo<Long> basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                    return var1_32;
                }
                case INT96: {
                    SqlTimeTypeInfo<Timestamp> sqlTimeTypeInfo = SqlTimeTypeInfo.TIMESTAMP;
                    return var1_32;
                }
                case FLOAT: {
                    BasicTypeInfo<Float> basicTypeInfo = BasicTypeInfo.FLOAT_TYPE_INFO;
                    return var1_32;
                }
                case DOUBLE: {
                    BasicTypeInfo<Double> basicTypeInfo = BasicTypeInfo.DOUBLE_TYPE_INFO;
                    return var1_32;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    if (originalType != null) {
                        switch (originalType) {
                            case DECIMAL: {
                                BasicTypeInfo<BigDecimal> basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
                                return var1_32;
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type FIXED_LEN_BYTE_ARRAY");
                    }
                    BasicTypeInfo<BigDecimal> basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
                    return var1_32;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported schema: " + fieldType);
                }
            }
        } else {
            GroupType parquetGroupType = fieldType.asGroupType();
            OriginalType originalType = parquetGroupType.getOriginalType();
            if (originalType == null) return ParquetSchemaConverter.convertFields(parquetGroupType.getFields());
            switch (originalType) {
                case LIST: {
                    if (parquetGroupType.getFieldCount() != 1) {
                        throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                    }
                    Type repeatedType = parquetGroupType.getType(0);
                    if (!repeatedType.isRepetition(Type.Repetition.REPEATED)) {
                        throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                    }
                    if (repeatedType.isPrimitive()) {
                        TypeInformation<?> typeInformation = ParquetSchemaConverter.convertParquetPrimitiveListToFlinkArray(repeatedType);
                        return var1_32;
                    }
                    GroupType elementType = repeatedType.asGroupType();
                    if (elementType.getFieldCount() > 1) {
                        for (Type type : elementType.getFields()) {
                            if (type.isRepetition(Type.Repetition.REQUIRED)) continue;
                            throw new UnsupportedOperationException(String.format("List field [%s] in List [%s] has to be required. ", type.toString(), fieldType.getName()));
                        }
                        ObjectArrayTypeInfo objectArrayTypeInfo = ObjectArrayTypeInfo.getInfoFor(ParquetSchemaConverter.convertParquetTypeToTypeInfo((Type)elementType));
                        return var1_32;
                    }
                    Type internalType = elementType.getType(0);
                    if (internalType.isPrimitive()) {
                        TypeInformation<?> typeInformation = ParquetSchemaConverter.convertParquetPrimitiveListToFlinkArray(internalType);
                        return var1_32;
                    }
                    GroupType tupleGroup = internalType.asGroupType();
                    if (tupleGroup.getFieldCount() != 1 || !((Type)tupleGroup.getFields().get(0)).isRepetition(Type.Repetition.REQUIRED)) throw new UnsupportedOperationException(String.format("Unrecgonized List schema [%s] according to Parquet standard", parquetGroupType.toString()));
                    ObjectArrayTypeInfo objectArrayTypeInfo = ObjectArrayTypeInfo.getInfoFor(ParquetSchemaConverter.convertParquetTypeToTypeInfo(internalType));
                    return var1_32;
                }
                case MAP_KEY_VALUE: 
                case MAP: {
                    if (parquetGroupType.getFieldCount() != 1 || parquetGroupType.getType(0).isPrimitive()) {
                        throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                    }
                    GroupType mapKeyValType = parquetGroupType.getType(0).asGroupType();
                    if (!mapKeyValType.isRepetition(Type.Repetition.REPEATED) || mapKeyValType.getFieldCount() != 2) {
                        throw new UnsupportedOperationException("The middle level of Map should be single field named key_value. Invalid map type " + parquetGroupType);
                    }
                    Type keyType = mapKeyValType.getType(0);
                    if (!(keyType.isPrimitive() && keyType.isRepetition(Type.Repetition.REQUIRED) && keyType.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY) && keyType.getOriginalType().equals((Object)OriginalType.UTF8))) {
                        throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                    }
                    Type valueType = mapKeyValType.getType(1);
                    return new MapTypeInfo(BasicTypeInfo.STRING_TYPE_INFO, ParquetSchemaConverter.convertParquetTypeToTypeInfo(valueType));
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported schema: " + fieldType);
                }
            }
        }
    }

    private static TypeInformation<?> convertParquetPrimitiveListToFlinkArray(Type type) {
        TypeInformation<?> flinkType = ParquetSchemaConverter.convertParquetTypeToTypeInfo(type);
        if (flinkType.isBasicType()) {
            return BasicArrayTypeInfo.getInfoFor(Array.newInstance(flinkType.getTypeClass(), 0).getClass());
        }
        return ObjectArrayTypeInfo.getInfoFor(flinkType);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Type convertField(String fieldName, TypeInformation<?> typeInfo, Type.Repetition inheritRepetition, boolean legacyMode) {
        void var4_26;
        Type.Repetition repetition;
        Object var4_4 = null;
        Type.Repetition repetition2 = repetition = inheritRepetition == null ? Type.Repetition.OPTIONAL : inheritRepetition;
        if (typeInfo instanceof BasicTypeInfo) {
            BasicTypeInfo basicTypeInfo = (BasicTypeInfo)typeInfo;
            if (basicTypeInfo.equals(BasicTypeInfo.BIG_DEC_TYPE_INFO) || basicTypeInfo.equals(BasicTypeInfo.BIG_INT_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals(BasicTypeInfo.INT_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_32)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals(BasicTypeInfo.DOUBLE_TYPE_INFO)) {
                Type type = (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals(BasicTypeInfo.FLOAT_TYPE_INFO)) {
                Type type = (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals(BasicTypeInfo.LONG_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.INT_64)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals(BasicTypeInfo.SHORT_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals(BasicTypeInfo.BYTE_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals(BasicTypeInfo.CHAR_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals(BasicTypeInfo.BOOLEAN_TYPE_INFO)) {
                Type type = (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(fieldName);
                return var4_26;
            } else {
                if (!basicTypeInfo.equals(BasicTypeInfo.DATE_TYPE_INFO) && !basicTypeInfo.equals(BasicTypeInfo.STRING_TYPE_INFO)) return var4_26;
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(fieldName);
            }
            return var4_26;
        } else if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            if (!mapTypeInfo.getKeyTypeInfo().equals(BasicTypeInfo.STRING_TYPE_INFO)) throw new UnsupportedOperationException(String.format("Can not convert Flink MapTypeInfo %s to Parquet Map type as key has to be String", typeInfo));
            Type type = (Type)((Types.MapBuilder)org.apache.parquet.schema.Types.map((Type.Repetition)repetition).value(ParquetSchemaConverter.convertField(MAP_VALUE, mapTypeInfo.getValueTypeInfo(), Type.Repetition.OPTIONAL, legacyMode))).named(fieldName);
            return var4_26;
        } else if (typeInfo instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)typeInfo;
            GroupType componentGroup = (GroupType)ParquetSchemaConverter.convertField(LIST_ELEMENT, objectArrayTypeInfo.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode);
            GroupType elementGroup = (GroupType)org.apache.parquet.schema.Types.repeatedGroup().named(LIST_ELEMENT);
            elementGroup = elementGroup.withNewFields(componentGroup.getFields());
            Type type = (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup((Type.Repetition)repetition).addField((Type)elementGroup)).as(OriginalType.LIST)).named(fieldName);
            return var4_26;
        } else if (typeInfo instanceof BasicArrayTypeInfo) {
            BasicArrayTypeInfo basicArrayType = (BasicArrayTypeInfo)typeInfo;
            if (legacyMode) {
                Type listGroup = (Type)((Types.GroupBuilder)org.apache.parquet.schema.Types.repeatedGroup().addField(ParquetSchemaConverter.convertField(LIST_ELEMENT, basicArrayType.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode))).named(LIST_GROUP_NAME);
                Type type = (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup((Type.Repetition)repetition).addField(listGroup)).as(OriginalType.LIST)).named(fieldName);
                return var4_26;
            } else {
                PrimitiveType primitiveTyp = ParquetSchemaConverter.convertField(fieldName, basicArrayType.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode).asPrimitiveType();
                Type type = (Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.buildGroup((Type.Repetition)repetition).repeated(primitiveTyp.getPrimitiveTypeName()).as(primitiveTyp.getOriginalType())).named(LIST_ARRAY_TYPE)).as(OriginalType.LIST)).named(fieldName);
            }
            return var4_26;
        } else if (typeInfo instanceof SqlTimeTypeInfo) {
            if (typeInfo.equals(SqlTimeTypeInfo.DATE)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE)).named(fieldName);
                return var4_26;
            } else if (typeInfo.equals(SqlTimeTypeInfo.TIME)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.TIME_MILLIS)).named(fieldName);
                return var4_26;
            } else {
                if (!typeInfo.equals(SqlTimeTypeInfo.TIMESTAMP)) throw new UnsupportedOperationException("Unsupported SqlTimeTypeInfo " + typeInfo.toString());
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.TIMESTAMP_MILLIS)).named(fieldName);
            }
            return var4_26;
        } else {
            RowTypeInfo rowTypeInfo = (RowTypeInfo)typeInfo;
            ArrayList<Type> types = new ArrayList<Type>();
            String[] fieldNames = rowTypeInfo.getFieldNames();
            TypeInformation<?>[] fieldTypes = rowTypeInfo.getFieldTypes();
            for (int i = 0; i < rowTypeInfo.getArity(); ++i) {
                types.add(ParquetSchemaConverter.convertField(fieldNames[i], fieldTypes[i], repetition, legacyMode));
            }
            if (fieldName == null) {
                MessageType messageType = new MessageType(MESSAGE_ROOT, types);
                return var4_26;
            } else {
                GroupType groupType = new GroupType(repetition, fieldName, types);
            }
        }
        return var4_26;
    }

    public static MessageType convertToParquetMessageType(String name, RowType rowType) {
        Type[] types = new Type[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            types[i] = ParquetSchemaConverter.convertToParquetType((String)rowType.getFieldNames().get(i), rowType.getTypeAt(i));
        }
        return new MessageType(name, types);
    }

    private static Type convertToParquetType(String name, LogicalType type) {
        return ParquetSchemaConverter.convertToParquetType(name, type, Type.Repetition.OPTIONAL);
    }

    private static Type convertToParquetType(String name, LogicalType type, Type.Repetition repetition) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(name);
            }
            case BOOLEAN: {
                return (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
            }
            case BINARY: 
            case VARBINARY: {
                return (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(name);
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                int numBytes = ParquetSchemaConverter.computeMinBytesForDecimalPrecision(precision);
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(numBytes)).named(name);
            }
            case TINYINT: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true))).named(name);
            }
            case SMALLINT: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true))).named(name);
            }
            case INTEGER: {
                return (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
            }
            case BIGINT: {
                return (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
            }
            case FLOAT: {
                return (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
            }
            case DOUBLE: {
                return (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
            }
            case DATE: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(name);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(name);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                if (timestampType.getPrecision() == 3) {
                    return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(name);
                }
                return (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(name);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)type;
                if (localZonedTimestampType.getPrecision() == 3) {
                    return (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(name);
                }
                return (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(name);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                LogicalType elementType = arrayType.getElementType();
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField((Type)((Types.GroupBuilder)org.apache.parquet.schema.Types.repeatedGroup().addField(ParquetSchemaConverter.convertToParquetType(LIST_ELEMENT, elementType, repetition))).named(LIST_GROUP_NAME))).named(name);
            }
            case MAP: {
                MapType mapType = (MapType)type;
                LogicalType keyType = mapType.getKeyType();
                LogicalType valueType = mapType.getValueType();
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup((Type.Repetition)repetition).as(OriginalType.MAP)).addField((Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.repeatedGroup().addField(ParquetSchemaConverter.convertToParquetType("key", keyType, repetition))).addField(ParquetSchemaConverter.convertToParquetType(MAP_VALUE, valueType, repetition))).named("key_value"))).named(name);
            }
            case ROW: {
                RowType rowType = (RowType)type;
                Types.GroupBuilder builder = org.apache.parquet.schema.Types.buildGroup((Type.Repetition)repetition);
                rowType.getFields().forEach(field2 -> {
                    Types.GroupBuilder cfr_ignored_0 = (Types.GroupBuilder)builder.addField(ParquetSchemaConverter.convertToParquetType(field2.getName(), field2.getType(), repetition));
                });
                return (Type)builder.named(name);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    public static int computeMinBytesForDecimalPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }
}

