/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.client.HoodieInternalWriteStatus;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.storage.row.HoodieRowDataCreateHandle;
import org.apache.hudi.sink.bulk.RowDataKeyGen;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BulkInsertWriterHelper {
    private static final Logger LOG = LogManager.getLogger(BulkInsertWriterHelper.class);
    protected final String instantTime;
    protected final int taskPartitionId;
    protected final long taskId;
    protected final long taskEpochId;
    protected final HoodieTable hoodieTable;
    protected final HoodieWriteConfig writeConfig;
    protected final RowType rowType;
    protected final boolean preserveHoodieMetadata;
    protected final Boolean isInputSorted;
    private final List<HoodieInternalWriteStatus> writeStatusList = new ArrayList<HoodieInternalWriteStatus>();
    protected HoodieRowDataCreateHandle handle;
    private String lastKnownPartitionPath = null;
    private final String fileIdPrefix;
    private int numFilesWritten = 0;
    protected final Map<String, HoodieRowDataCreateHandle> handles = new HashMap<String, HoodieRowDataCreateHandle>();
    @Nullable
    protected final RowDataKeyGen keyGen;

    public BulkInsertWriterHelper(Configuration conf, HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, RowType rowType) {
        this(conf, hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, taskEpochId, rowType, false);
    }

    public BulkInsertWriterHelper(Configuration conf, HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, RowType rowType, boolean preserveHoodieMetadata) {
        this.hoodieTable = hoodieTable;
        this.writeConfig = writeConfig;
        this.instantTime = instantTime;
        this.taskPartitionId = taskPartitionId;
        this.taskId = taskId;
        this.taskEpochId = taskEpochId;
        this.rowType = preserveHoodieMetadata ? rowType : BulkInsertWriterHelper.addMetadataFields(rowType, writeConfig.allowOperationMetadataField());
        this.preserveHoodieMetadata = preserveHoodieMetadata;
        this.isInputSorted = conf.getBoolean(FlinkOptions.WRITE_BULK_INSERT_SORT_INPUT);
        this.fileIdPrefix = UUID.randomUUID().toString();
        this.keyGen = preserveHoodieMetadata ? null : RowDataKeyGen.instance(conf, rowType);
    }

    public String getInstantTime() {
        return this.instantTime;
    }

    public void write(RowData record) throws IOException {
        try {
            String partitionPath;
            String recordKey = this.preserveHoodieMetadata ? record.getString(HoodieRecord.RECORD_KEY_META_FIELD_ORD).toString() : this.keyGen.getRecordKey(record);
            String string = partitionPath = this.preserveHoodieMetadata ? record.getString(HoodieRecord.PARTITION_PATH_META_FIELD_ORD).toString() : this.keyGen.getPartitionPath(record);
            if (this.lastKnownPartitionPath == null || !this.lastKnownPartitionPath.equals(partitionPath) || !this.handle.canWrite()) {
                LOG.info((Object)("Creating new file for partition path " + partitionPath));
                this.handle = this.getRowCreateHandle(partitionPath);
                this.lastKnownPartitionPath = partitionPath;
            }
            this.handle.write(recordKey, partitionPath, record);
        }
        catch (Throwable t) {
            IOException ioException = new IOException("Exception happened when bulk insert.", t);
            LOG.error((Object)"Global error thrown while trying to write records in HoodieRowCreateHandle ", (Throwable)ioException);
            throw new IOException(ioException);
        }
    }

    public List<HoodieInternalWriteStatus> getHoodieWriteStatuses() throws IOException {
        this.close();
        return this.writeStatusList;
    }

    private HoodieRowDataCreateHandle getRowCreateHandle(String partitionPath) throws IOException {
        if (!this.handles.containsKey(partitionPath)) {
            if (this.isInputSorted.booleanValue()) {
                this.close();
            }
            HoodieRowDataCreateHandle rowCreateHandle = new HoodieRowDataCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, this.getNextFileId(), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.rowType, this.preserveHoodieMetadata);
            this.handles.put(partitionPath, rowCreateHandle);
        } else if (!this.handles.get(partitionPath).canWrite()) {
            this.writeStatusList.add(this.handles.remove(partitionPath).close());
            HoodieRowDataCreateHandle rowCreateHandle = new HoodieRowDataCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, this.getNextFileId(), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.rowType, this.preserveHoodieMetadata);
            this.handles.put(partitionPath, rowCreateHandle);
        }
        return this.handles.get(partitionPath);
    }

    public void close() throws IOException {
        for (HoodieRowDataCreateHandle rowCreateHandle : this.handles.values()) {
            this.writeStatusList.add(rowCreateHandle.close());
        }
        this.handles.clear();
        this.handle = null;
    }

    private String getNextFileId() {
        return String.format("%s-%d", this.fileIdPrefix, this.numFilesWritten++);
    }

    public static RowType addMetadataFields(RowType rowType, boolean withOperationField) {
        ArrayList<RowType.RowField> mergedFields = new ArrayList<RowType.RowField>();
        LogicalType metadataFieldType = DataTypes.STRING().getLogicalType();
        RowType.RowField commitTimeField = new RowType.RowField("_hoodie_commit_time", metadataFieldType, "commit time");
        RowType.RowField commitSeqnoField = new RowType.RowField("_hoodie_commit_seqno", metadataFieldType, "commit seqno");
        RowType.RowField recordKeyField = new RowType.RowField("_hoodie_record_key", metadataFieldType, "record key");
        RowType.RowField partitionPathField = new RowType.RowField("_hoodie_partition_path", metadataFieldType, "partition path");
        RowType.RowField fileNameField = new RowType.RowField("_hoodie_file_name", metadataFieldType, "field name");
        mergedFields.add(commitTimeField);
        mergedFields.add(commitSeqnoField);
        mergedFields.add(recordKeyField);
        mergedFields.add(partitionPathField);
        mergedFields.add(fileNameField);
        if (withOperationField) {
            RowType.RowField operationField = new RowType.RowField("_hoodie_operation", metadataFieldType, "operation");
            mergedFields.add(operationField);
        }
        mergedFields.addAll(rowType.getFields());
        return new RowType(false, mergedFields);
    }

    public List<WriteStatus> getWriteStatuses(int taskID) {
        try {
            return this.getHoodieWriteStatuses().stream().map(BulkInsertWriterHelper::toWriteStatus).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new HoodieException("Error collect the write status for task [" + taskID + "]", e);
        }
    }

    private static WriteStatus toWriteStatus(HoodieInternalWriteStatus internalWriteStatus) {
        WriteStatus writeStatus = new WriteStatus(false, 0.1);
        writeStatus.setStat(internalWriteStatus.getStat());
        writeStatus.setFileId(internalWriteStatus.getFileId());
        writeStatus.setGlobalError(internalWriteStatus.getGlobalError());
        writeStatus.setTotalRecords(internalWriteStatus.getTotalRecords());
        writeStatus.setTotalErrorRecords(internalWriteStatus.getTotalErrorRecords());
        return writeStatus;
    }
}

