/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.compact;

import io.hops.hudi.com.beust.jcommander.Parameter;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.config.HoodieMemoryConfig;
import org.apache.hudi.configuration.FlinkOptions;

public class FlinkCompactionConfig
extends Configuration {
    @Parameter(names={"--help", "-h"}, help=true)
    public Boolean help = false;
    @Parameter(names={"--path"}, description="Base path for the target hoodie table.", required=true)
    public String path;
    public static final String NUM_COMMITS = "num_commits";
    public static final String TIME_ELAPSED = "time_elapsed";
    public static final String NUM_AND_TIME = "num_and_time";
    public static final String NUM_OR_TIME = "num_or_time";
    @Parameter(names={"--compaction-trigger-strategy"}, description="Strategy to trigger compaction, options are 'num_commits': trigger compaction when reach N delta commits;\n'time_elapsed': trigger compaction when time elapsed > N seconds since last compaction;\n'num_and_time': trigger compaction when both NUM_COMMITS and TIME_ELAPSED are satisfied;\n'num_or_time': trigger compaction when NUM_COMMITS or TIME_ELAPSED is satisfied.\nDefault is 'num_commits'", required=false)
    public String compactionTriggerStrategy = "num_commits";
    @Parameter(names={"--compaction-delta-commits"}, description="Max delta commits needed to trigger compaction, default 5 commits", required=false)
    public Integer compactionDeltaCommits = 1;
    @Parameter(names={"--compaction-delta-seconds"}, description="Max delta seconds time needed to trigger compaction, default 1 hour", required=false)
    public Integer compactionDeltaSeconds = 3600;
    @Parameter(names={"--clean-async-enabled"}, description="Whether to cleanup the old commits immediately on new commits, enabled by default", required=false)
    public Boolean cleanAsyncEnable = false;
    @Parameter(names={"--clean-retain-commits"}, description="Number of commits to retain. So data will be retained for num_of_commits * time_between_commits (scheduled).\nThis also directly translates into how much you can incrementally pull on this table, default 10", required=false)
    public Integer cleanRetainCommits = 10;
    @Parameter(names={"--archive-min-commits"}, description="Min number of commits to keep before archiving older commits into a sequential log, default 20.", required=false)
    public Integer archiveMinCommits = 20;
    @Parameter(names={"--archive-max-commits"}, description="Max number of commits to keep before archiving older commits into a sequential log, default 30.", required=false)
    public Integer archiveMaxCommits = 30;
    @Parameter(names={"--compaction-max-memory"}, description="Max memory in MB for compaction spillable map, default 100MB.", required=false)
    public Integer compactionMaxMemory = 100;
    @Parameter(names={"--compaction-target-io"}, description="Target IO per compaction (both read and write) for batching compaction, default 512000M.", required=false)
    public Long compactionTargetIo = 512000L;
    @Parameter(names={"--compaction-tasks"}, description="Parallelism of tasks that do actual compaction, default is -1", required=false)
    public Integer compactionTasks = -1;
    @Parameter(names={"--schedule", "-sc"}, description="Not recommended. Schedule the compaction plan in this job.\nThere is a risk of losing data when scheduling compaction outside the writer job.\nScheduling compaction in the writer job and only let this job do the compaction execution is recommended.\nDefault is false", required=false)
    public Boolean schedule = false;
    public static final String SEQ_FIFO = "FIFO";
    public static final String SEQ_LIFO = "LIFO";
    @Parameter(names={"--seq"}, description="Compaction plan execution sequence, two options are supported:\n1). FIFO: execute the oldest plan first;\n2). LIFO: execute the latest plan first, by default LIFO", required=false)
    public String compactionSeq = "FIFO";
    @Parameter(names={"--service"}, description="Flink Compaction runs in service mode, disable by default")
    public Boolean serviceMode = false;
    @Parameter(names={"--min-compaction-interval-seconds"}, description="Min compaction interval of async compaction service, default 10 minutes")
    public Integer minCompactionIntervalSeconds = 600;
    @Parameter(names={"--plan-select-strategy"}, description="The strategy define how to select compaction plan to compact.\n1). num_instants: select plans by specific number of instants, it's the default strategy with 1 instant at a time;\n3). all: Select all pending compaction plan;\n4). instants: Select the compaction plan by specific instants")
    public String compactionPlanSelectStrategy = "num_instants";
    @Parameter(names={"--max-num-plans"}, description="Max number of compaction plan would be selected in compaction.It's only effective for MultiCompactionPlanSelectStrategy.")
    public Integer maxNumCompactionPlans = 1;
    @Parameter(names={"--target-instants"}, description="Specify the compaction plan instants to compact,\nMultiple instants are supported by comma separated instant time.\nIt's only effective for 'instants' plan selection strategy.")
    public String compactionPlanInstant;
    @Parameter(names={"--spillable_map_path"}, description="Default file path prefix for spillable map.", required=false)
    public String spillableMapPath = HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.defaultValue();

    public static Configuration toFlinkConfig(FlinkCompactionConfig config) {
        Configuration conf = new Configuration();
        conf.setString(FlinkOptions.PATH, config.path);
        conf.setString(FlinkOptions.COMPACTION_TRIGGER_STRATEGY, config.compactionTriggerStrategy);
        conf.setInteger(FlinkOptions.ARCHIVE_MAX_COMMITS, (int)config.archiveMaxCommits);
        conf.setInteger(FlinkOptions.ARCHIVE_MIN_COMMITS, (int)config.archiveMinCommits);
        conf.setInteger(FlinkOptions.CLEAN_RETAIN_COMMITS, (int)config.cleanRetainCommits);
        conf.setInteger(FlinkOptions.COMPACTION_DELTA_COMMITS, (int)config.compactionDeltaCommits);
        conf.setInteger(FlinkOptions.COMPACTION_DELTA_SECONDS, (int)config.compactionDeltaSeconds);
        conf.setInteger(FlinkOptions.COMPACTION_MAX_MEMORY, (int)config.compactionMaxMemory);
        conf.setLong(FlinkOptions.COMPACTION_TARGET_IO, (long)config.compactionTargetIo);
        conf.setInteger(FlinkOptions.COMPACTION_TASKS, (int)config.compactionTasks);
        conf.setBoolean(FlinkOptions.CLEAN_ASYNC_ENABLED, (boolean)config.cleanAsyncEnable);
        conf.setBoolean(FlinkOptions.COMPACTION_ASYNC_ENABLED, false);
        conf.setBoolean(FlinkOptions.COMPACTION_SCHEDULE_ENABLED, (boolean)config.schedule);
        conf.setString(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), config.spillableMapPath);
        return conf;
    }
}

