/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.partitioner;

import org.apache.flink.api.common.functions.Partitioner;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.index.bucket.BucketIdentifier;

public class BucketIndexPartitioner<T extends HoodieKey>
implements Partitioner<T> {
    private final int bucketNum;
    private final String indexKeyFields;

    public BucketIndexPartitioner(int bucketNum, String indexKeyFields) {
        this.bucketNum = bucketNum;
        this.indexKeyFields = indexKeyFields;
    }

    @Override
    public int partition(HoodieKey key, int numPartitions) {
        int curBucket = BucketIdentifier.getBucketId(key, this.indexKeyFields, this.bucketNum);
        int partitionIndex = (key.getPartitionPath().hashCode() & Integer.MAX_VALUE) % numPartitions;
        int globalIndex = partitionIndex + curBucket;
        return BucketIdentifier.mod(globalIndex, numPartitions);
    }
}

