/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.FlinkAppendHandle;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.table.HoodieFlinkCopyOnWriteTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.delta.FlinkUpsertDeltaCommitActionExecutor;
import org.apache.hudi.table.action.commit.delta.FlinkUpsertPreppedDeltaCommitActionExecutor;
import org.apache.hudi.table.action.compact.HoodieFlinkMergeOnReadTableCompactor;
import org.apache.hudi.table.action.compact.RunCompactionActionExecutor;
import org.apache.hudi.table.action.compact.ScheduleCompactionActionExecutor;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.MergeOnReadRollbackActionExecutor;

public class HoodieFlinkMergeOnReadTable<T extends HoodieRecordPayload>
extends HoodieFlinkCopyOnWriteTable<T> {
    HoodieFlinkMergeOnReadTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> upsert(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieRecord<T>> hoodieRecords) {
        ValidationUtils.checkArgument(writeHandle instanceof FlinkAppendHandle, "MOR write handle should always be a FlinkAppendHandle");
        FlinkAppendHandle appendHandle = (FlinkAppendHandle)writeHandle;
        return new FlinkUpsertDeltaCommitActionExecutor<T>(context, appendHandle, this.config, (HoodieTable)this, instantTime, hoodieRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> upsertPrepped(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieRecord<T>> preppedRecords) {
        ValidationUtils.checkArgument(writeHandle instanceof FlinkAppendHandle, "MOR write handle should always be a FlinkAppendHandle");
        FlinkAppendHandle appendHandle = (FlinkAppendHandle)writeHandle;
        return new FlinkUpsertPreppedDeltaCommitActionExecutor<T>(context, appendHandle, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> insert(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, String instantTime, List<HoodieRecord<T>> hoodieRecords) {
        if (writeHandle instanceof FlinkAppendHandle) {
            FlinkAppendHandle appendHandle = (FlinkAppendHandle)writeHandle;
            return new FlinkUpsertDeltaCommitActionExecutor<T>(context, appendHandle, this.config, (HoodieTable)this, instantTime, hoodieRecords).execute();
        }
        return super.insert(context, writeHandle, instantTime, hoodieRecords);
    }

    @Override
    public Option<HoodieCompactionPlan> scheduleCompaction(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        ScheduleCompactionActionExecutor scheduleCompactionExecutor = new ScheduleCompactionActionExecutor(context, this.config, this, instantTime, extraMetadata, new HoodieFlinkMergeOnReadTableCompactor());
        return scheduleCompactionExecutor.execute();
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> compact(HoodieEngineContext context, String compactionInstantTime) {
        RunCompactionActionExecutor compactionExecutor = new RunCompactionActionExecutor(context, this.config, this, compactionInstantTime, new HoodieFlinkMergeOnReadTableCompactor(), new HoodieFlinkCopyOnWriteTable(this.config, context, this.getMetaClient()));
        return HoodieFlinkMergeOnReadTable.convertMetadata((HoodieWriteMetadata<HoodieData<WriteStatus>>)compactionExecutor.execute());
    }

    @Override
    public Option<HoodieRollbackPlan> scheduleRollback(HoodieEngineContext context, String instantTime, HoodieInstant instantToRollback, boolean skipTimelinePublish, boolean shouldRollbackUsingMarkers) {
        return new BaseRollbackPlanActionExecutor(context, this.config, this, instantTime, instantToRollback, skipTimelinePublish, shouldRollbackUsingMarkers).execute();
    }

    @Override
    public HoodieRollbackMetadata rollback(HoodieEngineContext context, String rollbackInstantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipLocking) {
        return new MergeOnReadRollbackActionExecutor(context, this.config, this, rollbackInstantTime, commitInstant, deleteInstants, skipLocking).execute();
    }
}

