/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilter;
import org.apache.hudi.table.action.cluster.strategy.ClusteringPlanStrategy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class PartitionAwareClusteringPlanStrategy<T extends HoodieRecordPayload, I, K, O>
extends ClusteringPlanStrategy<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(PartitionAwareClusteringPlanStrategy.class);

    public PartitionAwareClusteringPlanStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    protected abstract Stream<HoodieClusteringGroup> buildClusteringGroupsForPartition(String var1, List<FileSlice> var2);

    protected List<String> filterPartitionPaths(List<String> partitionPaths) {
        List<String> filteredPartitions = ClusteringPlanPartitionFilter.filter(partitionPaths, this.getWriteConfig());
        LOG.debug((Object)("Filtered to the following partitions: " + filteredPartitions));
        return filteredPartitions;
    }

    @Override
    public Option<HoodieClusteringPlan> generateClusteringPlan() {
        HoodieTableMetaClient metaClient = this.getHoodieTable().getMetaClient();
        LOG.info((Object)("Scheduling clustering for " + metaClient.getBasePath()));
        HoodieWriteConfig config = this.getWriteConfig();
        String partitionSelected = config.getClusteringPartitionSelected();
        List<String> partitionPaths = StringUtils.isNullOrEmpty(partitionSelected) ? this.getRegexPatternMatchedPartitions(config, FSUtils.getAllPartitionPaths(this.getEngineContext(), config.getMetadataConfig(), metaClient.getBasePath())) : Arrays.asList(partitionSelected.split(","));
        partitionPaths = this.filterPartitionPaths(partitionPaths);
        if (partitionPaths.isEmpty()) {
            return Option.empty();
        }
        List<HoodieClusteringGroup> clusteringGroups = this.getEngineContext().flatMap(partitionPaths, partitionPath -> {
            List<FileSlice> fileSlicesEligible = this.getFileSlicesEligibleForClustering((String)partitionPath).collect(Collectors.toList());
            return this.buildClusteringGroupsForPartition((String)partitionPath, fileSlicesEligible).limit(this.getWriteConfig().getClusteringMaxNumGroups());
        }, partitionPaths.size()).stream().limit(this.getWriteConfig().getClusteringMaxNumGroups()).collect(Collectors.toList());
        if (clusteringGroups.isEmpty()) {
            LOG.info((Object)"No data available to cluster");
            return Option.empty();
        }
        HoodieClusteringStrategy strategy = HoodieClusteringStrategy.newBuilder().setStrategyClassName(this.getWriteConfig().getClusteringExecutionStrategyClass()).setStrategyParams(this.getStrategyParams()).build();
        return Option.of(HoodieClusteringPlan.newBuilder().setStrategy(strategy).setInputGroups(clusteringGroups).setExtraMetadata(this.getExtraMetadata()).setVersion(this.getPlanVersion()).setPreserveHoodieMetadata(this.getWriteConfig().isPreserveHoodieCommitMetadataForClustering()).build());
    }

    public List<String> getRegexPatternMatchedPartitions(HoodieWriteConfig config, List<String> partitionPaths) {
        String pattern = config.getClusteringPartitionFilterRegexPattern();
        if (!StringUtils.isNullOrEmpty(pattern)) {
            partitionPaths = partitionPaths.stream().filter(partition -> Pattern.matches(pattern, partition)).collect(Collectors.toList());
        }
        return partitionPaths;
    }
}

