/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.table.catalog.CatalogOptions;
import org.apache.hudi.table.catalog.TableOptionProperties;
import org.apache.hudi.util.AvroSchemaConverter;
import org.apache.hudi.util.DataTypeUtils;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCatalog.class);
    private final org.apache.hadoop.conf.Configuration hadoopConf;
    private final String catalogPathStr;
    private final Map<String, String> tableCommonOptions;
    private Path catalogPath;
    private FileSystem fs;

    public HoodieCatalog(String name, Configuration options) {
        super(name, options.get(CatalogOptions.DEFAULT_DATABASE));
        this.catalogPathStr = options.get(CatalogOptions.CATALOG_PATH);
        this.hadoopConf = HadoopConfigurations.getHadoopConf(options);
        this.tableCommonOptions = CatalogOptions.tableCommonOptions(options);
    }

    public void open() throws CatalogException {
        this.fs = FSUtils.getFs(this.catalogPathStr, this.hadoopConf);
        this.catalogPath = new Path(this.catalogPathStr);
        try {
            if (!this.fs.exists(this.catalogPath)) {
                throw new CatalogException(String.format("Catalog %s path %s does not exist.", this.getName(), this.catalogPathStr));
            }
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Checking catalog path %s exists exception.", this.catalogPathStr), (Throwable)e);
        }
    }

    public void close() throws CatalogException {
        try {
            this.fs.close();
        }
        catch (IOException e) {
            throw new CatalogException("Closing FileSystem exception.", (Throwable)e);
        }
    }

    public List<String> listDatabases() throws CatalogException {
        try {
            FileStatus[] fileStatuses = this.fs.listStatus(this.catalogPath);
            return Arrays.stream(fileStatuses).filter(FileStatus::isDirectory).map(fileStatus -> fileStatus.getPath().getName()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CatalogException("Listing database exception.", (Throwable)e);
        }
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (this.databaseExists(databaseName)) {
            return new CatalogDatabaseImpl(Collections.emptyMap(), null);
        }
        throw new DatabaseNotExistException(this.getName(), databaseName);
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        Preconditions.checkArgument(!StringUtils.isNullOrEmpty(databaseName));
        return this.listDatabases().contains(databaseName);
    }

    public void createDatabase(String databaseName, CatalogDatabase catalogDatabase, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        if (this.databaseExists(databaseName)) {
            if (ignoreIfExists) {
                return;
            }
            throw new DatabaseAlreadyExistException(this.getName(), databaseName);
        }
        if (!CollectionUtil.isNullOrEmpty(catalogDatabase.getProperties())) {
            throw new CatalogException("Hudi catalog doesn't support to create database with options.");
        }
        Path dbPath = new Path(this.catalogPath, databaseName);
        try {
            this.fs.mkdirs(dbPath);
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Creating database %s exception.", databaseName), (Throwable)e);
        }
    }

    public void dropDatabase(String databaseName, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        if (!this.databaseExists(databaseName)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        List<String> tables = this.listTables(databaseName);
        if (!tables.isEmpty() && !cascade) {
            throw new DatabaseNotEmptyException(this.getName(), databaseName);
        }
        if (databaseName.equals(this.getDefaultDatabase())) {
            throw new IllegalArgumentException("Hudi catalog doesn't support to drop the default database.");
        }
        Path dbPath = new Path(this.catalogPath, databaseName);
        try {
            this.fs.delete(dbPath, true);
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Dropping database %s exception.", databaseName), (Throwable)e);
        }
    }

    public void alterDatabase(String databaseName, CatalogDatabase catalogDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException("Altering database is not implemented.");
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        Path dbPath = new Path(this.catalogPath, databaseName);
        try {
            return Arrays.stream(this.fs.listStatus(dbPath)).filter(FileStatus::isDirectory).map(fileStatus -> fileStatus.getPath().getName()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Listing table in database %s exception.", dbPath), (Throwable)e);
        }
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        String path = this.inferTablePath(this.catalogPathStr, tablePath);
        Map<String, String> options = TableOptionProperties.loadFromProperties(path, this.hadoopConf);
        org.apache.avro.Schema latestSchema = this.getLatestTableSchema(path);
        if (latestSchema != null) {
            List<String> pkColumns = TableOptionProperties.getPkColumns(options);
            DataType tableDataType = DataTypeUtils.ensureColumnsAsNonNullable(AvroSchemaConverter.convertToDataType(latestSchema), pkColumns);
            Schema.Builder builder = Schema.newBuilder().fromRowDataType(tableDataType);
            String pkConstraintName = TableOptionProperties.getPkConstraintName(options);
            if (!StringUtils.isNullOrEmpty(pkConstraintName)) {
                builder.primaryKeyNamed(pkConstraintName, pkColumns);
            } else if (!CollectionUtils.isNullOrEmpty(pkColumns)) {
                builder.primaryKey(pkColumns);
            }
            Schema schema = builder.build();
            return CatalogTable.of((Schema)schema, (String)TableOptionProperties.getComment(options), TableOptionProperties.getPartitionColumns(options), TableOptionProperties.getTableOptions(options));
        }
        throw new TableNotExistException(this.getName(), tablePath);
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable catalogTable, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
        if (this.tableExists(tablePath)) {
            if (ignoreIfExists) {
                return;
            }
            throw new TableAlreadyExistException(this.getName(), tablePath);
        }
        if (catalogTable instanceof CatalogView) {
            throw new UnsupportedOperationException("Hudi catalog doesn't support to CREATE VIEW.");
        }
        ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)catalogTable;
        String tablePathStr = this.inferTablePath(this.catalogPathStr, tablePath);
        Map<String, String> options = this.applyOptionsHook(tablePathStr, catalogTable.getOptions());
        Configuration conf = Configuration.fromMap(options);
        conf.setString(FlinkOptions.PATH, tablePathStr);
        ResolvedSchema resolvedSchema = resolvedTable.getResolvedSchema();
        if (!resolvedSchema.getPrimaryKey().isPresent()) {
            throw new CatalogException("Primary key definition is missing");
        }
        String avroSchema = AvroSchemaConverter.convertToSchema(resolvedSchema.toPhysicalRowDataType().getLogicalType()).toString();
        conf.setString(FlinkOptions.SOURCE_AVRO_SCHEMA, avroSchema);
        String pkColumns = String.join((CharSequence)",", ((UniqueConstraint)resolvedSchema.getPrimaryKey().get()).getColumns());
        conf.setString(FlinkOptions.RECORD_KEY_FIELD, pkColumns);
        options.put("pk.constraint.name", ((UniqueConstraint)resolvedSchema.getPrimaryKey().get()).getName());
        options.put("pk.columns", pkColumns);
        String preCombineField = conf.getString(FlinkOptions.PRECOMBINE_FIELD);
        if (!resolvedSchema.getColumnNames().contains(preCombineField)) {
            if (OptionsResolver.isDefaultHoodieRecordPayloadClazz(conf)) {
                throw new HoodieValidationException("Option '" + FlinkOptions.PRECOMBINE_FIELD.key() + "' is required for payload class: " + DefaultHoodieRecordPayload.class.getName());
            }
            if (preCombineField.equals(FlinkOptions.PRECOMBINE_FIELD.defaultValue())) {
                conf.setString(FlinkOptions.PRECOMBINE_FIELD, "no_precombine");
            } else if (!preCombineField.equals("no_precombine")) {
                throw new HoodieValidationException("Field " + preCombineField + " does not exist in the table schema.Please check '" + FlinkOptions.PRECOMBINE_FIELD.key() + "' option.");
            }
        }
        if (resolvedTable.isPartitioned()) {
            String partitions = String.join((CharSequence)",", resolvedTable.getPartitionKeys());
            conf.setString(FlinkOptions.PARTITION_PATH_FIELD, partitions);
            options.put("partition.columns", partitions);
        }
        conf.setString(FlinkOptions.TABLE_NAME, tablePath.getObjectName());
        try {
            StreamerUtil.initTableIfNotExists(conf);
            if (!StringUtils.isNullOrEmpty(resolvedTable.getComment())) {
                options.put("comment", resolvedTable.getComment());
            }
            TableOptionProperties.createProperties(tablePathStr, this.hadoopConf, options);
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Initialize table path %s exception.", tablePathStr), (Throwable)e);
        }
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        return StreamerUtil.tableExists(this.inferTablePath(this.catalogPathStr, tablePath), this.hadoopConf);
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (!this.tableExists(tablePath)) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new TableNotExistException(this.getName(), tablePath);
        }
        Path path = new Path(this.inferTablePath(this.catalogPathStr, tablePath));
        try {
            this.fs.delete(path, true);
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Dropping table %s exception.", tablePath), (Throwable)e);
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        throw new UnsupportedOperationException("renameTable is not implemented.");
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable catalogBaseTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterTable is not implemented.");
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        return Collections.emptyList();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return Collections.emptyList();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        return Collections.emptyList();
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return Collections.emptyList();
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        throw new PartitionNotExistException(this.getName(), tablePath, catalogPartitionSpec);
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec) throws CatalogException {
        return false;
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec, CatalogPartition catalogPartition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        throw new UnsupportedOperationException("createPartition is not implemented.");
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException("dropPartition is not implemented.");
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec, CatalogPartition catalogPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterPartition is not implemented.");
    }

    public List<String> listFunctions(String databaseName) throws DatabaseNotExistException, CatalogException {
        return Collections.emptyList();
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException(this.getName(), functionPath);
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return false;
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction catalogFunction, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException("createFunction is not implemented.");
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction catalogFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterFunction is not implemented.");
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        throw new UnsupportedOperationException("dropFunction is not implemented.");
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec) throws PartitionNotExistException, CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics catalogTableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterTableStatistics is not implemented.");
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics catalogColumnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
        throw new UnsupportedOperationException("alterTableColumnStatistics is not implemented.");
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec, CatalogTableStatistics catalogTableStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterPartitionStatistics is not implemented.");
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec catalogPartitionSpec, CatalogColumnStatistics catalogColumnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new UnsupportedOperationException("alterPartitionColumnStatistics is not implemented.");
    }

    @Nullable
    private org.apache.avro.Schema getLatestTableSchema(String path) {
        if (path != null && StreamerUtil.tableExists(path, this.hadoopConf)) {
            try {
                HoodieTableMetaClient metaClient = StreamerUtil.createMetaClient(path, this.hadoopConf);
                return new TableSchemaResolver(metaClient).getTableAvroSchema(false);
            }
            catch (Throwable throwable) {
                LOG.warn("Error while resolving the latest table schema.", throwable);
            }
        }
        return null;
    }

    private Map<String, String> applyOptionsHook(String tablePath, Map<String, String> options) {
        HashMap<String, String> newOptions = new HashMap<String, String>(options);
        newOptions.put("connector", "hudi");
        newOptions.computeIfAbsent(FlinkOptions.PATH.key(), k -> tablePath);
        this.tableCommonOptions.forEach(newOptions::putIfAbsent);
        return newOptions;
    }

    private String inferTablePath(String catalogPath, ObjectPath tablePath) {
        return String.format("%s/%s/%s", catalogPath, tablePath.getDatabaseName(), tablePath.getObjectName());
    }
}

