/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieCatalogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCatalogUtil.class);

    public static HiveConf createHiveConf(@Nullable String hiveConfDir) {
        HiveConf hiveConf;
        block17: {
            org.apache.hadoop.conf.Configuration hadoopConf = HadoopConfigurations.getHadoopConf(new Configuration());
            HiveConf.setHiveSiteLocation(null);
            HiveConf.setLoadMetastoreConfig((boolean)false);
            HiveConf.setLoadHiveServer2Config((boolean)false);
            hiveConf = new HiveConf(hadoopConf, HiveConf.class);
            LOG.info("Setting hive conf dir as {}", (Object)hiveConfDir);
            if (hiveConfDir != null) {
                Path hiveSite = new Path(hiveConfDir, "hive-site.xml");
                if (!hiveSite.toUri().isAbsolute()) {
                    hiveSite = new Path(new File(hiveSite.toString()).toURI());
                }
                try (FSDataInputStream inputStream = hiveSite.getFileSystem(hadoopConf).open(hiveSite);){
                    hiveConf.addResource((InputStream)inputStream, hiveSite.toString());
                    HoodieCatalogUtil.isEmbeddedMetastore(hiveConf);
                    break block17;
                }
                catch (IOException e) {
                    throw new CatalogException("Failed to load hive-site.xml from specified path:" + hiveSite, (Throwable)e);
                }
            }
            URL hiveSite = Thread.currentThread().getContextClassLoader().getResource("hive-site.xml");
            if (hiveSite != null) {
                LOG.info("Found {} in classpath: {}", (Object)"hive-site.xml", (Object)hiveSite);
                hiveConf.addResource(hiveSite);
            }
        }
        return hiveConf;
    }

    public static boolean isEmbeddedMetastore(HiveConf hiveConf) {
        return StringUtils.isNullOrWhitespaceOnly(hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
    }

    public static List<String> getPartitionKeys(CatalogTable table) {
        if (table.isPartitioned()) {
            return table.getPartitionKeys();
        }
        if (table.getOptions().containsKey(FlinkOptions.PARTITION_PATH_FIELD.key())) {
            return Arrays.stream(((String)table.getOptions().get(FlinkOptions.PARTITION_PATH_FIELD.key())).split(",")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

