/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.table.HoodieFlinkTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteringUtil.class);

    public static void validateClusteringScheduling(Configuration conf) {
        if (OptionsResolver.isBucketIndexType(conf)) {
            throw new UnsupportedOperationException("Clustering is not supported for bucket index.");
        }
    }

    public static void scheduleClustering(Configuration conf, HoodieFlinkWriteClient writeClient, boolean committed) {
        ClusteringUtil.validateClusteringScheduling(conf);
        if (committed) {
            writeClient.scheduleClustering(Option.empty());
        }
    }

    public static void rollbackClustering(HoodieFlinkTable<?> table, HoodieFlinkWriteClient writeClient) {
        List<HoodieInstant> inflightInstants = ClusteringUtils.getPendingClusteringInstantTimes(table.getMetaClient()).stream().filter(instant -> instant.getState() == HoodieInstant.State.INFLIGHT).collect(Collectors.toList());
        inflightInstants.forEach(inflightInstant -> {
            LOG.info("Rollback the inflight clustering instant: " + inflightInstant + " for failover");
            table.rollbackInflightClustering((HoodieInstant)inflightInstant, commitToRollback -> writeClient.getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
            table.getMetaClient().reloadActiveTimeline();
        });
    }
}

