/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import com.codahale.metrics.Timer;
import java.io.Serializable;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.Metrics;

public class HoodieDeltaStreamerMetrics
implements Serializable {
    private HoodieWriteConfig config;
    private String tableName;
    public String overallTimerName = null;
    public String hiveSyncTimerName = null;
    public String metaSyncTimerName = null;
    private transient Timer overallTimer = null;
    public transient Timer hiveSyncTimer = null;
    public transient Timer metaSyncTimer = null;

    public HoodieDeltaStreamerMetrics(HoodieWriteConfig config) {
        this.config = config;
        this.tableName = config.getTableName();
        if (config.isMetricsOn()) {
            Metrics.init(config);
            this.overallTimerName = this.getMetricsName("timer", "deltastreamer");
            this.hiveSyncTimerName = this.getMetricsName("timer", "deltastreamerHiveSync");
            this.metaSyncTimerName = this.getMetricsName("timer", "deltastreamerMetaSync");
        }
    }

    public Timer.Context getOverallTimerContext() {
        if (this.config.isMetricsOn() && this.overallTimer == null) {
            this.overallTimer = this.createTimer(this.overallTimerName);
        }
        return this.overallTimer == null ? null : this.overallTimer.time();
    }

    public Timer.Context getHiveSyncTimerContext() {
        if (this.config.isMetricsOn() && this.hiveSyncTimer == null) {
            this.hiveSyncTimer = this.createTimer(this.hiveSyncTimerName);
        }
        return this.hiveSyncTimer == null ? null : this.hiveSyncTimer.time();
    }

    public Timer.Context getMetaSyncTimerContext() {
        if (this.config.isMetricsOn() && this.metaSyncTimer == null) {
            this.metaSyncTimer = this.createTimer(this.metaSyncTimerName);
        }
        return this.metaSyncTimer == null ? null : this.metaSyncTimer.time();
    }

    private Timer createTimer(String name) {
        return this.config.isMetricsOn() ? Metrics.getInstance().getRegistry().timer(name) : null;
    }

    String getMetricsName(String action, String metric) {
        return this.config == null ? null : String.format("%s.%s.%s", this.config.getMetricReporterMetricsNamePrefix(), action, metric);
    }

    public void updateDeltaStreamerMetrics(long durationInNs) {
        if (this.config.isMetricsOn()) {
            Metrics.registerGauge(this.getMetricsName("deltastreamer", "duration"), this.getDurationInMs(durationInNs));
        }
    }

    public void updateDeltaStreamerMetaSyncMetrics(String syncClassShortName, long syncNs) {
        if (this.config.isMetricsOn()) {
            Metrics.registerGauge(this.getMetricsName("deltastreamer", syncClassShortName), this.getDurationInMs(syncNs));
        }
    }

    public void updateDeltaStreamerKafkaDelayCountMetrics(long kafkaDelayCount) {
        if (this.config.isMetricsOn()) {
            Metrics.registerGauge(this.getMetricsName("deltastreamer", "kafkaDelayCount"), kafkaDelayCount);
        }
    }

    public void updateDeltaStreamerSyncMetrics(long syncEpochTimeInMs) {
        if (this.config.isMetricsOn()) {
            Metrics.registerGauge(this.getMetricsName("deltastreamer", "lastSync"), syncEpochTimeInMs);
        }
    }

    public void updateDeltaStreamerKafkaMessageInCount(long totalNewMsgCount) {
        if (this.config.isMetricsOn()) {
            Metrics.registerGauge(this.getMetricsName("deltastreamer", "kafkaMessageInCount"), totalNewMsgCount);
        }
    }

    public long getDurationInMs(long ctxDuration) {
        return ctxDuration / 1000000L;
    }
}

