/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.postprocessor;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.exception.HoodieSchemaPostProcessException;
import org.apache.hudi.utilities.schema.SchemaPostProcessor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public class DropColumnSchemaPostProcessor
extends SchemaPostProcessor {
    private static final Logger LOG = LogManager.getLogger(DropColumnSchemaPostProcessor.class);

    public DropColumnSchemaPostProcessor(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
    }

    @Override
    public Schema processSchema(Schema schema) {
        String columnToDeleteStr = this.config.getString("hoodie.deltastreamer.schemaprovider.schema_post_processor.delete.columns");
        if (StringUtils.isNullOrEmpty(columnToDeleteStr)) {
            LOG.warn((Object)String.format("Param %s is null or empty, return original schema", "hoodie.deltastreamer.schemaprovider.schema_post_processor.delete.columns"));
        }
        Set columnsToDelete = Arrays.stream(columnToDeleteStr.split(",")).map(filed -> filed.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        List sourceFields = schema.getFields();
        LinkedList<Schema.Field> targetFields = new LinkedList<Schema.Field>();
        for (Schema.Field sourceField : sourceFields) {
            if (columnsToDelete.contains(sourceField.name().toLowerCase(Locale.ROOT))) continue;
            targetFields.add(new Schema.Field(sourceField.name(), sourceField.schema(), sourceField.doc(), sourceField.defaultVal()));
        }
        if (targetFields.isEmpty()) {
            throw new HoodieSchemaPostProcessException("Target schema is empty, you can not remove all columns!");
        }
        return Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)false, targetFields);
    }

    public static class Config {
        public static final String DELETE_COLUMN_POST_PROCESSOR_COLUMN_PROP = "hoodie.deltastreamer.schemaprovider.schema_post_processor.delete.columns";
    }
}

