/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamerMetrics;
import org.apache.hudi.utilities.exception.HoodieSourcePostProcessException;
import org.apache.hudi.utilities.exception.HoodieSourceTimeoutException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.JsonSource;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.hudi.utilities.sources.processor.JsonKafkaSourcePostProcessor;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.kafka010.KafkaUtils;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;

public class JsonKafkaSource
extends JsonSource {
    private static final Logger LOG = LogManager.getLogger(JsonKafkaSource.class);
    private final KafkaOffsetGen offsetGen;
    private final HoodieDeltaStreamerMetrics metrics;

    public JsonKafkaSource(TypedProperties properties, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, HoodieDeltaStreamerMetrics metrics) {
        super(properties, sparkContext, sparkSession, schemaProvider);
        this.metrics = metrics;
        properties.put("key.deserializer", StringDeserializer.class.getName());
        properties.put("value.deserializer", StringDeserializer.class.getName());
        this.offsetGen = new KafkaOffsetGen(properties);
    }

    @Override
    protected InputBatch<JavaRDD<String>> fetchNewData(Option<String> lastCheckpointStr, long sourceLimit) {
        try {
            OffsetRange[] offsetRanges = this.offsetGen.getNextOffsetRanges(lastCheckpointStr, sourceLimit, this.metrics);
            long totalNewMsgs = KafkaOffsetGen.CheckpointUtils.totalNewMessages(offsetRanges);
            LOG.info((Object)("About to read " + totalNewMsgs + " from Kafka for topic :" + this.offsetGen.getTopicName()));
            if (totalNewMsgs <= 0L) {
                return new InputBatch<JavaRDD<String>>(Option.empty(), KafkaOffsetGen.CheckpointUtils.offsetsToStr(offsetRanges));
            }
            JavaRDD<String> newDataRDD = this.toRDD(offsetRanges);
            return new InputBatch<JavaRDD<String>>(Option.of(newDataRDD), KafkaOffsetGen.CheckpointUtils.offsetsToStr(offsetRanges));
        }
        catch (TimeoutException e) {
            throw new HoodieSourceTimeoutException("Kafka Source timed out " + e.getMessage());
        }
    }

    private JavaRDD<String> toRDD(OffsetRange[] offsetRanges) {
        JavaRDD jsonStringRDD = KafkaUtils.createRDD((JavaSparkContext)this.sparkContext, this.offsetGen.getKafkaParams(), (OffsetRange[])offsetRanges, (LocationStrategy)LocationStrategies.PreferConsistent()).filter((Function & Serializable)x -> !StringUtils.isNullOrEmpty((String)x.value())).map((Function & Serializable)x -> x.value().toString());
        return this.postProcess((JavaRDD<String>)jsonStringRDD);
    }

    private JavaRDD<String> postProcess(JavaRDD<String> jsonStringRDD) {
        JsonKafkaSourcePostProcessor processor;
        String postProcessorClassName = this.props.getString(KafkaOffsetGen.Config.JSON_KAFKA_PROCESSOR_CLASS_OPT.key(), null);
        if (StringUtils.isNullOrEmpty(postProcessorClassName)) {
            return jsonStringRDD;
        }
        try {
            processor = UtilHelpers.createJsonKafkaSourcePostProcessor(postProcessorClassName, this.props);
        }
        catch (IOException e) {
            throw new HoodieSourcePostProcessException("Could not init " + postProcessorClassName, e);
        }
        return processor.process(jsonStringRDD);
    }

    @Override
    public void onCommit(String lastCkptStr) {
        if (this.props.getBoolean(KafkaOffsetGen.Config.ENABLE_KAFKA_COMMIT_OFFSET.key(), KafkaOffsetGen.Config.ENABLE_KAFKA_COMMIT_OFFSET.defaultValue())) {
            this.offsetGen.commitOffsetToKafka(lastCkptStr);
        }
    }
}

