/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.util;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BloomFilterData
implements Comparable<BloomFilterData> {
    private final String partitionPath;
    private final String filename;
    private final ByteBuffer bloomFilter;

    private BloomFilterData(String partitionPath, String filename, ByteBuffer bloomFilter) {
        this.partitionPath = partitionPath;
        this.filename = filename;
        this.bloomFilter = bloomFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int compareTo(@NotNull BloomFilterData o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomFilterData that = (BloomFilterData)o;
        return this.partitionPath.equals(that.partitionPath) && this.filename.equals(that.filename) && this.bloomFilter.equals(that.bloomFilter);
    }

    public int hashCode() {
        return Objects.hash(this.partitionPath, this.filename, this.bloomFilter);
    }

    public String toString() {
        String bloomFilterString = new String(this.bloomFilter.array());
        return "BloomFilterData{partitionPath='" + this.partitionPath + '\'' + ", filename='" + this.filename + '\'' + ", bloomFilter=" + (bloomFilterString.length() > 50 ? bloomFilterString.substring(0, 50) + "..." : bloomFilterString) + '}';
    }

    public static class Builder {
        private String partitionPath;
        private String filename;
        private ByteBuffer bloomFilter;

        public Builder setPartitionPath(String partitionPath) {
            this.partitionPath = partitionPath;
            return this;
        }

        public Builder setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder setBloomFilter(ByteBuffer bloomFilter) {
            this.bloomFilter = bloomFilter;
            return this;
        }

        public BloomFilterData build() {
            return new BloomFilterData(this.partitionPath, this.filename, this.bloomFilter);
        }
    }
}

