/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.esotericsoftware.kryo.factories;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.factories.SerializerFactory;
import io.hops.hudi.com.esotericsoftware.kryo.util.Util;

public class ReflectionSerializerFactory
implements SerializerFactory {
    private final Class<? extends Serializer> serializerClass;

    public ReflectionSerializerFactory(Class<? extends Serializer> serializerClass) {
        this.serializerClass = serializerClass;
    }

    @Override
    public Serializer makeSerializer(Kryo kryo, Class<?> type) {
        return ReflectionSerializerFactory.makeSerializer(kryo, this.serializerClass, type);
    }

    public static Serializer makeSerializer(Kryo kryo, Class<? extends Serializer> serializerClass, Class<?> type) {
        try {
            try {
                return serializerClass.getConstructor(Kryo.class, Class.class).newInstance(kryo, type);
            }
            catch (NoSuchMethodException ex1) {
                try {
                    return serializerClass.getConstructor(Kryo.class).newInstance(kryo);
                }
                catch (NoSuchMethodException ex2) {
                    try {
                        return serializerClass.getConstructor(Class.class).newInstance(type);
                    }
                    catch (NoSuchMethodException ex3) {
                        return serializerClass.newInstance();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to create serializer \"" + serializerClass.getName() + "\" for class: " + Util.className(type), ex);
        }
    }
}

