/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.ExtendedCell;
import io.hops.hudi.org.apache.hadoop.hbase.KeyValue;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NoTagsKeyValue
extends KeyValue {
    public NoTagsKeyValue(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    @Override
    public int getTagsLength() {
        return 0;
    }

    @Override
    public int write(OutputStream out, boolean withTags) throws IOException {
        out.write(this.bytes, this.offset, this.length);
        return this.length;
    }

    @Override
    public int getSerializedSize(boolean withTags) {
        return this.length;
    }

    @Override
    public ExtendedCell deepClone() {
        byte[] copy = Bytes.copy(this.bytes, this.offset, this.length);
        NoTagsKeyValue kv = new NoTagsKeyValue(copy, 0, copy.length);
        kv.setSequenceId(this.getSequenceId());
        return kv;
    }
}

