/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.ArrayBackedTag;
import io.hops.hudi.org.apache.hadoop.hbase.ByteBufferExtendedCell;
import io.hops.hudi.org.apache.hadoop.hbase.ByteBufferTag;
import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.CellComparator;
import io.hops.hudi.org.apache.hadoop.hbase.CellComparatorImpl;
import io.hops.hudi.org.apache.hadoop.hbase.CellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.ExtendedCell;
import io.hops.hudi.org.apache.hadoop.hbase.HConstants;
import io.hops.hudi.org.apache.hadoop.hbase.KeyValue;
import io.hops.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import io.hops.hudi.org.apache.hadoop.hbase.Tag;
import io.hops.hudi.org.apache.hadoop.hbase.TagUtil;
import io.hops.hudi.org.apache.hadoop.hbase.filter.ByteArrayComparable;
import io.hops.hudi.org.apache.hadoop.hbase.io.TagCompressionContext;
import io.hops.hudi.org.apache.hadoop.hbase.io.util.Dictionary;
import io.hops.hudi.org.apache.hadoop.hbase.io.util.StreamUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteRange;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.util.ClassSize;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class PrivateCellUtil {
    private PrivateCellUtil() {
    }

    public static ByteRange fillRowRange(Cell cell, ByteRange range) {
        return range.set(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static ByteRange fillFamilyRange(Cell cell, ByteRange range) {
        return range.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
    }

    public static ByteRange fillQualifierRange(Cell cell, ByteRange range) {
        return range.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static ByteRange fillValueRange(Cell cell, ByteRange range) {
        return range.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static ByteRange fillTagRange(Cell cell, ByteRange range) {
        return range.set(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
    }

    public static byte getRowByte(Cell cell, int index) {
        if (cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)cell).getRowByteBuffer().get(((ByteBufferExtendedCell)cell).getRowPosition() + index);
        }
        return cell.getRowArray()[cell.getRowOffset() + index];
    }

    public static byte getQualifierByte(Cell cell, int index) {
        if (cell instanceof ByteBufferExtendedCell) {
            return ((ByteBufferExtendedCell)cell).getQualifierByteBuffer().get(((ByteBufferExtendedCell)cell).getQualifierPosition() + index);
        }
        return cell.getQualifierArray()[cell.getQualifierOffset() + index];
    }

    public static ByteBuffer getValueBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        return buffer;
    }

    public static Cell createCell(Cell cell, List<Tag> tags) {
        return PrivateCellUtil.createCell(cell, TagUtil.fromList(tags));
    }

    public static Cell createCell(Cell cell, byte[] tags) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new TagRewriteByteBufferExtendedCell((ByteBufferExtendedCell)cell, tags);
        }
        return new TagRewriteCell(cell, tags);
    }

    public static Cell createCell(Cell cell, byte[] value, byte[] tags) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new ValueAndTagRewriteByteBufferExtendedCell((ByteBufferExtendedCell)cell, value, tags);
        }
        return new ValueAndTagRewriteCell(cell, value, tags);
    }

    public static boolean matchingRows(Cell left, byte[] buf, int offset, int length) {
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getRowByteBuffer(), ((ByteBufferExtendedCell)left).getRowPosition(), (int)left.getRowLength(), buf, offset, length);
        }
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), left.getRowLength(), buf, offset, length);
    }

    public static boolean matchingFamily(Cell left, byte[] buf, int offset, int length) {
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getFamilyByteBuffer(), ((ByteBufferExtendedCell)left).getFamilyPosition(), (int)left.getFamilyLength(), buf, offset, length);
        }
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), buf, offset, length);
    }

    public static boolean matchingQualifier(Cell left, byte[] buf, int offset, int length) {
        if (buf == null) {
            return left.getQualifierLength() == 0;
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), left.getQualifierLength(), buf, offset, length);
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), buf, offset, length);
    }

    public static boolean qualifierStartsWith(Cell left, byte[] startsWith) {
        if (startsWith == null || startsWith.length == 0) {
            throw new IllegalArgumentException("Cannot pass an empty startsWith");
        }
        if (left.getQualifierLength() < startsWith.length) {
            return false;
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getQualifierByteBuffer(), ((ByteBufferExtendedCell)left).getQualifierPosition(), startsWith.length, startsWith, 0, startsWith.length);
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), startsWith.length, startsWith, 0, startsWith.length);
    }

    public static boolean matchingColumn(Cell left, byte[] fam, int foffset, int flength, byte[] qual, int qoffset, int qlength) {
        if (!PrivateCellUtil.matchingFamily(left, fam, foffset, flength)) {
            return false;
        }
        return PrivateCellUtil.matchingQualifier(left, qual, qoffset, qlength);
    }

    public static boolean matchingValue(Cell left, Cell right, int lvlength, int rvlength) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getValueByteBuffer(), ((ByteBufferExtendedCell)left).getValuePosition(), lvlength, ((ByteBufferExtendedCell)right).getValueByteBuffer(), ((ByteBufferExtendedCell)right).getValuePosition(), rvlength);
        }
        if (left instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)left).getValueByteBuffer(), ((ByteBufferExtendedCell)left).getValuePosition(), lvlength, right.getValueArray(), right.getValueOffset(), rvlength);
        }
        if (right instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.equals(((ByteBufferExtendedCell)right).getValueByteBuffer(), ((ByteBufferExtendedCell)right).getValuePosition(), rvlength, left.getValueArray(), left.getValueOffset(), lvlength);
        }
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), lvlength, right.getValueArray(), right.getValueOffset(), rvlength);
    }

    public static boolean matchingType(Cell a, Cell b) {
        return a.getTypeByte() == b.getTypeByte();
    }

    public static boolean matchingTags(Cell left, Cell right, int llength, int rlength) {
        if (left instanceof ByteBufferExtendedCell && right instanceof ByteBufferExtendedCell) {
            ByteBufferExtendedCell leftBBCell = (ByteBufferExtendedCell)left;
            ByteBufferExtendedCell rightBBCell = (ByteBufferExtendedCell)right;
            return ByteBufferUtils.equals(leftBBCell.getTagsByteBuffer(), leftBBCell.getTagsPosition(), llength, rightBBCell.getTagsByteBuffer(), rightBBCell.getTagsPosition(), rlength);
        }
        if (left instanceof ByteBufferExtendedCell) {
            ByteBufferExtendedCell leftBBCell = (ByteBufferExtendedCell)left;
            return ByteBufferUtils.equals(leftBBCell.getTagsByteBuffer(), leftBBCell.getTagsPosition(), llength, right.getTagsArray(), right.getTagsOffset(), rlength);
        }
        if (right instanceof ByteBufferExtendedCell) {
            ByteBufferExtendedCell rightBBCell = (ByteBufferExtendedCell)right;
            return ByteBufferUtils.equals(rightBBCell.getTagsByteBuffer(), rightBBCell.getTagsPosition(), rlength, left.getTagsArray(), left.getTagsOffset(), llength);
        }
        return Bytes.equals(left.getTagsArray(), left.getTagsOffset(), llength, right.getTagsArray(), right.getTagsOffset(), rlength);
    }

    public static boolean isDelete(byte type) {
        return KeyValue.Type.Delete.getCode() <= type && type <= KeyValue.Type.DeleteFamily.getCode();
    }

    public static boolean isDeleteType(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    public static boolean isDeleteFamily(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode();
    }

    public static boolean isDeleteFamilyVersion(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode();
    }

    public static boolean isDeleteColumns(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode();
    }

    public static boolean isDeleteColumnVersion(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    public static boolean isDeleteColumnOrFamily(Cell cell) {
        byte t = cell.getTypeByte();
        return t == KeyValue.Type.DeleteColumn.getCode() || t == KeyValue.Type.DeleteFamily.getCode();
    }

    public static byte[] cloneTags(Cell cell) {
        byte[] output = new byte[cell.getTagsLength()];
        PrivateCellUtil.copyTagsTo(cell, output, 0);
        return output;
    }

    public static int copyTagsTo(Cell cell, byte[] destination, int destinationOffset) {
        int tlen = cell.getTagsLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToArray(destination, ((ByteBufferExtendedCell)cell).getTagsByteBuffer(), ((ByteBufferExtendedCell)cell).getTagsPosition(), destinationOffset, tlen);
        } else {
            System.arraycopy(cell.getTagsArray(), cell.getTagsOffset(), destination, destinationOffset, tlen);
        }
        return destinationOffset + tlen;
    }

    public static int copyTagsTo(Cell cell, ByteBuffer destination, int destinationOffset) {
        int tlen = cell.getTagsLength();
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyFromBufferToBuffer(((ByteBufferExtendedCell)cell).getTagsByteBuffer(), destination, ((ByteBufferExtendedCell)cell).getTagsPosition(), destinationOffset, tlen);
        } else {
            ByteBufferUtils.copyFromArrayToBuffer(destination, destinationOffset, cell.getTagsArray(), cell.getTagsOffset(), tlen);
        }
        return destinationOffset + tlen;
    }

    public static List<Tag> getTags(Cell cell) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Iterator<Tag> tagsItr = PrivateCellUtil.tagsIterator(cell);
        while (tagsItr.hasNext()) {
            tags.add(tagsItr.next());
        }
        return tags;
    }

    public static Optional<Tag> getTag(Cell cell, byte type) {
        int offset;
        int tagLen;
        boolean bufferBacked = cell instanceof ByteBufferExtendedCell;
        int length = cell.getTagsLength();
        for (int pos = offset = bufferBacked ? ((ByteBufferExtendedCell)cell).getTagsPosition() : cell.getTagsOffset(); pos < offset + length; pos += 2 + tagLen) {
            if (bufferBacked) {
                ByteBuffer tagsBuffer = ((ByteBufferExtendedCell)cell).getTagsByteBuffer();
                tagLen = ByteBufferUtils.readAsInt(tagsBuffer, pos, 2);
                if (ByteBufferUtils.toByte(tagsBuffer, pos + 2) != type) continue;
                return Optional.of(new ByteBufferTag(tagsBuffer, pos, tagLen + 2));
            }
            tagLen = Bytes.readAsInt(cell.getTagsArray(), pos, 2);
            if (cell.getTagsArray()[pos + 2] != type) continue;
            return Optional.of(new ArrayBackedTag(cell.getTagsArray(), pos, tagLen + 2));
        }
        return Optional.empty();
    }

    public static Iterator<Tag> tagsIterator(Cell cell) {
        int tagsLength = cell.getTagsLength();
        if (tagsLength == 0) {
            return TagUtil.EMPTY_TAGS_ITR;
        }
        if (cell instanceof ByteBufferExtendedCell) {
            return PrivateCellUtil.tagsIterator(((ByteBufferExtendedCell)cell).getTagsByteBuffer(), ((ByteBufferExtendedCell)cell).getTagsPosition(), tagsLength);
        }
        return CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
    }

    public static Iterator<Tag> tagsIterator(final ByteBuffer tags, final int offset, final int length) {
        return new Iterator<Tag>(){
            private int pos;
            private int endOffset;
            {
                this.pos = offset;
                this.endOffset = offset + length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.endOffset;
            }

            @Override
            public Tag next() {
                if (this.hasNext()) {
                    int curTagLen = ByteBufferUtils.readAsInt(tags, this.pos, 2);
                    ByteBufferTag tag = new ByteBufferTag(tags, this.pos, curTagLen + 2);
                    this.pos += 2 + curTagLen;
                    return tag;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean overlappingKeys(byte[] start1, byte[] end1, byte[] start2, byte[] end2) {
        return !(end2.length != 0 && start1.length != 0 && Bytes.compareTo(start1, end2) >= 0 || end1.length != 0 && start2.length != 0 && Bytes.compareTo(start2, end1) >= 0);
    }

    public static void writeRowKeyExcludingCommon(Cell cell, short rLen, int commonPrefix, DataOutputStream out) throws IOException {
        if (commonPrefix == 0) {
            out.writeShort(rLen);
        } else if (commonPrefix == 1) {
            out.writeByte((byte)rLen);
            --commonPrefix;
        } else {
            commonPrefix -= 2;
        }
        if (rLen > commonPrefix) {
            PrivateCellUtil.writeRowSkippingBytes(out, cell, rLen, commonPrefix);
        }
    }

    public static void writeRowSkippingBytes(DataOutputStream out, Cell cell, short rlength, int commonPrefix) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition() + commonPrefix, rlength - commonPrefix);
        } else {
            out.write(cell.getRowArray(), cell.getRowOffset() + commonPrefix, rlength - commonPrefix);
        }
    }

    public static int findCommonPrefixInFlatKey(Cell c1, Cell c2, boolean bypassFamilyCheck, boolean withTsType) {
        short rLen1 = c1.getRowLength();
        short rLen2 = c2.getRowLength();
        int commonPrefix = 2;
        if (rLen1 != rLen2) {
            return ByteBufferUtils.findCommonPrefix(Bytes.toBytes(rLen1), 0, 2, Bytes.toBytes(rLen2), 0, 2);
        }
        int rkCommonPrefix = 0;
        rkCommonPrefix = c1 instanceof ByteBufferExtendedCell && c2 instanceof ByteBufferExtendedCell ? ByteBufferUtils.findCommonPrefix(((ByteBufferExtendedCell)c1).getRowByteBuffer(), ((ByteBufferExtendedCell)c1).getRowPosition(), (int)rLen1, ((ByteBufferExtendedCell)c2).getRowByteBuffer(), ((ByteBufferExtendedCell)c2).getRowPosition(), (int)rLen2) : ByteBufferUtils.findCommonPrefix(c1.getRowArray(), c1.getRowOffset(), (int)rLen1, c2.getRowArray(), c2.getRowOffset(), (int)rLen2);
        commonPrefix += rkCommonPrefix;
        if (rkCommonPrefix != rLen1) {
            return commonPrefix;
        }
        byte fLen1 = c1.getFamilyLength();
        if (bypassFamilyCheck) {
            commonPrefix += 1 + fLen1;
        } else {
            byte fLen2 = c2.getFamilyLength();
            if (fLen1 != fLen2) {
                return commonPrefix;
            }
            ++commonPrefix;
            int fCommonPrefix = c1 instanceof ByteBufferExtendedCell && c2 instanceof ByteBufferExtendedCell ? ByteBufferUtils.findCommonPrefix(((ByteBufferExtendedCell)c1).getFamilyByteBuffer(), ((ByteBufferExtendedCell)c1).getFamilyPosition(), (int)fLen1, ((ByteBufferExtendedCell)c2).getFamilyByteBuffer(), ((ByteBufferExtendedCell)c2).getFamilyPosition(), (int)fLen2) : ByteBufferUtils.findCommonPrefix(c1.getFamilyArray(), c1.getFamilyOffset(), (int)fLen1, c2.getFamilyArray(), c2.getFamilyOffset(), (int)fLen2);
            commonPrefix += fCommonPrefix;
            if (fCommonPrefix != fLen1) {
                return commonPrefix;
            }
        }
        int qLen1 = c1.getQualifierLength();
        int qLen2 = c2.getQualifierLength();
        int qCommon = c1 instanceof ByteBufferExtendedCell && c2 instanceof ByteBufferExtendedCell ? ByteBufferUtils.findCommonPrefix(((ByteBufferExtendedCell)c1).getQualifierByteBuffer(), ((ByteBufferExtendedCell)c1).getQualifierPosition(), qLen1, ((ByteBufferExtendedCell)c2).getQualifierByteBuffer(), ((ByteBufferExtendedCell)c2).getQualifierPosition(), qLen2) : ByteBufferUtils.findCommonPrefix(c1.getQualifierArray(), c1.getQualifierOffset(), qLen1, c2.getQualifierArray(), c2.getQualifierOffset(), qLen2);
        commonPrefix += qCommon;
        if (!withTsType || Math.max(qLen1, qLen2) != qCommon) {
            return commonPrefix;
        }
        int tsCommonPrefix = ByteBufferUtils.findCommonPrefix(Bytes.toBytes(c1.getTimestamp()), 0, 8, Bytes.toBytes(c2.getTimestamp()), 0, 8);
        commonPrefix += tsCommonPrefix;
        if (tsCommonPrefix != 8) {
            return commonPrefix;
        }
        if (c1.getTypeByte() == c2.getTypeByte()) {
            ++commonPrefix;
        }
        return commonPrefix;
    }

    public static final int compareKeyBasedOnColHint(CellComparator comparator, Cell nextIndexedCell, Cell currentCell, int foff, int flen, byte[] colHint, int coff, int clen, long ts, byte type) {
        int compare = comparator.compareRows(nextIndexedCell, currentCell);
        if (compare != 0) {
            return compare;
        }
        if (nextIndexedCell.getFamilyLength() + nextIndexedCell.getQualifierLength() == 0 && nextIndexedCell.getTypeByte() == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        if (flen + clen == 0 && type == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        compare = comparator.compareFamilies(nextIndexedCell, currentCell);
        if (compare != 0) {
            return compare;
        }
        compare = colHint == null ? comparator.compareQualifiers(nextIndexedCell, currentCell) : CellUtil.compareQualifiers(nextIndexedCell, colHint, coff, clen);
        if (compare != 0) {
            return compare;
        }
        compare = comparator.compareTimestamps(nextIndexedCell.getTimestamp(), ts);
        if (compare != 0) {
            return compare;
        }
        return (0xFF & type) - (0xFF & nextIndexedCell.getTypeByte());
    }

    public static final int compareKeyIgnoresMvcc(CellComparator comparator, Cell left, Cell right) {
        return ((CellComparatorImpl)comparator).compare(left, right, true);
    }

    public static int compareRow(Cell cell, ByteArrayComparable comparator) {
        if (cell instanceof ByteBufferExtendedCell) {
            return comparator.compareTo(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), (int)cell.getRowLength());
        }
        return comparator.compareTo(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
    }

    public static int compareFamily(Cell cell, ByteArrayComparable comparator) {
        if (cell instanceof ByteBufferExtendedCell) {
            return comparator.compareTo(((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), (int)cell.getFamilyLength());
        }
        return comparator.compareTo(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength());
    }

    public static int compareQualifier(Cell cell, ByteArrayComparable comparator) {
        if (cell instanceof ByteBufferExtendedCell) {
            return comparator.compareTo(((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), cell.getQualifierLength());
        }
        return comparator.compareTo(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static Cell.Type toType(byte type) {
        KeyValue.Type codeToType = KeyValue.Type.codeToType(type);
        switch (codeToType) {
            case Put: {
                return Cell.Type.Put;
            }
            case Delete: {
                return Cell.Type.Delete;
            }
            case DeleteColumn: {
                return Cell.Type.DeleteColumn;
            }
            case DeleteFamily: {
                return Cell.Type.DeleteFamily;
            }
            case DeleteFamilyVersion: {
                return Cell.Type.DeleteFamilyVersion;
            }
        }
        throw new UnsupportedOperationException("Invalid type of cell " + type);
    }

    public static KeyValue.Type toTypeByte(Cell.Type type) {
        switch (type) {
            case Put: {
                return KeyValue.Type.Put;
            }
            case Delete: {
                return KeyValue.Type.Delete;
            }
            case DeleteColumn: {
                return KeyValue.Type.DeleteColumn;
            }
            case DeleteFamilyVersion: {
                return KeyValue.Type.DeleteFamilyVersion;
            }
            case DeleteFamily: {
                return KeyValue.Type.DeleteFamily;
            }
        }
        throw new UnsupportedOperationException("Unsupported data type:" + (Object)((Object)type));
    }

    public static int compareValue(Cell cell, ByteArrayComparable comparator) {
        if (cell instanceof ByteBufferExtendedCell) {
            return comparator.compareTo(((ByteBufferExtendedCell)cell).getValueByteBuffer(), ((ByteBufferExtendedCell)cell).getValuePosition(), cell.getValueLength());
        }
        return comparator.compareTo(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static void writeFlatKey(Cell cell, DataOutput out) throws IOException {
        short rowLen = cell.getRowLength();
        byte fLen = cell.getFamilyLength();
        int qLen = cell.getQualifierLength();
        if (cell instanceof ByteBufferExtendedCell) {
            out.writeShort(rowLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), (int)rowLen);
            out.writeByte(fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), (int)fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), qLen);
        } else {
            out.writeShort(rowLen);
            out.write(cell.getRowArray(), cell.getRowOffset(), rowLen);
            out.writeByte(fLen);
            out.write(cell.getFamilyArray(), cell.getFamilyOffset(), fLen);
            out.write(cell.getQualifierArray(), cell.getQualifierOffset(), qLen);
        }
        out.writeLong(cell.getTimestamp());
        out.writeByte(cell.getTypeByte());
    }

    public static Cell deepClone(Cell cell) throws CloneNotSupportedException {
        if (cell instanceof ExtendedCell) {
            return ((ExtendedCell)cell).deepClone();
        }
        throw new CloneNotSupportedException();
    }

    public static int writeCell(Cell cell, OutputStream out, boolean withTags) throws IOException {
        if (cell instanceof ExtendedCell) {
            return ((ExtendedCell)cell).write(out, withTags);
        }
        ByteBufferUtils.putInt(out, PrivateCellUtil.estimatedSerializedSizeOfKey(cell));
        ByteBufferUtils.putInt(out, cell.getValueLength());
        PrivateCellUtil.writeFlatKey(cell, out);
        PrivateCellUtil.writeValue(out, cell, cell.getValueLength());
        int tagsLength = cell.getTagsLength();
        if (withTags) {
            byte[] len = new byte[2];
            Bytes.putAsShort(len, 0, tagsLength);
            out.write(len);
            if (tagsLength > 0) {
                PrivateCellUtil.writeTags(out, cell, tagsLength);
            }
        }
        int lenWritten = 8 + PrivateCellUtil.estimatedSerializedSizeOfKey(cell) + cell.getValueLength();
        if (withTags) {
            lenWritten += 2 + tagsLength;
        }
        return lenWritten;
    }

    public static void writeCellToBuffer(Cell cell, ByteBuffer buf, int offset) {
        if (cell instanceof ExtendedCell) {
            ((ExtendedCell)cell).write(buf, offset);
        } else {
            byte[] bytes = KeyValueUtil.copyToNewByteArray(cell);
            ByteBufferUtils.copyFromArrayToBuffer(buf, offset, bytes, 0, bytes.length);
        }
    }

    public static int writeFlatKey(Cell cell, OutputStream out) throws IOException {
        short rowLen = cell.getRowLength();
        byte fLen = cell.getFamilyLength();
        int qLen = cell.getQualifierLength();
        if (cell instanceof ByteBufferExtendedCell) {
            StreamUtils.writeShort(out, rowLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), (int)rowLen);
            out.write(fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), (int)fLen);
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), qLen);
        } else {
            StreamUtils.writeShort(out, rowLen);
            out.write(cell.getRowArray(), cell.getRowOffset(), rowLen);
            out.write(fLen);
            out.write(cell.getFamilyArray(), cell.getFamilyOffset(), fLen);
            out.write(cell.getQualifierArray(), cell.getQualifierOffset(), qLen);
        }
        StreamUtils.writeLong(out, cell.getTimestamp());
        out.write(cell.getTypeByte());
        return 2 + rowLen + 1 + fLen + qLen + 8 + 1;
    }

    public static void setSequenceId(Cell cell, long seqId) throws IOException {
        if (!(cell instanceof ExtendedCell)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + ExtendedCell.class.getName()));
        }
        ((ExtendedCell)cell).setSequenceId(seqId);
    }

    public static void setTimestamp(Cell cell, long ts) throws IOException {
        if (!(cell instanceof ExtendedCell)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + ExtendedCell.class.getName()));
        }
        ((ExtendedCell)cell).setTimestamp(ts);
    }

    public static void setTimestamp(Cell cell, byte[] ts) throws IOException {
        if (!(cell instanceof ExtendedCell)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + ExtendedCell.class.getName()));
        }
        ((ExtendedCell)cell).setTimestamp(ts);
    }

    public static boolean updateLatestStamp(Cell cell, long ts) throws IOException {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            PrivateCellUtil.setTimestamp(cell, ts);
            return true;
        }
        return false;
    }

    public static boolean updateLatestStamp(Cell cell, byte[] ts) throws IOException {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            PrivateCellUtil.setTimestamp(cell, ts);
            return true;
        }
        return false;
    }

    public static void writeRow(OutputStream out, Cell cell, short rlength) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), (int)rlength);
        } else {
            out.write(cell.getRowArray(), cell.getRowOffset(), rlength);
        }
    }

    public static void writeFamily(OutputStream out, Cell cell, byte flength) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), (int)flength);
        } else {
            out.write(cell.getFamilyArray(), cell.getFamilyOffset(), flength);
        }
    }

    public static void writeQualifier(OutputStream out, Cell cell, int qlength) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), qlength);
        } else {
            out.write(cell.getQualifierArray(), cell.getQualifierOffset(), qlength);
        }
    }

    public static void writeQualifierSkippingBytes(DataOutputStream out, Cell cell, int qlength, int commonPrefix) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition() + commonPrefix, qlength - commonPrefix);
        } else {
            out.write(cell.getQualifierArray(), cell.getQualifierOffset() + commonPrefix, qlength - commonPrefix);
        }
    }

    public static void writeValue(OutputStream out, Cell cell, int vlength) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getValueByteBuffer(), ((ByteBufferExtendedCell)cell).getValuePosition(), vlength);
        } else {
            out.write(cell.getValueArray(), cell.getValueOffset(), vlength);
        }
    }

    public static void writeTags(OutputStream out, Cell cell, int tagsLength) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferUtils.copyBufferToStream(out, ((ByteBufferExtendedCell)cell).getTagsByteBuffer(), ((ByteBufferExtendedCell)cell).getTagsPosition(), tagsLength);
        } else {
            out.write(cell.getTagsArray(), cell.getTagsOffset(), tagsLength);
        }
    }

    public static boolean equalsIgnoreMvccVersion(Cell a, Cell b) {
        boolean res = CellUtil.matchingRows(a, b);
        if (!res) {
            return res;
        }
        res = CellUtil.matchingColumn(a, b);
        if (!res) {
            return res;
        }
        if (!CellUtil.matchingTimestamp(a, b)) {
            return false;
        }
        int c = (0xFF & b.getTypeByte()) - (0xFF & a.getTypeByte());
        return c == 0;
    }

    public static int getRowAsInt(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.toInt(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition());
        }
        return Bytes.toInt(cell.getRowArray(), cell.getRowOffset());
    }

    public static long getValueAsLong(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.toLong(((ByteBufferExtendedCell)cell).getValueByteBuffer(), ((ByteBufferExtendedCell)cell).getValuePosition());
        }
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset());
    }

    public static int getValueAsInt(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.toInt(((ByteBufferExtendedCell)cell).getValueByteBuffer(), ((ByteBufferExtendedCell)cell).getValuePosition());
        }
        return Bytes.toInt(cell.getValueArray(), cell.getValueOffset());
    }

    public static double getValueAsDouble(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.toDouble(((ByteBufferExtendedCell)cell).getValueByteBuffer(), ((ByteBufferExtendedCell)cell).getValuePosition());
        }
        return Bytes.toDouble(cell.getValueArray(), cell.getValueOffset());
    }

    public static BigDecimal getValueAsBigDecimal(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return ByteBufferUtils.toBigDecimal(((ByteBufferExtendedCell)cell).getValueByteBuffer(), ((ByteBufferExtendedCell)cell).getValuePosition(), cell.getValueLength());
        }
        return Bytes.toBigDecimal(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static void compressTags(OutputStream out, Cell cell, TagCompressionContext tagCompressionContext) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            tagCompressionContext.compressTags(out, ((ByteBufferExtendedCell)cell).getTagsByteBuffer(), ((ByteBufferExtendedCell)cell).getTagsPosition(), cell.getTagsLength());
        } else {
            tagCompressionContext.compressTags(out, cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
        }
    }

    public static void compressRow(OutputStream out, Cell cell, Dictionary dict) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            Dictionary.write(out, ((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), (int)cell.getRowLength(), dict);
        } else {
            Dictionary.write(out, cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), dict);
        }
    }

    public static void compressFamily(OutputStream out, Cell cell, Dictionary dict) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            Dictionary.write(out, ((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), (int)cell.getFamilyLength(), dict);
        } else {
            Dictionary.write(out, cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), dict);
        }
    }

    public static void compressQualifier(OutputStream out, Cell cell, Dictionary dict) throws IOException {
        if (cell instanceof ByteBufferExtendedCell) {
            Dictionary.write(out, ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), cell.getQualifierLength(), dict);
        } else {
            Dictionary.write(out, cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), dict);
        }
    }

    public static final int compare(CellComparator comparator, Cell left, byte[] key, int offset, int length) {
        short rrowlength = Bytes.toShort(key, offset);
        int c = comparator.compareRows(left, key, offset + 2, rrowlength);
        if (c != 0) {
            return c;
        }
        return PrivateCellUtil.compareWithoutRow(comparator, left, key, offset, length, rrowlength);
    }

    static final int compareWithoutRow(CellComparator comparator, Cell left, byte[] right, int roffset, int rlength, short rowlength) {
        byte rfamilylength;
        boolean sameFamilySize;
        int commonLength = 3 + rowlength;
        int commonLengthWithTSAndType = 9 + commonLength;
        int lcolumnlength = left.getFamilyLength() + left.getQualifierLength();
        int rcolumnlength = rlength - commonLengthWithTSAndType;
        byte ltype = left.getTypeByte();
        byte rtype = right[roffset + (rlength - 1)];
        if (lcolumnlength == 0 && ltype == KeyValue.Type.Minimum.getCode()) {
            return 1;
        }
        if (rcolumnlength == 0 && rtype == KeyValue.Type.Minimum.getCode()) {
            return -1;
        }
        int rfamilyoffset = commonLength + roffset;
        byte lfamilylength = left.getFamilyLength();
        boolean bl = sameFamilySize = lfamilylength == (rfamilylength = right[rfamilyoffset - 1]);
        if (!sameFamilySize) {
            return CellUtil.compareFamilies(left, right, rfamilyoffset, rfamilylength);
        }
        int comparison = CellUtil.compareColumns(left, right, rfamilyoffset, rfamilylength, rfamilyoffset + rfamilylength, rcolumnlength - rfamilylength);
        if (comparison != 0) {
            return comparison;
        }
        long rtimestamp = Bytes.toLong(right, roffset + (rlength - 9));
        int compare = comparator.compareTimestamps(left.getTimestamp(), rtimestamp);
        if (compare != 0) {
            return compare;
        }
        return (0xFF & rtype) - (0xFF & ltype);
    }

    public static Cell createNextOnRowCol(Cell cell) {
        long ts = cell.getTimestamp();
        byte type = cell.getTypeByte();
        if (type != KeyValue.Type.Minimum.getCode()) {
            type = KeyValue.Type.values()[KeyValue.Type.codeToType(type).ordinal() - 1].getCode();
        } else if (ts != Long.MIN_VALUE) {
            --ts;
            type = KeyValue.Type.Maximum.getCode();
        } else {
            return cell;
        }
        return PrivateCellUtil.createNextOnRowCol(cell, ts, type);
    }

    static Cell createNextOnRowCol(Cell cell, final long ts, final byte type) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new LastOnRowColByteBufferExtendedCell(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), cell.getRowLength(), ((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), cell.getFamilyLength(), ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), cell.getQualifierLength()){

                @Override
                public long getTimestamp() {
                    return ts;
                }

                @Override
                public byte getTypeByte() {
                    return type;
                }
            };
        }
        return new LastOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()){

            @Override
            public long getTimestamp() {
                return ts;
            }

            @Override
            public byte getTypeByte() {
                return type;
            }
        };
    }

    public static int estimatedSerializedSizeOf(Cell cell) {
        return cell.getSerializedSize() + 4;
    }

    public static int estimatedSerializedSizeOfKey(Cell cell) {
        if (cell instanceof KeyValue) {
            return ((KeyValue)cell).getKeyLength();
        }
        return cell.getRowLength() + cell.getFamilyLength() + cell.getQualifierLength() + 12;
    }

    public static byte[] getCellKeySerializedAsKeyValueKey(Cell cell) {
        if (cell == null) {
            return null;
        }
        byte[] b = new byte[KeyValueUtil.keyLength(cell)];
        KeyValueUtil.appendKeyTo(cell, b, 0);
        return b;
    }

    public static Cell createFirstOnRow(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new FirstOnRowByteBufferExtendedCell(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), cell.getRowLength());
        }
        return new FirstOnRowCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static Cell createFirstOnRow(byte[] row, int roffset, short rlength) {
        return new FirstOnRowCell(row, roffset, rlength);
    }

    public static Cell createFirstOnRow(byte[] row, byte[] family, byte[] col) {
        return PrivateCellUtil.createFirstOnRow(row, 0, (short)row.length, family, 0, (byte)family.length, col, 0, col.length);
    }

    public static Cell createFirstOnRow(byte[] row, int roffset, short rlength, byte[] family, int foffset, byte flength, byte[] col, int coffset, int clength) {
        return new FirstOnRowColCell(row, roffset, rlength, family, foffset, flength, col, coffset, clength);
    }

    public static Cell createFirstOnRow(byte[] row) {
        return PrivateCellUtil.createFirstOnRow(row, 0, (short)row.length);
    }

    public static Cell createFirstOnRowFamily(Cell cell, byte[] fArray, int foff, int flen) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new FirstOnRowColByteBufferExtendedCell(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), cell.getRowLength(), ByteBuffer.wrap(fArray), foff, (byte)flen, HConstants.EMPTY_BYTE_BUFFER, 0, 0);
        }
        return new FirstOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), fArray, foff, (byte)flen, HConstants.EMPTY_BYTE_ARRAY, 0, 0);
    }

    public static Cell createFirstOnRowCol(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new FirstOnRowColByteBufferExtendedCell(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), cell.getRowLength(), HConstants.EMPTY_BYTE_BUFFER, 0, 0, ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), cell.getQualifierLength());
        }
        return new FirstOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), HConstants.EMPTY_BYTE_ARRAY, 0, 0, cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static Cell createFirstOnNextRow(Cell cell) {
        byte[] nextRow = new byte[cell.getRowLength() + 1];
        CellUtil.copyRowTo(cell, nextRow, 0);
        nextRow[nextRow.length - 1] = 0;
        return new FirstOnRowCell(nextRow, 0, (short)nextRow.length);
    }

    public static Cell createFirstOnRowCol(Cell cell, byte[] qArray, int qoffest, int qlength) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new FirstOnRowColByteBufferExtendedCell(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), cell.getRowLength(), ((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), cell.getFamilyLength(), ByteBuffer.wrap(qArray), qoffest, qlength);
        }
        return new FirstOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), qArray, qoffest, qlength);
    }

    public static Cell createFirstOnRowColTS(Cell cell, long ts) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new FirstOnRowColTSByteBufferExtendedCell(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), cell.getRowLength(), ((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), cell.getFamilyLength(), ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), cell.getQualifierLength(), ts);
        }
        return new FirstOnRowColTSCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), ts);
    }

    public static Cell createLastOnRow(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new LastOnRowByteBufferExtendedCell(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), cell.getRowLength());
        }
        return new LastOnRowCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static Cell createLastOnRow(byte[] row) {
        return new LastOnRowCell(row, 0, (short)row.length);
    }

    public static Cell createLastOnRowCol(Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            return new LastOnRowColByteBufferExtendedCell(((ByteBufferExtendedCell)cell).getRowByteBuffer(), ((ByteBufferExtendedCell)cell).getRowPosition(), cell.getRowLength(), ((ByteBufferExtendedCell)cell).getFamilyByteBuffer(), ((ByteBufferExtendedCell)cell).getFamilyPosition(), cell.getFamilyLength(), ((ByteBufferExtendedCell)cell).getQualifierByteBuffer(), ((ByteBufferExtendedCell)cell).getQualifierPosition(), cell.getQualifierLength());
        }
        return new LastOnRowColCell(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static Cell createFirstDeleteFamilyCellOnRow(byte[] row, byte[] fam) {
        return new FirstOnRowDeleteFamilyCell(row, fam);
    }

    private static class FirstOnRowDeleteFamilyCell
    extends EmptyCell {
        private static final int FIXED_OVERHEAD = ClassSize.OBJECT + ClassSize.REFERENCE * 2 + 12 + 1;
        private final byte[] row;
        private final byte[] fam;

        public FirstOnRowDeleteFamilyCell(byte[] row, byte[] fam) {
            this.row = row;
            this.fam = fam;
        }

        @Override
        public long heapSize() {
            return (long)ClassSize.align(FIXED_OVERHEAD) + (this.getRowLength() == 0 ? ClassSize.sizeOfByteArray(this.getRowLength()) : (long)this.getRowLength()) + (this.getFamilyLength() == 0 ? ClassSize.sizeOfByteArray(this.getFamilyLength()) : (long)this.getFamilyLength());
        }

        @Override
        public byte[] getRowArray() {
            return this.row;
        }

        @Override
        public short getRowLength() {
            return (short)this.row.length;
        }

        @Override
        public byte[] getFamilyArray() {
            return this.fam;
        }

        @Override
        public byte getFamilyLength() {
            return (byte)this.fam.length;
        }

        @Override
        public long getTimestamp() {
            return Long.MAX_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.DeleteFamily.getCode();
        }

        @Override
        public Cell.Type getType() {
            return Cell.Type.DeleteFamily;
        }
    }

    private static class LastOnRowColByteBufferExtendedCell
    extends LastOnRowByteBufferExtendedCell {
        private static final int FIXED_OVERHEAD = LastOnRowByteBufferExtendedCell.access$700() + ClassSize.REFERENCE * 2 + 12 + 1;
        private final ByteBuffer fBuffer;
        private final int foffset;
        private final byte flength;
        private final ByteBuffer qBuffer;
        private final int qoffset;
        private final int qlength;

        public LastOnRowColByteBufferExtendedCell(ByteBuffer rBuffer, int roffset, short rlength, ByteBuffer fBuffer, int foffset, byte flength, ByteBuffer qBuffer, int qoffset, int qlength) {
            super(rBuffer, roffset, rlength);
            this.fBuffer = fBuffer;
            this.foffset = foffset;
            this.flength = flength;
            this.qBuffer = qBuffer;
            this.qoffset = qoffset;
            this.qlength = qlength;
        }

        @Override
        public long heapSize() {
            if (this.fBuffer.hasArray() && this.qBuffer.hasArray()) {
                return ClassSize.align(FIXED_OVERHEAD + this.flength + this.qlength);
            }
            if (this.fBuffer.hasArray()) {
                return ClassSize.align(FIXED_OVERHEAD + this.flength);
            }
            if (this.qBuffer.hasArray()) {
                return ClassSize.align(FIXED_OVERHEAD + this.qlength);
            }
            return ClassSize.align(FIXED_OVERHEAD);
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return this.fBuffer;
        }

        @Override
        public int getFamilyPosition() {
            return this.foffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.flength;
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return this.qBuffer;
        }

        @Override
        public int getQualifierPosition() {
            return this.qoffset;
        }

        @Override
        public int getQualifierLength() {
            return this.qlength;
        }
    }

    private static class LastOnRowColCell
    extends LastOnRowCell {
        private static final long FIXED_OVERHEAD = LastOnRowCell.access$600() + ClassSize.REFERENCE * 2 + 12 + 1;
        private final byte[] fArray;
        private final int foffset;
        private final byte flength;
        private final byte[] qArray;
        private final int qoffset;
        private final int qlength;

        public LastOnRowColCell(byte[] rArray, int roffset, short rlength, byte[] fArray, int foffset, byte flength, byte[] qArray, int qoffset, int qlength) {
            super(rArray, roffset, rlength);
            this.fArray = fArray;
            this.foffset = foffset;
            this.flength = flength;
            this.qArray = qArray;
            this.qoffset = qoffset;
            this.qlength = qlength;
        }

        @Override
        public long heapSize() {
            return ClassSize.align(FIXED_OVERHEAD) + (this.flength == 0 ? ClassSize.sizeOfByteArray(this.flength) : (long)this.flength) + (this.qlength == 0 ? ClassSize.sizeOfByteArray(this.qlength) : (long)this.qlength);
        }

        @Override
        public byte[] getFamilyArray() {
            return this.fArray;
        }

        @Override
        public int getFamilyOffset() {
            return this.foffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.flength;
        }

        @Override
        public byte[] getQualifierArray() {
            return this.qArray;
        }

        @Override
        public int getQualifierOffset() {
            return this.qoffset;
        }

        @Override
        public int getQualifierLength() {
            return this.qlength;
        }
    }

    private static class LastOnRowCell
    extends EmptyCell {
        private static final int FIXED_OVERHEAD = ClassSize.OBJECT + ClassSize.REFERENCE + 4 + 2;
        private final byte[] rowArray;
        private final int roffset;
        private final short rlength;

        public LastOnRowCell(byte[] row, int roffset, short rlength) {
            this.rowArray = row;
            this.roffset = roffset;
            this.rlength = rlength;
        }

        @Override
        public long heapSize() {
            return (long)ClassSize.align(FIXED_OVERHEAD) + (this.rlength == 0 ? ClassSize.sizeOfByteArray(this.rlength) : (long)this.rlength);
        }

        @Override
        public byte[] getRowArray() {
            return this.rowArray;
        }

        @Override
        public int getRowOffset() {
            return this.roffset;
        }

        @Override
        public short getRowLength() {
            return this.rlength;
        }

        @Override
        public long getTimestamp() {
            return Long.MIN_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.Minimum.getCode();
        }

        @Override
        public Cell.Type getType() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ int access$600() {
            return FIXED_OVERHEAD;
        }
    }

    private static class FirstOnRowColTSByteBufferExtendedCell
    extends FirstOnRowColByteBufferExtendedCell {
        private static final int FIXED_OVERHEAD = FirstOnRowColByteBufferExtendedCell.access$500() + 8;
        private long ts;

        public FirstOnRowColTSByteBufferExtendedCell(ByteBuffer rBuffer, int roffset, short rlength, ByteBuffer fBuffer, int foffset, byte flength, ByteBuffer qBuffer, int qoffset, int qlength, long ts) {
            super(rBuffer, roffset, rlength, fBuffer, foffset, flength, qBuffer, qoffset, qlength);
            this.ts = ts;
        }

        @Override
        public long getTimestamp() {
            return this.ts;
        }

        @Override
        public long heapSize() {
            return ClassSize.align((long)FIXED_OVERHEAD + super.heapSize());
        }
    }

    private static class FirstOnRowColTSCell
    extends FirstOnRowColCell {
        private static final long FIXED_HEAPSIZE = FirstOnRowColCell.access$400() + 8L;
        private long ts;

        public FirstOnRowColTSCell(byte[] rArray, int roffset, short rlength, byte[] fArray, int foffset, byte flength, byte[] qArray, int qoffset, int qlength, long ts) {
            super(rArray, roffset, rlength, fArray, foffset, flength, qArray, qoffset, qlength);
            this.ts = ts;
        }

        @Override
        public long getTimestamp() {
            return this.ts;
        }

        @Override
        public long heapSize() {
            return ClassSize.align(FIXED_HEAPSIZE);
        }
    }

    private static class FirstOnRowColCell
    extends FirstOnRowCell {
        private static final long FIXED_HEAPSIZE = FirstOnRowCell.access$300() + 1 + 12 + ClassSize.REFERENCE * 2;
        private final byte[] fArray;
        private final int foffset;
        private final byte flength;
        private final byte[] qArray;
        private final int qoffset;
        private final int qlength;

        public FirstOnRowColCell(byte[] rArray, int roffset, short rlength, byte[] fArray, int foffset, byte flength, byte[] qArray, int qoffset, int qlength) {
            super(rArray, roffset, rlength);
            this.fArray = fArray;
            this.foffset = foffset;
            this.flength = flength;
            this.qArray = qArray;
            this.qoffset = qoffset;
            this.qlength = qlength;
        }

        @Override
        public long heapSize() {
            return ClassSize.align(FIXED_HEAPSIZE) + (this.flength == 0 ? ClassSize.sizeOfByteArray(this.flength) : (long)this.flength) + (this.qlength == 0 ? ClassSize.sizeOfByteArray(this.qlength) : (long)this.qlength);
        }

        @Override
        public byte[] getFamilyArray() {
            return this.fArray;
        }

        @Override
        public int getFamilyOffset() {
            return this.foffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.flength;
        }

        @Override
        public byte[] getQualifierArray() {
            return this.qArray;
        }

        @Override
        public int getQualifierOffset() {
            return this.qoffset;
        }

        @Override
        public int getQualifierLength() {
            return this.qlength;
        }

        static /* synthetic */ long access$400() {
            return FIXED_HEAPSIZE;
        }
    }

    private static class FirstOnRowColByteBufferExtendedCell
    extends FirstOnRowByteBufferExtendedCell {
        private static final int FIXED_OVERHEAD = FirstOnRowByteBufferExtendedCell.access$200() + ClassSize.REFERENCE * 2 + 12 + 1;
        private final ByteBuffer famBuff;
        private final int famOffset;
        private final byte famLength;
        private final ByteBuffer colBuff;
        private final int colOffset;
        private final int colLength;

        public FirstOnRowColByteBufferExtendedCell(ByteBuffer row, int roffset, short rlength, ByteBuffer famBuff, int famOffset, byte famLength, ByteBuffer col, int colOffset, int colLength) {
            super(row, roffset, rlength);
            this.famBuff = famBuff;
            this.famOffset = famOffset;
            this.famLength = famLength;
            this.colBuff = col;
            this.colOffset = colOffset;
            this.colLength = colLength;
        }

        @Override
        public long heapSize() {
            if (this.famBuff.hasArray() && this.colBuff.hasArray()) {
                return ClassSize.align(FIXED_OVERHEAD + this.famLength + this.colLength);
            }
            if (this.famBuff.hasArray()) {
                return ClassSize.align(FIXED_OVERHEAD + this.famLength);
            }
            if (this.colBuff.hasArray()) {
                return ClassSize.align(FIXED_OVERHEAD + this.colLength);
            }
            return ClassSize.align(FIXED_OVERHEAD);
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return this.famBuff;
        }

        @Override
        public int getFamilyPosition() {
            return this.famOffset;
        }

        @Override
        public byte getFamilyLength() {
            return this.famLength;
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return this.colBuff;
        }

        @Override
        public int getQualifierPosition() {
            return this.colOffset;
        }

        @Override
        public int getQualifierLength() {
            return this.colLength;
        }

        static /* synthetic */ int access$500() {
            return FIXED_OVERHEAD;
        }
    }

    private static class LastOnRowByteBufferExtendedCell
    extends EmptyByteBufferExtendedCell {
        private static final int FIXED_OVERHEAD = ClassSize.OBJECT + ClassSize.REFERENCE + 4 + 2;
        private final ByteBuffer rowBuff;
        private final int roffset;
        private final short rlength;

        public LastOnRowByteBufferExtendedCell(ByteBuffer row, int roffset, short rlength) {
            this.rowBuff = row;
            this.roffset = roffset;
            this.rlength = rlength;
        }

        @Override
        public long heapSize() {
            if (this.rowBuff.hasArray()) {
                return ClassSize.align(FIXED_OVERHEAD + this.rlength);
            }
            return ClassSize.align(FIXED_OVERHEAD);
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return this.rowBuff;
        }

        @Override
        public int getRowPosition() {
            return this.roffset;
        }

        @Override
        public short getRowLength() {
            return this.rlength;
        }

        @Override
        public long getTimestamp() {
            return Long.MIN_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.Minimum.getCode();
        }

        @Override
        public Cell.Type getType() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ int access$700() {
            return FIXED_OVERHEAD;
        }
    }

    private static class FirstOnRowByteBufferExtendedCell
    extends EmptyByteBufferExtendedCell {
        private static final int FIXED_OVERHEAD = ClassSize.OBJECT + ClassSize.REFERENCE + 4 + 2;
        private final ByteBuffer rowBuff;
        private final int roffset;
        private final short rlength;

        public FirstOnRowByteBufferExtendedCell(ByteBuffer row, int roffset, short rlength) {
            this.rowBuff = row;
            this.roffset = roffset;
            this.rlength = rlength;
        }

        @Override
        public long heapSize() {
            if (this.rowBuff.hasArray()) {
                return ClassSize.align(FIXED_OVERHEAD + this.rlength);
            }
            return ClassSize.align(FIXED_OVERHEAD);
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return this.rowBuff;
        }

        @Override
        public int getRowPosition() {
            return this.roffset;
        }

        @Override
        public short getRowLength() {
            return this.rlength;
        }

        @Override
        public long getTimestamp() {
            return Long.MAX_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.Maximum.getCode();
        }

        @Override
        public Cell.Type getType() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ int access$200() {
            return FIXED_OVERHEAD;
        }
    }

    private static class FirstOnRowCell
    extends EmptyCell {
        private static final int FIXED_HEAPSIZE = ClassSize.OBJECT + ClassSize.REFERENCE + 4 + 2;
        private final byte[] rowArray;
        private final int roffset;
        private final short rlength;

        public FirstOnRowCell(byte[] row, int roffset, short rlength) {
            this.rowArray = row;
            this.roffset = roffset;
            this.rlength = rlength;
        }

        @Override
        public long heapSize() {
            return (long)ClassSize.align(FIXED_HEAPSIZE) + (this.rlength == 0 ? ClassSize.sizeOfByteArray(this.rlength) : (long)this.rlength);
        }

        @Override
        public byte[] getRowArray() {
            return this.rowArray;
        }

        @Override
        public int getRowOffset() {
            return this.roffset;
        }

        @Override
        public short getRowLength() {
            return this.rlength;
        }

        @Override
        public long getTimestamp() {
            return Long.MAX_VALUE;
        }

        @Override
        public byte getTypeByte() {
            return KeyValue.Type.Maximum.getCode();
        }

        @Override
        public Cell.Type getType() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ int access$300() {
            return FIXED_HEAPSIZE;
        }
    }

    private static abstract class EmptyByteBufferExtendedCell
    extends ByteBufferExtendedCell {
        private EmptyByteBufferExtendedCell() {
        }

        @Override
        public void setSequenceId(long seqId) {
        }

        @Override
        public void setTimestamp(long ts) {
        }

        @Override
        public void setTimestamp(byte[] ts) {
        }

        @Override
        public byte[] getRowArray() {
            return CellUtil.cloneRow(this);
        }

        @Override
        public int getRowOffset() {
            return 0;
        }

        @Override
        public short getRowLength() {
            return 0;
        }

        @Override
        public byte[] getFamilyArray() {
            return CellUtil.cloneFamily(this);
        }

        @Override
        public int getFamilyOffset() {
            return 0;
        }

        @Override
        public byte getFamilyLength() {
            return 0;
        }

        @Override
        public byte[] getQualifierArray() {
            return CellUtil.cloneQualifier(this);
        }

        @Override
        public int getQualifierOffset() {
            return 0;
        }

        @Override
        public int getQualifierLength() {
            return 0;
        }

        @Override
        public long getSequenceId() {
            return 0L;
        }

        @Override
        public byte[] getValueArray() {
            return CellUtil.cloneValue(this);
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return 0;
        }

        @Override
        public byte[] getTagsArray() {
            return CellUtil.cloneTags(this);
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            return 0;
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getRowPosition() {
            return 0;
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getFamilyPosition() {
            return 0;
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getQualifierPosition() {
            return 0;
        }

        @Override
        public ByteBuffer getTagsByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getTagsPosition() {
            return 0;
        }

        @Override
        public ByteBuffer getValueByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getValuePosition() {
            return 0;
        }
    }

    private static abstract class EmptyCell
    implements ExtendedCell {
        private EmptyCell() {
        }

        @Override
        public void setSequenceId(long seqId) {
        }

        @Override
        public void setTimestamp(long ts) {
        }

        @Override
        public void setTimestamp(byte[] ts) {
        }

        @Override
        public byte[] getRowArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getRowOffset() {
            return 0;
        }

        @Override
        public short getRowLength() {
            return 0;
        }

        @Override
        public byte[] getFamilyArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getFamilyOffset() {
            return 0;
        }

        @Override
        public byte getFamilyLength() {
            return 0;
        }

        @Override
        public byte[] getQualifierArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getQualifierOffset() {
            return 0;
        }

        @Override
        public int getQualifierLength() {
            return 0;
        }

        @Override
        public long getSequenceId() {
            return 0L;
        }

        @Override
        public byte[] getValueArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return 0;
        }

        @Override
        public byte[] getTagsArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            return 0;
        }
    }

    static class ValueAndTagRewriteByteBufferExtendedCell
    extends TagRewriteByteBufferExtendedCell {
        protected byte[] value;

        public ValueAndTagRewriteByteBufferExtendedCell(ByteBufferExtendedCell cell, byte[] value, byte[] tags) {
            super(cell, tags);
            this.value = value;
        }

        @Override
        public byte[] getValueArray() {
            return this.value;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return this.value == null ? 0 : this.value.length;
        }

        @Override
        public ByteBuffer getValueByteBuffer() {
            return ByteBuffer.wrap(this.value);
        }

        @Override
        public int getValuePosition() {
            return 0;
        }

        @Override
        public long heapSize() {
            long sum = (long)ClassSize.REFERENCE + super.heapSize();
            if (this.value != null) {
                sum += ClassSize.sizeOf(this.value);
            }
            return sum;
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            return ValueAndTagRewriteCell.write(out, withTags, (Cell)this.cell, this.value, this.tags);
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            return super.getSerializedSize(withTags) - this.cell.getValueLength() + this.value.length;
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            ValueAndTagRewriteCell.write(buf, offset, (Cell)this.cell, this.value, this.tags);
        }

        @Override
        public ExtendedCell deepClone() {
            ExtendedCell clonedBaseCell = this.cell.deepClone();
            if (clonedBaseCell instanceof ByteBufferExtendedCell) {
                return new ValueAndTagRewriteByteBufferExtendedCell((ByteBufferExtendedCell)clonedBaseCell, this.value, this.tags);
            }
            return new ValueAndTagRewriteCell(clonedBaseCell, this.value, this.tags);
        }
    }

    static class ValueAndTagRewriteCell
    extends TagRewriteCell {
        protected byte[] value;

        public ValueAndTagRewriteCell(Cell cell, byte[] value, byte[] tags) {
            super(cell, tags);
            this.value = value;
        }

        @Override
        public byte[] getValueArray() {
            return this.value;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return this.value == null ? 0 : this.value.length;
        }

        @Override
        public long heapSize() {
            long sum = (long)ClassSize.REFERENCE + super.heapSize();
            if (this.value != null) {
                sum += ClassSize.sizeOf(this.value);
            }
            return sum;
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            return ValueAndTagRewriteCell.write(out, withTags, this.cell, this.value, this.tags);
        }

        static int write(OutputStream out, boolean withTags, Cell cell, byte[] value, byte[] tags) throws IOException {
            int valLen = value == null ? 0 : value.length;
            ByteBufferUtils.putInt(out, KeyValueUtil.keyLength(cell));
            ByteBufferUtils.putInt(out, valLen);
            int len = 8;
            len += PrivateCellUtil.writeFlatKey(cell, out);
            if (valLen > 0) {
                out.write(value);
            }
            len += valLen;
            if (withTags && tags != null) {
                out.write((byte)(0xFF & tags.length >> 8));
                out.write((byte)(0xFF & tags.length));
                out.write(tags);
                len += 2 + tags.length;
            }
            return len;
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            return super.getSerializedSize(withTags) - this.cell.getValueLength() + this.value.length;
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            ValueAndTagRewriteCell.write(buf, offset, this.cell, this.value, this.tags);
        }

        static void write(ByteBuffer buf, int offset, Cell cell, byte[] value, byte[] tags) {
            int tagsLen;
            offset = ByteBufferUtils.putInt(buf, offset, KeyValueUtil.keyLength(cell));
            offset = ByteBufferUtils.putInt(buf, offset, value.length);
            offset = KeyValueUtil.appendKeyTo(cell, buf, offset);
            ByteBufferUtils.copyFromArrayToBuffer(buf, offset, value, 0, value.length);
            offset += value.length;
            int n = tagsLen = tags == null ? 0 : tags.length;
            if (tagsLen > 0) {
                offset = ByteBufferUtils.putAsShort(buf, offset, tagsLen);
                ByteBufferUtils.copyFromArrayToBuffer(buf, offset, tags, 0, tagsLen);
            }
        }

        @Override
        public ExtendedCell deepClone() {
            ExtendedCell clonedBaseCell = ((ExtendedCell)this.cell).deepClone();
            return new ValueAndTagRewriteCell(clonedBaseCell, this.value, this.tags);
        }
    }

    static class TagRewriteByteBufferExtendedCell
    extends ByteBufferExtendedCell {
        protected ByteBufferExtendedCell cell;
        protected byte[] tags;
        private static final int HEAP_SIZE_OVERHEAD = ClassSize.OBJECT + 2 * ClassSize.REFERENCE;

        public TagRewriteByteBufferExtendedCell(ByteBufferExtendedCell cell, byte[] tags) {
            assert (tags != null);
            this.cell = cell;
            this.tags = tags;
            if (this.cell instanceof TagRewriteByteBufferExtendedCell) {
                ((TagRewriteByteBufferExtendedCell)this.cell).tags = null;
            }
        }

        @Override
        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        @Override
        public short getRowLength() {
            return this.cell.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        @Override
        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        @Override
        public long getSequenceId() {
            return this.cell.getSequenceId();
        }

        @Override
        public byte[] getValueArray() {
            return this.cell.getValueArray();
        }

        @Override
        public int getValueOffset() {
            return this.cell.getValueOffset();
        }

        @Override
        public int getValueLength() {
            return this.cell.getValueLength();
        }

        @Override
        public byte[] getTagsArray() {
            return this.tags;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            if (null == this.tags) {
                return 0;
            }
            return this.tags.length;
        }

        @Override
        public void setSequenceId(long seqId) throws IOException {
            PrivateCellUtil.setSequenceId(this.cell, seqId);
        }

        @Override
        public void setTimestamp(long ts) throws IOException {
            PrivateCellUtil.setTimestamp((Cell)this.cell, ts);
        }

        @Override
        public void setTimestamp(byte[] ts) throws IOException {
            PrivateCellUtil.setTimestamp((Cell)this.cell, ts);
        }

        @Override
        public long heapSize() {
            long sum = (long)HEAP_SIZE_OVERHEAD + this.cell.heapSize();
            if (this.tags != null) {
                sum += ClassSize.sizeOf(this.tags);
            }
            return sum;
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            int len = this.cell.write(out, false);
            if (withTags && this.tags != null) {
                out.write((byte)(0xFF & this.tags.length >> 8));
                out.write((byte)(0xFF & this.tags.length));
                out.write(this.tags);
                len += 2 + this.tags.length;
            }
            return len;
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            int len = this.cell.getSerializedSize(false);
            if (withTags && this.tags != null) {
                len += 2 + this.tags.length;
            }
            return len;
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            int tagsLen;
            offset = KeyValueUtil.appendTo(this.cell, buf, offset, false);
            int n = tagsLen = this.tags == null ? 0 : this.tags.length;
            if (tagsLen > 0) {
                offset = ByteBufferUtils.putAsShort(buf, offset, tagsLen);
                ByteBufferUtils.copyFromArrayToBuffer(buf, offset, this.tags, 0, tagsLen);
            }
        }

        @Override
        public ExtendedCell deepClone() {
            ExtendedCell clonedBaseCell = this.cell.deepClone();
            if (clonedBaseCell instanceof ByteBufferExtendedCell) {
                return new TagRewriteByteBufferExtendedCell((ByteBufferExtendedCell)clonedBaseCell, this.tags);
            }
            return new TagRewriteCell(clonedBaseCell, this.tags);
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return this.cell.getRowByteBuffer();
        }

        @Override
        public int getRowPosition() {
            return this.cell.getRowPosition();
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return this.cell.getFamilyByteBuffer();
        }

        @Override
        public int getFamilyPosition() {
            return this.cell.getFamilyPosition();
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return this.cell.getQualifierByteBuffer();
        }

        @Override
        public int getQualifierPosition() {
            return this.cell.getQualifierPosition();
        }

        @Override
        public ByteBuffer getValueByteBuffer() {
            return this.cell.getValueByteBuffer();
        }

        @Override
        public int getValuePosition() {
            return this.cell.getValuePosition();
        }

        @Override
        public ByteBuffer getTagsByteBuffer() {
            return this.tags == null ? HConstants.EMPTY_BYTE_BUFFER : ByteBuffer.wrap(this.tags);
        }

        @Override
        public int getTagsPosition() {
            return 0;
        }
    }

    static class TagRewriteCell
    implements ExtendedCell {
        protected Cell cell;
        protected byte[] tags;
        private static final int HEAP_SIZE_OVERHEAD = ClassSize.OBJECT + 2 * ClassSize.REFERENCE;

        public TagRewriteCell(Cell cell, byte[] tags) {
            assert (cell instanceof ExtendedCell);
            assert (tags != null);
            this.cell = cell;
            this.tags = tags;
            if (this.cell instanceof TagRewriteCell) {
                ((TagRewriteCell)this.cell).tags = null;
            }
        }

        @Override
        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        @Override
        public short getRowLength() {
            return this.cell.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        @Override
        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        @Override
        public long getSequenceId() {
            return this.cell.getSequenceId();
        }

        @Override
        public byte[] getValueArray() {
            return this.cell.getValueArray();
        }

        @Override
        public int getValueOffset() {
            return this.cell.getValueOffset();
        }

        @Override
        public int getValueLength() {
            return this.cell.getValueLength();
        }

        @Override
        public byte[] getTagsArray() {
            return this.tags;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            if (null == this.tags) {
                return 0;
            }
            return this.tags.length;
        }

        @Override
        public long heapSize() {
            long sum = (long)HEAP_SIZE_OVERHEAD + this.cell.heapSize();
            if (this.tags != null) {
                sum += ClassSize.sizeOf(this.tags);
            }
            return sum;
        }

        @Override
        public void setTimestamp(long ts) throws IOException {
            PrivateCellUtil.setTimestamp(this.cell, ts);
        }

        @Override
        public void setTimestamp(byte[] ts) throws IOException {
            PrivateCellUtil.setTimestamp(this.cell, ts);
        }

        @Override
        public void setSequenceId(long seqId) throws IOException {
            PrivateCellUtil.setSequenceId(this.cell, seqId);
        }

        @Override
        public int write(OutputStream out, boolean withTags) throws IOException {
            int len = ((ExtendedCell)this.cell).write(out, false);
            if (withTags && this.tags != null) {
                out.write((byte)(0xFF & this.tags.length >> 8));
                out.write((byte)(0xFF & this.tags.length));
                out.write(this.tags);
                len += 2 + this.tags.length;
            }
            return len;
        }

        @Override
        public int getSerializedSize(boolean withTags) {
            int len = ((ExtendedCell)this.cell).getSerializedSize(false);
            if (withTags && this.tags != null) {
                len += 2 + this.tags.length;
            }
            return len;
        }

        @Override
        public void write(ByteBuffer buf, int offset) {
            int tagsLen;
            offset = KeyValueUtil.appendTo(this.cell, buf, offset, false);
            int n = tagsLen = this.tags == null ? 0 : this.tags.length;
            if (tagsLen > 0) {
                offset = ByteBufferUtils.putAsShort(buf, offset, tagsLen);
                ByteBufferUtils.copyFromArrayToBuffer(buf, offset, this.tags, 0, tagsLen);
            }
        }

        @Override
        public ExtendedCell deepClone() {
            ExtendedCell clonedBaseCell = ((ExtendedCell)this.cell).deepClone();
            return new TagRewriteCell(clonedBaseCell, this.tags);
        }
    }
}

