/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.NamespaceDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.Connection;
import io.hops.hudi.org.apache.hadoop.hbase.client.Get;
import io.hops.hudi.org.apache.hadoop.hbase.client.Result;
import io.hops.hudi.org.apache.hadoop.hbase.client.Scan;
import io.hops.hudi.org.apache.hadoop.hbase.client.Table;
import io.hops.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import io.hops.hudi.org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RSGroupTableAccessor {
    private static final TableName RSGROUP_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "rsgroup");
    private static final byte[] META_FAMILY_BYTES = Bytes.toBytes("m");
    private static final byte[] META_QUALIFIER_BYTES = Bytes.toBytes("i");

    private RSGroupTableAccessor() {
    }

    public static boolean isRSGroupsEnabled(Connection connection) throws IOException {
        return connection.getAdmin().tableExists(RSGROUP_TABLE_NAME);
    }

    public static List<RSGroupInfo> getAllRSGroupInfo(Connection connection) throws IOException {
        try (Table rsGroupTable = connection.getTable(RSGROUP_TABLE_NAME);){
            ArrayList<RSGroupInfo> rsGroupInfos = new ArrayList<RSGroupInfo>();
            for (Result result : rsGroupTable.getScanner(new Scan())) {
                RSGroupInfo rsGroupInfo = RSGroupTableAccessor.getRSGroupInfo(result);
                if (rsGroupInfo == null) continue;
                rsGroupInfos.add(rsGroupInfo);
            }
            ArrayList<RSGroupInfo> arrayList = rsGroupInfos;
            return arrayList;
        }
    }

    private static RSGroupInfo getRSGroupInfo(Result result) throws IOException {
        byte[] rsGroupInfo = result.getValue(META_FAMILY_BYTES, META_QUALIFIER_BYTES);
        if (rsGroupInfo == null) {
            return null;
        }
        RSGroupProtos.RSGroupInfo proto = RSGroupProtos.RSGroupInfo.parseFrom(rsGroupInfo);
        return ProtobufUtil.toGroupInfo(proto);
    }

    public static RSGroupInfo getRSGroupInfo(Connection connection, byte[] rsGroupName) throws IOException {
        try (Table rsGroupTable = connection.getTable(RSGROUP_TABLE_NAME);){
            Result result = rsGroupTable.get(new Get(rsGroupName));
            RSGroupInfo rSGroupInfo = RSGroupTableAccessor.getRSGroupInfo(result);
            return rSGroupInfo;
        }
    }
}

