/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.HRegionLocation;
import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionLocations
implements Iterable<HRegionLocation> {
    private final int numNonNullElements;
    private final HRegionLocation[] locations;

    public RegionLocations(HRegionLocation ... locations) {
        int numNonNullElements = 0;
        int maxReplicaId = -1;
        int maxReplicaIdIndex = -1;
        int index = 0;
        for (HRegionLocation loc : locations) {
            if (loc != null && loc.getRegion().getReplicaId() >= maxReplicaId) {
                maxReplicaId = loc.getRegion().getReplicaId();
                maxReplicaIdIndex = index;
            }
            ++index;
        }
        if ((maxReplicaId += locations.length - (maxReplicaIdIndex + 1)) + 1 == locations.length) {
            this.locations = locations;
        } else {
            this.locations = new HRegionLocation[maxReplicaId + 1];
            for (HRegionLocation loc : locations) {
                if (loc == null) continue;
                this.locations[loc.getRegion().getReplicaId()] = loc;
            }
        }
        for (HRegionLocation loc : this.locations) {
            if (loc == null || loc.getServerName() == null) continue;
            ++numNonNullElements;
        }
        this.numNonNullElements = numNonNullElements;
    }

    public RegionLocations(Collection<HRegionLocation> locations) {
        this(locations.toArray(new HRegionLocation[locations.size()]));
    }

    public int size() {
        return this.locations.length;
    }

    public int numNonNullElements() {
        return this.numNonNullElements;
    }

    public boolean isEmpty() {
        return this.numNonNullElements == 0;
    }

    public RegionLocations removeByServer(ServerName serverName) {
        HRegionLocation[] newLocations = null;
        for (int i = 0; i < this.locations.length; ++i) {
            if (this.locations[i] != null && serverName.equals(this.locations[i].getServerName())) {
                if (newLocations == null) {
                    newLocations = new HRegionLocation[this.locations.length];
                    System.arraycopy(this.locations, 0, newLocations, 0, i);
                }
                newLocations[i] = null;
                continue;
            }
            if (newLocations == null) continue;
            newLocations[i] = this.locations[i];
        }
        return newLocations == null ? this : new RegionLocations(newLocations);
    }

    public RegionLocations remove(HRegionLocation location) {
        if (location == null) {
            return this;
        }
        if (location.getRegion() == null) {
            return this;
        }
        int replicaId = location.getRegion().getReplicaId();
        if (replicaId >= this.locations.length) {
            return this;
        }
        if (this.locations[replicaId] == null || RegionInfo.COMPARATOR.compare(location.getRegion(), this.locations[replicaId].getRegion()) != 0 || !location.equals(this.locations[replicaId])) {
            return this;
        }
        HRegionLocation[] newLocations = new HRegionLocation[this.locations.length];
        System.arraycopy(this.locations, 0, newLocations, 0, this.locations.length);
        newLocations[replicaId] = null;
        return new RegionLocations(newLocations);
    }

    public RegionLocations remove(int replicaId) {
        if (this.getRegionLocation(replicaId) == null) {
            return this;
        }
        HRegionLocation[] newLocations = new HRegionLocation[this.locations.length];
        System.arraycopy(this.locations, 0, newLocations, 0, this.locations.length);
        if (replicaId < newLocations.length) {
            newLocations[replicaId] = null;
        }
        return new RegionLocations(newLocations);
    }

    public RegionLocations removeElementsWithNullLocation() {
        HRegionLocation[] newLocations = new HRegionLocation[this.locations.length];
        boolean hasNonNullElement = false;
        for (int i = 0; i < this.locations.length; ++i) {
            if (this.locations[i] == null || this.locations[i].getServerName() == null) continue;
            hasNonNullElement = true;
            newLocations[i] = this.locations[i];
        }
        return hasNonNullElement ? new RegionLocations(newLocations) : null;
    }

    public RegionLocations mergeLocations(RegionLocations other) {
        int i;
        assert (other != null);
        HRegionLocation[] newLocations = null;
        int max = other.locations.length;
        RegionInfo regionInfo = null;
        for (i = 0; i < max; ++i) {
            HRegionLocation selectedLoc;
            HRegionLocation thisLoc = this.getRegionLocation(i);
            HRegionLocation otherLoc = other.getRegionLocation(i);
            if (regionInfo == null && otherLoc != null && otherLoc.getRegion() != null) {
                regionInfo = otherLoc.getRegion();
            }
            if ((selectedLoc = this.selectRegionLocation(thisLoc, otherLoc, true, false)) != thisLoc && newLocations == null) {
                newLocations = new HRegionLocation[max];
                System.arraycopy(this.locations, 0, newLocations, 0, i);
            }
            if (newLocations == null) continue;
            newLocations[i] = selectedLoc;
        }
        if (newLocations != null && regionInfo != null) {
            for (i = 0; i < newLocations.length; ++i) {
                if (newLocations[i] == null || RegionReplicaUtil.isReplicasForSameRegion(regionInfo, newLocations[i].getRegion())) continue;
                newLocations[i] = null;
            }
        }
        return newLocations == null ? this : new RegionLocations(newLocations);
    }

    private HRegionLocation selectRegionLocation(HRegionLocation oldLocation, HRegionLocation location, boolean checkForEquals, boolean force) {
        if (location == null) {
            return oldLocation == null ? null : oldLocation;
        }
        if (oldLocation == null) {
            return location;
        }
        if (force || this.isGreaterThan(location.getSeqNum(), oldLocation.getSeqNum(), checkForEquals)) {
            return location;
        }
        return oldLocation;
    }

    public RegionLocations updateLocation(HRegionLocation location, boolean checkForEquals, boolean force) {
        assert (location != null);
        int replicaId = location.getRegion().getReplicaId();
        HRegionLocation oldLoc = this.getRegionLocation(location.getRegion().getReplicaId());
        HRegionLocation selectedLoc = this.selectRegionLocation(oldLoc, location, checkForEquals, force);
        if (selectedLoc == oldLoc) {
            return this;
        }
        HRegionLocation[] newLocations = new HRegionLocation[Math.max(this.locations.length, replicaId + 1)];
        System.arraycopy(this.locations, 0, newLocations, 0, this.locations.length);
        newLocations[replicaId] = location;
        for (int i = 0; i < newLocations.length; ++i) {
            if (newLocations[i] == null || RegionReplicaUtil.isReplicasForSameRegion(location.getRegion(), newLocations[i].getRegion())) continue;
            newLocations[i] = null;
        }
        return new RegionLocations(newLocations);
    }

    private boolean isGreaterThan(long a, long b, boolean checkForEquals) {
        return a > b || checkForEquals && a == b;
    }

    public HRegionLocation getRegionLocation(int replicaId) {
        if (replicaId >= this.locations.length) {
            return null;
        }
        return this.locations[replicaId];
    }

    public HRegionLocation getRegionLocationByRegionName(byte[] regionName) {
        for (HRegionLocation loc : this.locations) {
            if (loc == null || !Bytes.equals(loc.getRegion().getRegionName(), regionName) && !Bytes.equals(loc.getRegion().getEncodedNameAsBytes(), regionName)) continue;
            return loc;
        }
        return null;
    }

    public HRegionLocation[] getRegionLocations() {
        return this.locations;
    }

    public HRegionLocation getDefaultRegionLocation() {
        return this.locations[0];
    }

    public HRegionLocation getRegionLocation() {
        for (HRegionLocation loc : this.locations) {
            if (loc == null) continue;
            return loc;
        }
        return null;
    }

    @Override
    public Iterator<HRegionLocation> iterator() {
        return Arrays.asList(this.locations).iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (HRegionLocation loc : this.locations) {
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append(loc == null ? "null" : loc);
        }
        builder.append("]");
        return builder.toString();
    }
}

