/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.backup.example;

import io.hops.hudi.org.apache.hadoop.hbase.backup.example.TableHFileArchiveTracker;
import io.hops.hudi.org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import io.hops.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class LongTermArchivingHFileCleaner
extends BaseHFileCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(LongTermArchivingHFileCleaner.class);
    TableHFileArchiveTracker archiveTracker;
    private FileSystem fs;

    @Override
    public boolean isFileDeletable(FileStatus fStat) {
        try {
            if (fStat.isDirectory()) {
                return true;
            }
            Path file = fStat.getPath();
            FileStatus[] deleteStatus = CommonFSUtils.listStatus(this.fs, file, null);
            if (deleteStatus == null) {
                return true;
            }
            Path family = file.getParent();
            Path region = family.getParent();
            Path table = region.getParent();
            String tableName = table.getName();
            boolean ret = !this.archiveTracker.keepHFiles(tableName);
            LOG.debug("Archiver says to [" + (ret ? "delete" : "keep") + "] files for table:" + tableName);
            return ret;
        }
        catch (IOException e) {
            LOG.error("Failed to lookup status of:" + fStat.getPath() + ", keeping it just incase.", (Throwable)e);
            return false;
        }
    }

    @Override
    public void setConf(Configuration config) {
        Configuration conf = new Configuration(config);
        super.setConf(conf);
        try {
            this.fs = FileSystem.get((Configuration)conf);
            this.archiveTracker = TableHFileArchiveTracker.create(conf);
            this.archiveTracker.start();
        }
        catch (KeeperException e) {
            LOG.error("Error while configuring " + this.getClass().getName(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error while configuring " + this.getClass().getName(), (Throwable)e);
        }
    }

    @Override
    public void stop(String reason) {
        if (this.isStopped()) {
            return;
        }
        super.stop(reason);
        if (this.archiveTracker != null) {
            LOG.info("Stopping " + (Object)((Object)this.archiveTracker));
            this.archiveTracker.stop();
        }
    }
}

