/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.Mutation;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface AsyncBufferedMutator
extends Closeable {
    public TableName getName();

    public Configuration getConfiguration();

    default public CompletableFuture<Void> mutate(Mutation mutation) {
        return Iterables.getOnlyElement(this.mutate(Collections.singletonList(mutation)));
    }

    public List<CompletableFuture<Void>> mutate(List<? extends Mutation> var1);

    public void flush();

    @Override
    public void close();

    public long getWriteBufferSize();

    default public long getPeriodicalFlushTimeout(TimeUnit unit) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

