/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.filter;

import io.hops.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import io.hops.hudi.org.apache.hadoop.hbase.filter.ByteArrayComparable;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class LongComparator
extends ByteArrayComparable {
    private long longValue;

    public LongComparator(long value) {
        super(Bytes.toBytes(value));
        this.longValue = value;
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        long that = Bytes.toLong(value, offset, length);
        return Long.compare(this.longValue, that);
    }

    @Override
    public int compareTo(ByteBuffer value, int offset, int length) {
        long that = ByteBufferUtils.toLong(value, offset);
        return Long.compare(this.longValue, that);
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.LongComparator.Builder builder = ComparatorProtos.LongComparator.newBuilder();
        builder.setComparable(ProtobufUtil.toByteArrayComparable(this.value));
        return builder.build().toByteArray();
    }

    public static LongComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.LongComparator proto;
        try {
            proto = ComparatorProtos.LongComparator.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new LongComparator(Bytes.toLong(proto.getComparable().getValue().toByteArray()));
    }

    boolean areSerializedFieldsEqual(LongComparator other) {
        if (other == this) {
            return true;
        }
        return super.areSerializedFieldsEqual(other);
    }
}

