/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.ipc;

import io.hops.hudi.org.apache.hadoop.hbase.CellScanner;
import io.hops.hudi.org.apache.hadoop.hbase.Server;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyRpcFrameDecoder;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyRpcServerPreambleHandler;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyRpcServerRequestDecoder;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyRpcServerResponseEncoder;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyServerCall;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcScheduler;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcSchedulerContext;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import io.hops.hudi.org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HRegionServer;
import io.hops.hudi.org.apache.hadoop.hbase.security.HBasePolicyProvider;
import io.hops.hudi.org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import io.hops.hudi.org.apache.hadoop.hbase.util.NettyEventLoopGroupConfig;
import io.hops.hudi.org.apache.hadoop.hbase.util.Pair;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.bootstrap.ServerBootstrap;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.Channel;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelInitializer;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ServerChannel;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.group.ChannelGroup;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.group.DefaultChannelGroup;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.FixedLengthFrameDecoder;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.concurrent.DefaultThreadFactory;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NettyRpcServer
extends RpcServer {
    public static final Logger LOG = LoggerFactory.getLogger(NettyRpcServer.class);
    public static final String HBASE_NETTY_EVENTLOOP_RPCSERVER_THREADCOUNT_KEY = "hbase.netty.eventloop.rpcserver.thread.count";
    private static final int EVENTLOOP_THREADCOUNT_DEFAULT = 0;
    private final InetSocketAddress bindAddress;
    private final CountDownLatch closed = new CountDownLatch(1);
    private final Channel serverChannel;
    private final ChannelGroup allChannels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE, true);

    public NettyRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler, boolean reservoirEnabled) throws IOException {
        super(server, name, services, bindAddress, conf, scheduler, reservoirEnabled);
        Class<? extends ServerChannel> channelClass;
        EventLoopGroup eventLoopGroup;
        this.bindAddress = bindAddress;
        if (server instanceof HRegionServer) {
            NettyEventLoopGroupConfig config = ((HRegionServer)server).getEventLoopGroupConfig();
            eventLoopGroup = config.group();
            channelClass = config.serverChannelClass();
        } else {
            int threadCount = server == null ? 0 : server.getConfiguration().getInt(HBASE_NETTY_EVENTLOOP_RPCSERVER_THREADCOUNT_KEY, 0);
            eventLoopGroup = new NioEventLoopGroup(threadCount, new DefaultThreadFactory("NettyRpcServer", true, 10));
            channelClass = NioServerSocketChannel.class;
        }
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(channelClass)).childOption(ChannelOption.TCP_NODELAY, this.tcpNoDelay).childOption(ChannelOption.SO_KEEPALIVE, this.tcpKeepAlive).childOption(ChannelOption.SO_REUSEADDR, true).childHandler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                FixedLengthFrameDecoder preambleDecoder = new FixedLengthFrameDecoder(6);
                preambleDecoder.setSingleDecode(true);
                pipeline.addLast("preambleDecoder", (ChannelHandler)preambleDecoder);
                pipeline.addLast("preambleHandler", (ChannelHandler)NettyRpcServer.this.createNettyRpcServerPreambleHandler());
                pipeline.addLast("frameDecoder", (ChannelHandler)new NettyRpcFrameDecoder(NettyRpcServer.this.maxRequestSize));
                pipeline.addLast("decoder", (ChannelHandler)new NettyRpcServerRequestDecoder(NettyRpcServer.this.allChannels, NettyRpcServer.this.metrics));
                pipeline.addLast("encoder", (ChannelHandler)new NettyRpcServerResponseEncoder(NettyRpcServer.this.metrics));
            }
        });
        try {
            this.serverChannel = bootstrap.bind(this.bindAddress).sync().channel();
            LOG.info("Bind to {}", (Object)this.serverChannel.localAddress());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        this.initReconfigurable(conf);
        this.scheduler.init(new RpcSchedulerContext(this));
    }

    @InterfaceAudience.Private
    protected NettyRpcServerPreambleHandler createNettyRpcServerPreambleHandler() {
        return new NettyRpcServerPreambleHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.authTokenSecretMgr = this.createSecretManager();
        if (this.authTokenSecretMgr != null) {
            AuthenticationTokenSecretManager authenticationTokenSecretManager = this.authTokenSecretMgr;
            synchronized (authenticationTokenSecretManager) {
                this.setSecretManager(this.authTokenSecretMgr);
                this.authTokenSecretMgr.start();
            }
        }
        this.authManager = new ServiceAuthorizationManager();
        HBasePolicyProvider.init(this.conf, this.authManager);
        this.scheduler.start();
        this.started = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        LOG.info("Stopping server on " + this.serverChannel.localAddress());
        if (this.authTokenSecretMgr != null) {
            this.authTokenSecretMgr.stop();
            this.authTokenSecretMgr = null;
        }
        this.allChannels.close().awaitUninterruptibly();
        this.serverChannel.close();
        this.scheduler.stop();
        this.closed.countDown();
        this.running = false;
    }

    @Override
    public synchronized void join() throws InterruptedException {
        this.closed.await();
    }

    @Override
    public synchronized InetSocketAddress getListenerAddress() {
        return (InetSocketAddress)this.serverChannel.localAddress();
    }

    @Override
    public void setSocketSendBufSize(int size) {
    }

    @Override
    public int getNumOpenConnections() {
        int channelsCount = this.allChannels.size();
        return channelsCount > 0 ? channelsCount - 1 : channelsCount;
    }

    @Override
    public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param2, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status) throws IOException {
        return this.call(service, md, param2, cellScanner, receiveTime, status, System.currentTimeMillis(), 0);
    }

    @Override
    public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param2, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status, long startTime, int timeout) throws IOException {
        NettyServerCall fakeCall = new NettyServerCall(-1, service, md, null, param2, cellScanner, null, -1L, null, receiveTime, timeout, this.bbAllocator, this.cellBlockBuilder, null);
        return this.call(fakeCall, status);
    }
}

