/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.ipc;

import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyRpcFrameDecoder;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyRpcServer;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyRpcServerRequestDecoder;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.Channel;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import java.nio.ByteBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerPreambleHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final NettyRpcServer rpcServer;

    public NettyRpcServerPreambleHandler(NettyRpcServer rpcServer) {
        this.rpcServer = rpcServer;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        NettyServerRpcConnection conn = this.createNettyServerRpcConnection(ctx.channel());
        ByteBuffer buf = ByteBuffer.allocate(msg.readableBytes());
        msg.readBytes(buf);
        buf.flip();
        if (!conn.processPreamble(buf)) {
            conn.close();
            return;
        }
        ChannelPipeline p = ctx.pipeline();
        ((NettyRpcFrameDecoder)p.get("frameDecoder")).setConnection(conn);
        ((NettyRpcServerRequestDecoder)p.get("decoder")).setConnection(conn);
        p.remove(this);
        p.remove("preambleDecoder");
    }

    protected NettyServerRpcConnection createNettyServerRpcConnection(Channel channel) {
        return new NettyServerRpcConnection(this.rpcServer, channel);
    }
}

