/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master;

import io.hops.hudi.org.apache.hadoop.hbase.master.MetricsMasterQuotaSource;
import io.hops.hudi.org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import io.hops.hudi.org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import io.hops.hudi.org.apache.hadoop.metrics2.MetricHistogram;
import java.util.Map;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsMasterQuotaSourceImpl
extends BaseSourceImpl
implements MetricsMasterQuotaSource {
    private final MetricsMasterWrapper wrapper;
    private final MutableGaugeLong spaceQuotasGauge;
    private final MutableGaugeLong tablesViolatingQuotasGauge;
    private final MutableGaugeLong namespacesViolatingQuotasGauge;
    private final MutableGaugeLong regionSpaceReportsGauge;
    private final MetricHistogram quotaObserverTimeHisto;
    private final MetricHistogram snapshotObserverTimeHisto;
    private final MetricHistogram snapshotObserverSizeComputationTimeHisto;
    private final MetricHistogram snapshotObserverSnapshotFetchTimeHisto;

    public MetricsMasterQuotaSourceImpl(MetricsMasterWrapper wrapper) {
        this("Quotas", "Metrics about HBase Quotas by the Master", "master", "Master,sub=Quotas", wrapper);
    }

    public MetricsMasterQuotaSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper wrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.wrapper = wrapper;
        this.spaceQuotasGauge = this.getMetricsRegistry().newGauge("numSpaceQuotas", "Number of space quotas defined", 0L);
        this.tablesViolatingQuotasGauge = this.getMetricsRegistry().newGauge("numTablesInQuotaViolation", "Number of tables violating space quotas", 0L);
        this.namespacesViolatingQuotasGauge = this.getMetricsRegistry().newGauge("numNamespaceInQuotaViolation", "Number of namespaces violating space quotas", 0L);
        this.regionSpaceReportsGauge = this.getMetricsRegistry().newGauge("numRegionSizeReports", "Number of Region sizes reported", 0L);
        this.quotaObserverTimeHisto = this.getMetricsRegistry().newTimeHistogram("quotaObserverChoreTime", "Histogram for the time in millis for the QuotaObserverChore");
        this.snapshotObserverTimeHisto = this.getMetricsRegistry().newTimeHistogram("snapshotQuotaObserverChoreTime", "Histogram for the time in millis for the SnapshotQuotaObserverChore");
        this.snapshotObserverSizeComputationTimeHisto = this.getMetricsRegistry().newTimeHistogram("snapshotObserverSizeComputationTime", "Histogram for the time in millis to compute the size of each snapshot");
        this.snapshotObserverSnapshotFetchTimeHisto = this.getMetricsRegistry().newTimeHistogram("snapshotObserverSnapshotFetchTime", "Histogram for the time in millis to fetch all snapshots from HBase");
    }

    @Override
    public void updateNumSpaceQuotas(long numSpaceQuotas) {
        this.spaceQuotasGauge.set(numSpaceQuotas);
    }

    @Override
    public void updateNumTablesInSpaceQuotaViolation(long numTablesInViolation) {
        this.tablesViolatingQuotasGauge.set(numTablesInViolation);
    }

    @Override
    public void updateNumNamespacesInSpaceQuotaViolation(long numNamespacesInViolation) {
        this.namespacesViolatingQuotasGauge.set(numNamespacesInViolation);
    }

    @Override
    public void updateNumCurrentSpaceQuotaRegionSizeReports(long numCurrentRegionSizeReports) {
        this.regionSpaceReportsGauge.set(numCurrentRegionSizeReports);
    }

    @Override
    public void incrementSpaceQuotaObserverChoreTime(long time) {
        this.quotaObserverTimeHisto.add(time);
    }

    @Override
    public void incrementSnapshotObserverChoreTime(long time) {
        this.snapshotObserverTimeHisto.add(time);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder record = metricsCollector.addRecord(this.metricsRegistry.info());
        if (this.wrapper != null) {
            Map<String, Map.Entry<Long, Long>> tableUsages = this.wrapper.getTableSpaceUtilization();
            String tableSummary = "[]";
            if (tableUsages != null && !tableUsages.isEmpty()) {
                tableSummary = this.generateJsonQuotaSummary(tableUsages.entrySet(), "table");
            }
            record.tag(Interns.info((String)"tableSpaceQuotaOverview", (String)"A JSON summary of the usage of all tables with space quotas"), tableSummary);
            String nsSummary = "[]";
            Map<String, Map.Entry<Long, Long>> namespaceUsages = this.wrapper.getNamespaceSpaceUtilization();
            if (namespaceUsages != null && !namespaceUsages.isEmpty()) {
                nsSummary = this.generateJsonQuotaSummary(namespaceUsages.entrySet(), "namespace");
            }
            record.tag(Interns.info((String)"namespaceSpaceQuotaOverview", (String)"A JSON summary of the usage of all namespaces with space quotas"), nsSummary);
        }
        this.metricsRegistry.snapshot(record, all);
    }

    private String generateJsonQuotaSummary(Iterable<Map.Entry<String, Map.Entry<Long, Long>>> data, String target) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map.Entry<Long, Long>> tableUsage : data) {
            String tableName = tableUsage.getKey();
            long usage = tableUsage.getValue().getKey();
            long limit = tableUsage.getValue().getValue();
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("{").append(target).append("=").append(tableName).append(", usage=").append(usage).append(", limit=").append(limit).append("}");
        }
        sb.insert(0, "[").append("]");
        return sb.toString();
    }

    @Override
    public void incrementSnapshotObserverSnapshotComputationTime(long time) {
        this.snapshotObserverSizeComputationTimeHisto.add(time);
    }

    @Override
    public void incrementSnapshotObserverSnapshotFetchTime(long time) {
        this.snapshotObserverSnapshotFetchTimeHisto.add(time);
    }
}

