/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master;

import io.hops.hudi.org.apache.hadoop.hbase.master.MetricsMasterSource;
import io.hops.hudi.org.apache.hadoop.hbase.master.MetricsMasterWrapper;
import io.hops.hudi.org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import io.hops.hudi.org.apache.hadoop.hbase.metrics.Interns;
import io.hops.hudi.org.apache.hadoop.hbase.metrics.OperationMetrics;
import io.hops.hudi.org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsMasterSourceImpl
extends BaseSourceImpl
implements MetricsMasterSource {
    private final MetricsMasterWrapper masterWrapper;
    private MutableFastCounter clusterRequestsCounter;
    private OperationMetrics serverCrashMetrics;

    public MetricsMasterSourceImpl(MetricsMasterWrapper masterWrapper) {
        this("Server", "Metrics about HBase master server", "master", "Master,sub=Server", masterWrapper);
    }

    public MetricsMasterSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsMasterWrapper masterWrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.masterWrapper = masterWrapper;
    }

    @Override
    public void init() {
        super.init();
        this.clusterRequestsCounter = this.metricsRegistry.newCounter("clusterRequests", "", 0L);
        this.serverCrashMetrics = new OperationMetrics(this.registry, "serverCrash");
    }

    @Override
    public void incRequests(long inc) {
        this.clusterRequestsCounter.incr(inc);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsCollector.addRecord(this.metricsName);
        if (this.masterWrapper != null && this.masterWrapper.isRunning()) {
            metricsRecordBuilder.addGauge(Interns.info("mergePlanCount", "Number of Region Merge Plans executed"), this.masterWrapper.getMergePlanCount()).addGauge(Interns.info("splitPlanCount", "Number of Region Split Plans executed"), this.masterWrapper.getSplitPlanCount()).addGauge(Interns.info("masterActiveTime", "Master Active Time"), this.masterWrapper.getActiveTime()).addGauge(Interns.info("masterStartTime", "Master Start Time"), this.masterWrapper.getStartTime()).addGauge(Interns.info("masterFinishedInitializationTime", "Timestamp when Master has finished initializing"), this.masterWrapper.getMasterInitializationTime()).addGauge(Interns.info("averageLoad", "AverageLoad"), this.masterWrapper.getAverageLoad()).tag(Interns.info("liveRegionServers", "Names of live RegionServers"), this.masterWrapper.getRegionServers()).addGauge(Interns.info("numRegionServers", "Number of RegionServers"), this.masterWrapper.getNumRegionServers()).tag(Interns.info("deadRegionServers", "Names of dead RegionServers"), this.masterWrapper.getDeadRegionServers()).addGauge(Interns.info("numDeadRegionServers", "Number of dead RegionServers"), this.masterWrapper.getNumDeadRegionServers()).tag(Interns.info("draininigRegionServers", "Names of draining RegionServers"), this.masterWrapper.getDrainingRegionServers()).addGauge(Interns.info("numDrainingRegionServers", "Number of RegionServers"), this.masterWrapper.getNumDrainingRegionServers()).tag(Interns.info("zookeeperQuorum", "ZooKeeper Quorum"), this.masterWrapper.getZookeeperQuorum()).tag(Interns.info("serverName", "Server Name"), this.masterWrapper.getServerName()).tag(Interns.info("clusterId", "Cluster Id"), this.masterWrapper.getClusterId()).tag(Interns.info("isActiveMaster", "Is Active Master"), String.valueOf(this.masterWrapper.getIsActiveMaster()));
        }
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
        if (this.metricsAdapter != null) {
            this.metricsAdapter.snapshotAllMetrics(this.registry, metricsRecordBuilder);
        }
    }

    @Override
    public OperationMetrics getServerCrashMetrics() {
        return this.serverCrashMetrics;
    }
}

